/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase.ioc;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.matcher.Matchers;
import de.julielab.geneexpbase.TermNormalizer;
import de.julielab.geneexpbase.configuration.Configuration;
import de.julielab.geneexpbase.data.DocumentLoader;
import de.julielab.geneexpbase.ioc.LifeCycleListener;
import de.julielab.geneexpbase.ioc.ServicesShutdownHub;
import de.julielab.geneexpbase.services.CacheService;
import de.julielab.geneexpbase.services.ShutdownRequiringExecutorService;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Named;
import javax.inject.Singleton;

public class BaseModule
extends AbstractModule {
    public static final String ID_INFERENCE = "IdInference";
    private final Configuration configuration;

    public BaseModule(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    protected void configure() {
        super.configure();
        this.bind(Configuration.class).toInstance(this.configuration);
        this.bind(TermNormalizer.class);
        this.bind(DocumentLoader.class);
        this.bind(CacheService.class).in(Singleton.class);
        ServicesShutdownHub shutdownHub = new ServicesShutdownHub();
        this.bind(ServicesShutdownHub.class).toInstance(shutdownHub);
        this.bindListener(Matchers.any(), new LifeCycleListener(shutdownHub));
    }

    @Provides
    @Named(value="gene_orthologs")
    File provideGeneOrthologsFile(Configuration configuration) {
        String orthologsPath = configuration.getProperty("gene_orthologs");
        if (orthologsPath == null) {
            return null;
        }
        return new File(orthologsPath);
    }

    @Provides
    @Singleton
    ExecutorService provideExecutorService() {
        int luceneConcurrencyLevel = Integer.parseInt((String)this.configuration.getOrDefault((Object)"concurrency_level", "1"));
        ShutdownRequiringExecutorService executorService = new ShutdownRequiringExecutorService(Executors.newFixedThreadPool(luceneConcurrencyLevel));
        return executorService;
    }
}

