/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase.hpo;

import com.google.common.collect.Sets;
import de.julielab.evaluation.entities.EntityEvaluationResult;
import de.julielab.evaluation.entities.EvaluationMode;
import de.julielab.geneexpbase.candidateretrieval.CandidateRetrieval;
import de.julielab.geneexpbase.candidateretrieval.QueryGenerator;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.hpo.HpoInstance;
import de.julielab.geneexpbase.hpo.HpoRoute;
import de.julielab.java.utilities.Color;
import de.julielab.java.utilities.FileUtilities;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class InspectionFilePrinter {
    private final Function<GeneMention, GeneDocument.MentionCorrectness> correctnessFunction;
    private final Function<GeneMention, String> correctIdRenderer;
    private final Function<GeneMention, String> wrongIdRenderer;
    private final Function<GeneMention, String> fpRenderer;
    private final Function<GeneMention, Stream<String>> geneMentionGoldIdFunction;
    private final Function<GeneDocument, Stream<String>> documentGoldIdFunction;
    private final Function<GeneMention, Stream<String>> predictedIdFunction;

    public InspectionFilePrinter(Function<GeneMention, GeneDocument.MentionCorrectness> correctnessFunction, Function<GeneMention, String> correctIdRenderer, Function<GeneMention, String> wrongIdRenderer, Function<GeneMention, String> fpRenderer, Function<GeneMention, Stream<String>> geneMentionGoldIdFunction, Function<GeneDocument, Stream<String>> documentGoldIdFunction, Function<GeneMention, Stream<String>> predictedIdFunction) {
        this.correctnessFunction = correctnessFunction;
        this.correctIdRenderer = correctIdRenderer;
        this.wrongIdRenderer = wrongIdRenderer;
        this.fpRenderer = fpRenderer;
        this.geneMentionGoldIdFunction = geneMentionGoldIdFunction;
        this.documentGoldIdFunction = documentGoldIdFunction;
        this.predictedIdFunction = predictedIdFunction;
    }

    public static Color getHighlightColor(double score) {
        if (score < 0.4) {
            return Color.RED;
        }
        if (score < 0.6) {
            return Color.MAGENTA;
        }
        return Color.GREEN;
    }

    private static void resetDocument(GeneDocument d) {
        d.reset();
        d.getGenes().forEach(gm -> {
            gm.setIds(new ArrayList<String>());
            gm.setTaxonomyIds(new ArrayList<String>());
        });
        d.addState(GeneDocument.State.GENES_SELECTED);
        d.addState(GeneDocument.State.SPECIES_MENTIONS_SET);
        d.addState(GeneDocument.State.REFERENCE_SPECIES_ADDED);
    }

    public void printInspectionFile(EntityEvaluationResult result, String idType, HpoRoute.Metric fileNameMetric, HpoInstance hpoInstance, List<GeneDocument> documents, CandidateRetrieval candidateRetrievalForInspections, QueryGenerator queryGenerator) {
        double fileMetricValue;
        Function<EntityEvaluationResult, Double> f;
        Function<EntityEvaluationResult, Double> p;
        Function<EntityEvaluationResult, Double> r;
        if (result.getEvaluationMode() == EvaluationMode.MENTION) {
            r = e -> e.getMicroRecallMentionWise();
            p = e -> e.getMicroPrecisionMentionWise();
            f = e -> e.getMicroFMeasureMentionWise();
        } else {
            r = e -> e.getMicroRecallDocWise();
            p = e -> e.getMicroPrecisionDocWise();
            f = e -> e.getMicroFMeasureDocWise();
        }
        double overallF = f.apply(result);
        switch (fileNameMetric) {
            case RECALL: 
            case RECALL_REJECTION: 
            case NDCG: 
            case MAX_RECALL: {
                fileMetricValue = r.apply(result);
                break;
            }
            case PRECISION: 
            case PRECISION_REJECTION: {
                fileMetricValue = p.apply(result);
                break;
            }
            case F: 
            case F_REJECTION: {
                fileMetricValue = f.apply(result);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported file name metric: " + fileNameMetric);
            }
        }
        DecimalFormat df = new DecimalFormat("0.##");
        File output = Path.of("inspectionfiles-" + idType, hpoInstance.toString() + "-" + df.format(fileMetricValue) + ".txt").toFile();
        if (!output.getParentFile().exists()) {
            output.getParentFile().mkdirs();
        }
        Function<GeneDocument, Set> goldWithOffsetIdFunction = d -> d.getGoldGenes().values().stream().flatMap(Collection::stream).flatMap(this.geneMentionGoldIdFunction).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        Function<GeneDocument, Set> goldNoOffsetIdFunction = d -> this.documentGoldIdFunction.apply((GeneDocument)d).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        Function<GeneDocument, Set> goldIdFunction = d -> d.isGoldHasOffsets() ? (Set)goldWithOffsetIdFunction.apply((GeneDocument)d) : (Set)goldNoOffsetIdFunction.apply((GeneDocument)d);
        Map<GeneDocument.MentionCorrectness, Function<GeneMention, String>> renderMap = Map.of(GeneDocument.MentionCorrectness.CORRECT_ID, this.correctIdRenderer, GeneDocument.MentionCorrectness.WRONG_ID, this.wrongIdRenderer, GeneDocument.MentionCorrectness.CANT_FIND, this.fpRenderer);
        try (BufferedWriter bw = FileUtilities.getWriterToFile(output);){
            bw.write("Instance: " + hpoInstance);
            bw.newLine();
            bw.write(String.format("Overall score [R/P/F]: %s%.2f, %.2f, %.2f%s", new Object[]{Color.RED, r.apply(result), p.apply(result), overallF, Color.RESET}));
            bw.newLine();
            bw.newLine();
            for (GeneDocument d2 : documents) {
                double rd = result.getRecall(d2.getId());
                double pd = result.getPrecision(d2.getId());
                double fd = result.getFMeasure(d2.getId());
                Color rcol = InspectionFilePrinter.getHighlightColor(rd);
                Color pcol = InspectionFilePrinter.getHighlightColor(pd);
                Color fcol = InspectionFilePrinter.getHighlightColor(fd);
                bw.write(String.format("%s [R/P/F]: %2$s%5$.2f, %3$s%6$.2f, %4$s%7$.2f%8$s", new Object[]{d2.getId(), rcol, pcol, fcol, rd, pd, fd, Color.RESET}));
                bw.newLine();
                Set goldIds = goldIdFunction.apply(d2);
                Set predictedIds = d2.getNonRejectedGenes().flatMap(this.predictedIdFunction).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
                Sets.SetView fps = Sets.difference(predictedIds, goldIds);
                Sets.SetView fns = Sets.difference(goldIds, predictedIds);
                bw.write("Gold tax IDs in doc: " + goldIds.stream().collect(Collectors.joining(" ")));
                bw.newLine();
                bw.write("Predicted IDs in doc: " + predictedIds.stream().collect(Collectors.joining(" ")));
                bw.newLine();
                bw.write("Missing IDs doclevel: " + fns.stream().collect(Collectors.joining(", ")));
                bw.newLine();
                bw.write("Wrong IDs doclevel: " + fps.stream().collect(Collectors.joining(", ")));
                bw.newLine();
                bw.write(d2.getInspectionText(this.correctnessFunction, renderMap));
                bw.newLine();
                bw.newLine();
                InspectionFilePrinter.resetDocument(d2);
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }
}

