/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase.hpo;

import de.julielab.geneexpbase.hpo.HPOEvaluationException;
import de.julielab.geneexpbase.hpo.HpoRoute;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Spark;

public class HttpParamOptServer {
    public static final String INSTANCE = "instance";
    public static final String INSTANCE_INFO = "instance_info";
    public static final String CUTOFF_TIME = "cutoff_time";
    public static final String CUTOFF_LENGTH = "cutoff_length";
    public static final String SEED = "seed";
    public static final String RETURN_METRIC = "return_metric";
    public static final String TRIAL_BUDGET = "TRIAL_BUDGET";
    public static final String MAX_BUDGET = "max_budget";
    private final Logger log;
    protected List<? extends HpoRoute> routes = Collections.emptyList();

    public HttpParamOptServer(Logger log, int port) {
        this.log = log;
        log.info("Setting max threads to 20");
        Spark.threadPool(20);
        Spark.port(port);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: " + HttpParamOptServer.class.getSimpleName() + " <http port>");
            System.exit(1);
        }
        int port = Integer.parseInt(args[0]);
        HttpParamOptServer server = new HttpParamOptServer(LoggerFactory.getLogger(HttpParamOptServer.class), port);
        server.startServer();
    }

    public void startServer() {
        System.out.println(this.routes);
        for (HpoRoute hpoRoute : this.routes) {
            Spark.post("/" + hpoRoute.getRouteEndpoint(), hpoRoute);
        }
        Spark.exception(HPOEvaluationException.class, (exception, request, response) -> {
            response.body(exception.getMessage());
            response.status(500);
        });
        this.log.info("Server is ready for requests.");
    }
}

