/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase.hpo;

import de.julielab.geneexpbase.configuration.Configuration;
import de.julielab.geneexpbase.configuration.Parameters;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class HttpParamOptClient {
    public static String requestScoreFromServer(Map<String, Object> configuration, String instance, String instanceInfo, String endpoint, int port) throws IOException {
        String line;
        String urlString = "http://localhost:" + port + "/" + endpoint;
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
        String data = String.format("instance=%s&cutoff_time=9000&cutoff_length=0&seed=1", instance);
        StringBuilder sb = new StringBuilder(data);
        for (String key : configuration.keySet()) {
            sb.append("&").append(key.startsWith("-") ? key.substring(1) : key).append("=").append(configuration.get(key));
        }
        writer.write(sb.toString());
        writer.flush();
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        String result = null;
        while ((line = reader.readLine()) != null) {
            if (line.isBlank()) continue;
            result = line;
        }
        writer.close();
        reader.close();
        return result;
    }

    protected abstract String getConfigurationPath();

    protected abstract String getEvaluationEndpoint();

    protected abstract List<String> getInstances();

    protected abstract int getPort();

    public void printEvaluationResult() throws IOException {
        Configuration configuration = new Configuration(new File(this.getConfigurationPath()));
        Parameters parameters = new Parameters(configuration);
        String endpoint = this.getEvaluationEndpoint();
        List<String> instances = this.getInstances();
        ArrayList<String> results = new ArrayList<String>();
        for (String instance : instances) {
            String instanceInfo = "";
            String[] s2 = instance.split(" ");
            if (s2.length > 1) {
                instanceInfo = s2[1];
            }
            String result = HttpParamOptClient.requestScoreFromServer(parameters, s2[0], instanceInfo, endpoint, this.getPort());
            results.add(result);
        }
        for (int i = 0; i < results.size(); ++i) {
            System.out.println(instances.get(i) + ": " + (String)results.get(i));
        }
        System.out.println("Avg: " + results.stream().mapToDouble(Double::parseDouble).average());
    }
}

