/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase.hpo;

import de.julielab.geneexpbase.hpo.SplitType;
import java.io.Serializable;

public class HpoInstance
implements Serializable {
    private static final long serialVersionUID = 295952L;
    private final String corpus;
    private final String subcorpus;
    private boolean mergeCorpora;
    private SplitType splitType;
    private int crossvalRound;
    private final String instanceInfo;

    public HpoInstance(String corpus, String subcorpus, boolean mergeCorpora, SplitType splitType, int crossvalRound, String instanceInfo) {
        this.corpus = corpus;
        this.subcorpus = subcorpus;
        this.mergeCorpora = mergeCorpora;
        this.splitType = splitType;
        this.crossvalRound = crossvalRound;
        this.instanceInfo = instanceInfo;
    }

    public HpoInstance(String corpus, String subcorpus, SplitType splitType, int crossvalRound) {
        this(corpus, subcorpus, false, splitType, crossvalRound, null);
    }

    public HpoInstance(String corpus, String subcorpus) {
        this(corpus, subcorpus, null, -1);
    }

    public String getInstanceInfo() {
        return this.instanceInfo;
    }

    public String getCorpus() {
        return this.corpus;
    }

    public String getSubcorpus() {
        return this.subcorpus;
    }

    public SplitType getSplitType() {
        return this.splitType;
    }

    public void setSplitType(SplitType splitType) {
        this.splitType = splitType;
    }

    public int getCrossvalRound() {
        return this.crossvalRound;
    }

    public void setCrossvalRound(int crossvalRound) {
        this.crossvalRound = crossvalRound;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.splitType != null && this.crossvalRound > -1) {
            sb.append(this.corpus).append("-").append(this.subcorpus).append("-").append((Object)this.splitType).append("-").append(this.crossvalRound);
        } else if (this.splitType != null) {
            sb.append(this.corpus).append("-").append(this.subcorpus).append("-").append((Object)this.splitType);
        }
        if (this.instanceInfo != null && !this.instanceInfo.isBlank() && !this.instanceInfo.equals("none")) {
            sb.append("-").append(this.instanceInfo);
        }
        return sb.toString();
    }

    public boolean isMergeCorpora() {
        return this.mergeCorpora;
    }

    public void mergeCorpora(boolean b) {
        this.mergeCorpora = b;
    }
}

