/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase.genemodel;

import de.julielab.geneexpbase.genemodel.SpeciesMention;
import de.julielab.java.utilities.spanutils.OffsetMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import org.apache.commons.lang3.Range;

public class SpeciesCandidates
implements Cloneable {
    private OffsetMap<SpeciesMention> titleCandidates;
    private Set<String> meshCandidates;
    private OffsetMap<SpeciesMention> textCandidates;

    public SpeciesCandidates(OffsetMap<SpeciesMention> titleCandidates, Set<String> meshCandidates, OffsetMap<SpeciesMention> textCandidates) {
        this.titleCandidates = titleCandidates;
        this.meshCandidates = meshCandidates;
        this.textCandidates = textCandidates;
    }

    public SpeciesCandidates(int titleBegin, int titleEnd, Set<String> meshCandidates, OffsetMap<SpeciesMention> textCandidates) {
        this.textCandidates = textCandidates;
        if (null == textCandidates) {
            this.textCandidates = OffsetMap.emptyOffsetMap();
        }
        this.titleCandidates = new OffsetMap<SpeciesMention>((SortedMap<Range<Integer>, SpeciesMention>)this.textCandidates.restrictTo(Range.between(titleBegin, titleEnd)));
        this.meshCandidates = meshCandidates;
    }

    protected SpeciesCandidates clone() {
        OffsetMap<SpeciesMention> titleCandidates = this.titleCandidates != null ? new OffsetMap<SpeciesMention>((SortedMap<Range<Integer>, SpeciesMention>)this.titleCandidates) : OffsetMap.emptyOffsetMap();
        HashSet<String> meshCandidates = this.meshCandidates != null ? new HashSet<String>(this.meshCandidates) : Collections.emptySet();
        OffsetMap<SpeciesMention> textCandidates = this.textCandidates != null ? new OffsetMap<SpeciesMention>((SortedMap<Range<Integer>, SpeciesMention>)this.textCandidates) : OffsetMap.emptyOffsetMap();
        return new SpeciesCandidates(titleCandidates, meshCandidates, textCandidates);
    }

    public OffsetMap<SpeciesMention> getAllMentionCandidates() {
        OffsetMap<SpeciesMention> allMentionCandidates = new OffsetMap<SpeciesMention>();
        if (this.titleCandidates != null) {
            allMentionCandidates.putAll(this.titleCandidates);
        }
        if (this.textCandidates != null) {
            allMentionCandidates.putAll(this.textCandidates);
        }
        return allMentionCandidates;
    }

    public OffsetMap<SpeciesMention> getTitleCandidates() {
        return this.titleCandidates;
    }

    public void setTitleCandidates(OffsetMap<SpeciesMention> titleCandidates) {
        this.titleCandidates = titleCandidates;
    }

    public Set<String> getMeshCandidates() {
        return this.meshCandidates;
    }

    public void setMeshCandidates(Set<String> meshCandidates) {
        this.meshCandidates = meshCandidates;
    }

    public OffsetMap<SpeciesMention> getTextCandidates() {
        return this.textCandidates;
    }

    public void setTextCandidates(OffsetMap<SpeciesMention> textCandidates) {
        this.textCandidates = textCandidates;
    }
}

