/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase.genemodel;

import java.io.Serializable;

public class OrthologyRecord
implements Serializable {
    private final String taxId;
    private final String geneId;
    private final String otherTaxId;
    private final String otherGeneId;

    OrthologyRecord(String geneOrthologyLine) {
        if (geneOrthologyLine.startsWith("#")) {
            throw new IllegalArgumentException("The line " + geneOrthologyLine + " is a comment and not an orthology record.");
        }
        String[] split = geneOrthologyLine.split("\\t");
        this.taxId = split[0].trim().intern();
        this.geneId = split[1].trim().intern();
        this.otherTaxId = split[3].trim().intern();
        this.otherGeneId = split[4].trim().intern();
    }

    public String toString() {
        return "OrthologyRecord{taxId='" + this.taxId + "', geneId='" + this.geneId + "', otherTaxId='" + this.otherTaxId + "', otherGeneId='" + this.otherGeneId + "'}";
    }

    public String getTaxId() {
        return this.taxId;
    }

    public String getGeneId() {
        return this.geneId;
    }

    public String getOtherTaxId() {
        return this.otherTaxId;
    }

    public String getOtherGeneId() {
        return this.otherGeneId;
    }

    public String getGeneIdNotEqualTo(String geneId) {
        boolean eqGeneId = geneId.equals(this.geneId);
        boolean eqOtherGeneId = geneId.equals(this.otherGeneId);
        if (eqGeneId && eqOtherGeneId) {
            throw new IllegalArgumentException("The gene ID " + geneId + " is not a part of this record: " + this);
        }
        if (eqGeneId) {
            return this.otherGeneId;
        }
        return this.geneId;
    }

    public String getGeneIdForTaxId(String taxId) {
        assert (taxId != null) : "The passed taxonomy ID is null.";
        if (taxId.equals(this.taxId)) {
            return this.geneId;
        }
        if (taxId.equals(this.otherTaxId)) {
            return this.otherGeneId;
        }
        throw new IllegalArgumentException("The taxonomy ID " + taxId + " is not part of this record: " + this);
    }
}

