/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase.genemodel;

import de.julielab.geneexpbase.GeneExpRuntimeException;
import de.julielab.geneexpbase.candidateretrieval.SynHit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class MeshHeading
implements Cloneable {
    private String heading;
    private List<SynHit> geneSynonymHits;
    private List<String> taxonomyIds;

    public MeshHeading(String heading) {
        this.heading = heading;
    }

    public String getHeading() {
        return this.heading;
    }

    public void setHeading(String heading) {
        this.heading = heading;
    }

    public List<SynHit> getGeneSynonymHits() {
        return this.geneSynonymHits;
    }

    public void setGeneSynonymHits(List<SynHit> geneSynonymHits) {
        this.geneSynonymHits = geneSynonymHits;
    }

    public List<String> getTaxonomyIds() {
        return this.taxonomyIds == null ? Collections.emptyList() : this.taxonomyIds;
    }

    public void setTaxonomyIds(List<String> taxonomyIds) {
        this.taxonomyIds = taxonomyIds;
    }

    public void addTaxonomyId(String taxId) {
        if (this.taxonomyIds == null) {
            this.taxonomyIds = new ArrayList<String>();
        }
        this.taxonomyIds.add(taxId);
    }

    protected MeshHeading clone() {
        try {
            MeshHeading clone = (MeshHeading)super.clone();
            clone.geneSynonymHits = this.geneSynonymHits != null ? this.geneSynonymHits.stream().map(sh -> sh.clone()).collect(Collectors.toList()) : null;
            clone.taxonomyIds = this.taxonomyIds != null ? new ArrayList<String>(this.taxonomyIds) : null;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new GeneExpRuntimeException(e);
        }
    }

    public String toString() {
        return "MeshHeading{heading='" + this.heading + "', geneSynonymHits=" + this.geneSynonymHits + ", taxonomyIds=" + this.taxonomyIds + "}";
    }
}

