/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase.genemodel;

import cc.mallet.types.InstanceList;
import de.julielab.geneexpbase.candidateretrieval.SynHit;
import de.julielab.geneexpbase.genemodel.GeneIdCandidate;
import de.julielab.geneexpbase.genemodel.GeneMention;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MentionMappingResult
implements Comparable<MentionMappingResult> {
    public static final SynHit REJECTION = new RejectionSynHit("GENE MENTION REJECTED", 0.0, "NoId", MentionMappingResult.class.getSimpleName());
    @Deprecated
    public List<SynHit> resultEntries = Collections.emptyList();
    public int ambiguityDegree;
    public MatchType matchType;
    public GeneMention mappedMention;
    public List<GeneIdCandidate> geneIdCandidates;
    public Map<String, List<SynHit>> tax2originalCandidates;
    public Map<String, List<SynHit>> tax2lexicallyRerankedCandidates;
    public Map<String, List<SynHit>> tax2semanticallyOrderedCandidates;
    public Map<String, List<SynHit>> tax2balancedScoreOrderedCandidates;
    public Map<String, List<SynHit>> tax2finalRankedCandidates = new HashMap<String, List<SynHit>>();
    public double confidence;
    public HashMap<String, List<SynHit>> tax2bestCandidates;
    public Map<String, InstanceList> tax2candidateRankingInstances;
    @Deprecated
    public Map<String, InstanceList> tax2originalCandidateRankingInstances;
    public List<SynHit> candidatesNoTaxRestriction;
    private long candidateRetrievalTime;
    private long disambiguationTime;
    private Map<String, RejectReason> rejectReasons;

    public MentionMappingResult() {
    }

    public MentionMappingResult(GeneMention mappedMention) {
        this.mappedMention = mappedMention;
    }

    public MentionMappingResult(MentionMappingResult othermr) {
        this.resultEntries = othermr.resultEntries == null ? null : othermr.resultEntries.stream().map(SynHit::clone).collect(Collectors.toList());
        this.ambiguityDegree = othermr.ambiguityDegree;
        this.matchType = othermr.matchType;
        this.mappedMention = othermr.mappedMention;
        if (othermr.geneIdCandidates != null) {
            this.geneIdCandidates = new ArrayList<GeneIdCandidate>(othermr.geneIdCandidates);
        }
        if (othermr.tax2originalCandidates != null) {
            this.tax2originalCandidates = new HashMap<String, List<SynHit>>(othermr.tax2originalCandidates);
        }
        if (othermr.tax2lexicallyRerankedCandidates != null) {
            this.tax2lexicallyRerankedCandidates = new HashMap<String, List<SynHit>>(othermr.tax2lexicallyRerankedCandidates);
        }
        if (othermr.tax2semanticallyOrderedCandidates != null) {
            this.tax2semanticallyOrderedCandidates = new HashMap<String, List<SynHit>>(othermr.tax2semanticallyOrderedCandidates);
        }
        if (othermr.tax2finalRankedCandidates != null) {
            this.tax2finalRankedCandidates = new HashMap<String, List<SynHit>>(othermr.tax2finalRankedCandidates);
        }
        this.confidence = othermr.confidence;
        this.candidateRetrievalTime = othermr.candidateRetrievalTime;
        this.disambiguationTime = othermr.disambiguationTime;
        this.rejectReasons = othermr.rejectReasons;
        if (othermr.tax2candidateRankingInstances != null) {
            this.tax2candidateRankingInstances = new HashMap<String, InstanceList>(othermr.tax2candidateRankingInstances);
        }
    }

    public void addResultEntry(SynHit resultEntry) {
        if (this.resultEntries.isEmpty()) {
            this.resultEntries = new ArrayList<SynHit>();
        }
        this.resultEntries.add(resultEntry);
    }

    @Override
    public int compareTo(MentionMappingResult o) {
        return this.resultEntries.get(0).compareTo(o.resultEntries.get(0));
    }

    public long getCandidateRetrievalTime() {
        return this.candidateRetrievalTime;
    }

    public void setCandidateRetrievalTime(long candidateRetrievalTime) {
        this.candidateRetrievalTime = candidateRetrievalTime;
    }

    public long getDisambiguationTime() {
        return this.disambiguationTime;
    }

    public void setDisambiguationTime(long disambiguationTime) {
        this.disambiguationTime = disambiguationTime;
    }

    public RejectReason getRejectReasons(String taxId) {
        return this.rejectReasons.get(taxId);
    }

    public boolean hasCandidates() {
        return this.tax2originalCandidates != null && !this.tax2originalCandidates.values().isEmpty();
    }

    public void setRejectReason(String taxId, RejectReason rejectReason) {
        if (this.rejectReasons == null) {
            this.rejectReasons = new HashMap<String, RejectReason>();
        }
        this.rejectReasons.put(taxId, rejectReason);
    }

    public boolean isRejected() {
        return this.tax2originalCandidates != null && !this.tax2originalCandidates.isEmpty() && !this.tax2originalCandidates.values().stream().flatMap(Collection::stream).anyMatch(Predicate.not(SynHit::isRejectionCandidate)) || this.tax2lexicallyRerankedCandidates != null && !this.tax2lexicallyRerankedCandidates.isEmpty() && !this.tax2lexicallyRerankedCandidates.values().stream().flatMap(Collection::stream).anyMatch(Predicate.not(SynHit::isRejectionCandidate)) || this.tax2finalRankedCandidates != null && !this.tax2finalRankedCandidates.isEmpty() && !this.tax2finalRankedCandidates.values().stream().flatMap(Collection::stream).anyMatch(Predicate.not(SynHit::isRejectionCandidate));
    }

    public void removeRejectReason(String taxId) {
        if (this.rejectReasons != null) {
            this.rejectReasons.remove(taxId);
        }
    }

    public void setFinalRankedCandidates(String taxId, List<SynHit> candidates) {
        this.tax2finalRankedCandidates.put(taxId, candidates);
    }

    public SynHit getResultCandidate(String taxonomyId) {
        assert (this.tax2finalRankedCandidates != null) : "The map holding final ranked candidates is null";
        List<SynHit> rankedCandidates = this.tax2finalRankedCandidates.get(taxonomyId);
        assert (rankedCandidates != null && !rankedCandidates.isEmpty()) : "There is no result candidate for taxonomy ID " + taxonomyId;
        return rankedCandidates.get(0);
    }

    public Stream<SynHit> getResultCandidates() {
        assert (this.tax2finalRankedCandidates != null) : "The map holding final ranked candidates is null";
        return this.tax2finalRankedCandidates.values().stream().map(l -> l.isEmpty() ? null : (SynHit)l.get(0)).filter(Objects::nonNull);
    }

    public boolean hasExactCandidateMatch() {
        return this.tax2originalCandidates.keySet().stream().map(this.tax2originalCandidates::get).flatMap(Collection::stream).anyMatch(SynHit::isExactMatch);
    }

    public static class RejectionSynHit
    extends SynHit {
        private RejectionSynHit(String syn, double score, String xid, String source) {
            super(syn, score, xid, source);
        }

        @Override
        public boolean isRejectionCandidate() {
            return true;
        }

        @Override
        public double getLexicalScore() {
            return -1.7976931348623157E308;
        }

        @Override
        public String getSynonym() {
            throw new IllegalStateException("This is the rejection SynHit, it should only be used as a constant to check if a gene mention is rejected.");
        }

        @Override
        public String getSource() {
            throw new IllegalStateException("This is the rejection SynHit, it should only be used as a constant to check if a gene mention is rejected.");
        }

        @Override
        public String getMappedMention() {
            throw new IllegalStateException("This is the rejection SynHit, it should only be used as a constant to check if a gene mention is rejected.");
        }

        @Override
        public boolean isExactMatch() {
            return false;
        }

        @Override
        public List<String> getTaxIds() {
            throw new IllegalStateException("This is the rejection SynHit, it should only be used as a constant to check if a gene mention is rejected.");
        }
    }

    public static enum MatchType {
        APPROX,
        EXACT;

    }

    public static enum RejectReason {
        NO_CANDIDATES,
        DISAMBIGUATION_HAD_NO_RESULT,
        DISAMBIGUATION_BELOW_THRESHOLD,
        MENTION_SCORE_BELOW_THRESHOLD,
        REJECTION_MAJORITY_VOTE,
        FOUND_FAMILY,
        FAMILY_WORD_IN_NP,
        TAX_FILTERED_CANDIDATES_EMPTY,
        NO_CANDIDATES_AFTER_GS_CONTRADICTION_RESOLUTION,
        IS_FAMILY,
        IS_CELL,
        IS_NON_GENE_WORD,
        IS_COMPLEX,
        IS_GROUP,
        IS_BIO_THESAURUS,
        IS_UNSPECIFIC,
        HAS_SAME_TEXT_AS_OTHER_UNSPECIFIC_MENTION,
        FAILED_TO_UNREJECT,
        NOT_MAPPED;

    }
}

