/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase.genemodel;

import de.julielab.geneexpbase.genemodel.GeneSet;
import java.util.Comparator;
import java.util.Optional;
import java.util.TreeSet;

public class GeneSets
extends TreeSet<GeneSet> {
    private static final long serialVersionUID = -6355234489729844255L;

    public GeneSets() {
        super(Comparator.comparingInt(GeneSet::getSmallestGeneBegin).thenComparingInt(System::identityHashCode));
    }

    public GeneSet getGeneSet(String taxId) {
        Optional<GeneSet> any = this.stream().filter(gs -> gs.getTaxId().equals(taxId)).findAny();
        if (!any.isPresent()) {
            throw new IllegalArgumentException("These gene sets do not contain a gene set for taxonomy ID " + taxId);
        }
        return any.get();
    }
}

