/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase.genemodel;

import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import de.julielab.geneexpbase.candidateretrieval.SynHit;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.GeneSpeciesOccurrence;
import de.julielab.geneexpbase.genemodel.MentionMappingResult;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GeneSet
extends TreeSet<GeneMention> {
    private static final long serialVersionUID = -4038206150665551536L;
    private List<SynHit> setId;
    private FeatureVector featureVector;
    private GeneMention.SpecificType specificType;
    private boolean isPlural;
    private Instance instance;
    private double specificTypeConfidence;
    private String docId;
    private Map<String, Map<String, Double>> id2contextScores = Collections.emptyMap();
    private GeneSet geneSet;
    private MentionMappingResult.RejectReason rejectReason;
    private List<SynHit> familyNames;
    private MentionMappingResult mentionMappingResult;
    private int number;
    private String taxId;

    public GeneSet(Set<GeneMention> genes, List<SynHit> setId) {
        this();
        this.addAll((Collection<? extends GeneMention>)genes);
        this.setId = setId;
    }

    public GeneSet() {
        super(Comparator.comparingInt(GeneMention::getBegin).thenComparing(System::identityHashCode));
    }

    @Override
    public boolean addAll(Collection<? extends GeneMention> c) {
        boolean b = super.addAll(c);
        c.forEach(gm -> gm.addGeneSet(this));
        return b;
    }

    public boolean addAll(Collection<? extends GeneMention> c, boolean addGenesToSet) {
        if (addGenesToSet) {
            return super.addAll(c);
        }
        boolean changed = false;
        for (GeneMention geneMention : c) {
            if (!this.add(geneMention, addGenesToSet)) continue;
            changed = true;
        }
        return changed;
    }

    private boolean add(GeneMention gm, boolean addGenesToSet) {
        boolean add = super.add(gm);
        if (addGenesToSet) {
            gm.addGeneSet(this);
        }
        return add;
    }

    @Override
    public boolean add(GeneMention geneMention) {
        return this.add(geneMention, true);
    }

    public String getTaxId() {
        return this.taxId;
    }

    public void setTaxId(String taxId) {
        this.taxId = taxId;
    }

    public int getSmallestGeneBegin() {
        Optional first = this.stream().findFirst();
        if (first.isEmpty()) {
            return 0;
        }
        return ((GeneMention)first.get()).getBegin();
    }

    public List<String> getAllGoldIdsAsList() {
        return this.getAllGoldIds(Collectors.toList(), Collections::emptyList);
    }

    public Set<String> getAllGoldIdsAsSet() {
        return this.getAllGoldIds(Collectors.toSet(), Collections::emptySet);
    }

    private <T, R, A> R getAllGoldIds(Collector<? super T, A, R> collector, Supplier<R> emptyResultSupplier) {
        if (!this.hasGoldMentions()) {
            return emptyResultSupplier.get();
        }
        return this.getAllGoldIds().map(id -> id).collect(collector);
    }

    private boolean hasGoldMentions() {
        return this.stream().anyMatch(GeneMention::hasGoldMentions);
    }

    public Stream<String> getAllGoldIds() {
        if (!this.hasGoldMentions()) {
            return Stream.empty();
        }
        return this.stream().map(GeneMention::getOverlappingGoldMentions).flatMap(Collection::stream).map(GeneMention::getIds).flatMap(Collection::stream);
    }

    public void addContextScore(String id, String contextFieldName, Double score) {
        if (this.id2contextScores.isEmpty()) {
            this.id2contextScores = new HashMap<String, Map<String, Double>>();
        }
        Map field2score = this.id2contextScores.compute(id, (k, v) -> v != null ? v : new HashMap());
        field2score.put(contextFieldName, score);
    }

    public double getContextScore(String id, String contextFieldName) {
        if (this.id2contextScores == null || !this.id2contextScores.containsKey(id) || !this.id2contextScores.get(id).containsKey(contextFieldName)) {
            return 0.0;
        }
        return this.id2contextScores.get(id).get(contextFieldName);
    }

    public Instance getInstance() {
        return this.instance;
    }

    public void setInstance(Instance instance) {
        this.instance = instance;
    }

    public List<SynHit> getSetId() {
        return this.setId;
    }

    public void setSetId(List<SynHit> setId) {
        this.setId = setId;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return Objects.equals(this, obj);
    }

    public String getRepresentationText() {
        Optional any = this.stream().findAny();
        if (any.isPresent()) {
            return ((GeneMention)any.get()).getText();
        }
        return null;
    }

    public FeatureVector getFeatureVector() {
        return this.featureVector;
    }

    public void setFeatureVector(FeatureVector featureVector) {
        this.featureVector = featureVector;
        this.stream().forEach(gm -> gm.setFeatureVector(featureVector));
    }

    public GeneMention.SpecificType getSpecificType() {
        return this.specificType;
    }

    public void setSpecificType(GeneMention.SpecificType specificType) {
        this.specificType = specificType;
        this.stream().forEach(gm -> gm.setSpecificType(specificType));
    }

    public boolean isPlural() {
        return this.isPlural;
    }

    public void setPlural(boolean isPlural) {
        this.isPlural = isPlural;
    }

    public double getSpecificTypeConfidence() {
        return this.specificTypeConfidence;
    }

    public void setSpecificTypeConfidence(double specificTypeConfidence) {
        this.specificTypeConfidence = specificTypeConfidence;
        this.stream().forEach(gm -> gm.setSpecificTypeConfidence(specificTypeConfidence));
    }

    public String getDocId() {
        return this.docId;
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    public boolean hasContradictingGeneIdMappings() {
        HashSet<String> knownIds = new HashSet<String>();
        for (GeneMention gm : this) {
            Iterator idIt = gm.getResultCandidates().map(SynHit::getId).iterator();
            while (idIt.hasNext()) {
                String id = (String)idIt.next();
                if (knownIds.add(id)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasContradictingTaxonomyIds() {
        HashSet knownIds = new HashSet();
        for (GeneMention gm : this) {
            Set gmIds = gm.getTaxonomyIds().stream().collect(Collectors.toSet());
            if (knownIds.isEmpty() || !Sets.intersection(knownIds, gmIds).isEmpty()) {
                knownIds.addAll(gmIds);
                continue;
            }
            return true;
        }
        return false;
    }

    public Stream<String> getDocumentContext(int numTokensPerGene, boolean distinct) {
        return this.getDocumentContext(numTokensPerGene, Collections.emptySet(), false, distinct);
    }

    public Stream<String> getDocumentContext(int numTokensPerGene, Set<String> excludedTokens, boolean excludeGeneMentions, boolean distinct) {
        if (numTokensPerGene == 0) {
            return Stream.empty();
        }
        Stream<String> contextStream = this.stream().flatMap(gm -> gm.getDocumentContext(numTokensPerGene, excludedTokens, excludeGeneMentions));
        if (distinct) {
            contextStream = contextStream.distinct();
        }
        return contextStream;
    }

    public GeneSet getGeneSet() {
        return this.geneSet;
    }

    public void setGeneSet(GeneSet geneSet) {
        this.geneSet = geneSet;
    }

    public Map<String, Map<String, Double>> getId2contextScores() {
        return this.id2contextScores;
    }

    public Map<String, Integer> getSpeciesOccurrenceCounts(GeneSpeciesOccurrence hintType) {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (GeneMention gm : this) {
            Multimap<String, GeneSpeciesOccurrence> taxonomyCandidates = gm.getTaxonomyOccurrences();
            for (String taxId : taxonomyCandidates.keySet()) {
                Collection<GeneSpeciesOccurrence> geneSpeciesOccurrences = taxonomyCandidates.get(taxId);
                if (!geneSpeciesOccurrences.contains((Object)hintType)) continue;
                counts.merge(taxId, 1, Integer::sum);
            }
        }
        return counts;
    }

    public Set<String> getMostOccurringSpecies(GeneSpeciesOccurrence hintType) {
        Map<String, Integer> speciesOccurrenceCounts = this.getSpeciesOccurrenceCounts(hintType);
        Optional<Integer> max = speciesOccurrenceCounts.values().stream().max(Integer::compareTo);
        return max.isPresent() ? speciesOccurrenceCounts.keySet().stream().filter(tax -> speciesOccurrenceCounts.get(tax) == max.get()).collect(Collectors.toSet()) : Collections.emptySet();
    }

    public Optional<GeneMention> getAbbreviationLongform() {
        return this.stream().filter(GeneMention::isAbbreviationLongForm).findAny();
    }

    public Stream<GeneMention> getGeneMentionsWithSpeciesOccurrence(GeneSpeciesOccurrence occurrenceType) {
        return this.stream().filter(gm -> gm.getTaxonomyOccurrences().values().contains((Object)occurrenceType));
    }

    public Stream<String> getCandidateGeneIds() {
        return this.stream().map(GeneMention::getMentionMappingResult).filter(Objects::nonNull).flatMap(mmr -> mmr.tax2originalCandidates.keySet().stream().flatMap(tax -> mmr.tax2originalCandidates.get(tax).stream()).map(SynHit::getId));
    }

    public Stream<SynHit> getResultSynHits() {
        return this.stream().flatMap(GeneMention::getResultCandidates);
    }

    public boolean hasRejectedAndNonRejectedMentions() {
        Boolean rejected = null;
        for (GeneMention gm : this) {
            boolean thisGmIsRejected = gm.isRejected();
            if (rejected == null) {
                rejected = thisGmIsRejected;
                continue;
            }
            if (!(rejected ^ thisGmIsRejected)) continue;
            return true;
        }
        return false;
    }

    public MentionMappingResult.RejectReason getRejectReason() {
        return this.rejectReason;
    }

    public void setRejectReason(MentionMappingResult.RejectReason rejectReason) {
        this.rejectReason = rejectReason;
    }

    public boolean isRejected() {
        return this.setId != null && !this.setId.isEmpty() && this.setId.stream().allMatch(Predicate.not(sh -> sh != MentionMappingResult.REJECTION));
    }

    public List<SynHit> getFamilyNames() {
        return this.familyNames;
    }

    public void setFamilyNames(List<SynHit> familyNames) {
        this.familyNames = familyNames;
    }

    public MentionMappingResult getMentionMappingResult() {
        return this.mentionMappingResult;
    }

    public void setMentionMappingResult(MentionMappingResult mentionMappingResult) {
        this.mentionMappingResult = mentionMappingResult;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public Set<String> getContradictingGoldGeneIds() {
        HashSet<String> nonSharedGoldIds = new HashSet<String>();
        for (GeneMention gm1 : this) {
            for (GeneMention gm2 : this) {
                Set<String> gold1 = gm1.getAllGoldIdAsSet();
                Set<String> gold2 = gm2.getAllGoldIdAsSet();
                if (!gold1.stream().noneMatch(gold2::contains)) continue;
                nonSharedGoldIds.addAll(Sets.symmetricDifference(gold1, gold2));
            }
        }
        return nonSharedGoldIds;
    }

    public SynHit getBestCandidate() {
        List<SynHit> synHits;
        SynHit ret = null;
        if (this.mentionMappingResult != null && this.mentionMappingResult.tax2finalRankedCandidates != null && (synHits = this.mentionMappingResult.tax2finalRankedCandidates.get(this.taxId)) != null && !synHits.isEmpty()) {
            ret = synHits.get(0);
        }
        return ret;
    }

    public Stream<GeneMention> getNonRejectedGenes() {
        return this.stream().filter(Predicate.not(GeneMention::isRejected));
    }

    public Iterable<GeneMention> getNonRejectedGenesIterable() {
        return () -> this.getNonRejectedGenes().iterator();
    }
}

