/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase.genemodel;

import com.google.common.collect.Sets;
import de.julielab.geneexpbase.genemodel.OrthologyRecord;
import de.julielab.java.utilities.FileUtilities;
import de.julielab.java.utilities.cache.CacheAccess;
import de.julielab.java.utilities.cache.NoOpCacheAccess;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneOrthologs {
    private static final Logger log = LoggerFactory.getLogger(GeneOrthologs.class);
    private static GeneOrthologs instance;
    private Map<String, Set<OrthologyRecord>> recordsByOtherGeneId;
    private Map<String, Set<OrthologyRecord>> recordsByGeneId;
    private final CacheAccess<OrthologKey, Set<OrthologyRecord>> cache;
    private File geneOrthologsFile;

    @Inject
    public GeneOrthologs(@Nullable @Named(value="gene_orthologs") File geneOrthologsFile) {
        if (geneOrthologsFile != null) {
            log.info("Reading gene orthologs from {}", (Object)geneOrthologsFile);
            this.geneOrthologsFile = geneOrthologsFile;
        } else {
            log.warn("The path to the gene orthologs file was not specified. No ortholog information can be used.");
        }
        this.cache = new NoOpCacheAccess<OrthologKey, Set<OrthologyRecord>>("", "");
    }

    private synchronized void readOrthologsFile() {
        if (this.recordsByGeneId == null) {
            log.info("Reading gene orthologs from {}", (Object)this.geneOrthologsFile);
            try (BufferedReader br = FileUtilities.getReaderFromFile(this.geneOrthologsFile);){
                List recordList = br.lines().filter(line -> !line.startsWith("#")).map(OrthologyRecord::new).collect(Collectors.toList());
                this.recordsByGeneId = recordList.stream().collect(Collectors.groupingBy(OrthologyRecord::getGeneId, HashMap::new, Collectors.toSet()));
                this.recordsByOtherGeneId = recordList.stream().collect(Collectors.groupingBy(OrthologyRecord::getOtherGeneId, HashMap::new, Collectors.toSet()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            log.info("Done.");
        }
    }

    public Set<OrthologyRecord> getOrthologs(String geneId) {
        OrthologKey key = new OrthologKey(geneId);
        Set<OrthologyRecord> orthologyRecords = this.cache.get(key);
        if (orthologyRecords == null) {
            this.readOrthologsFile();
            orthologyRecords = new HashSet(Sets.union(this.recordsByGeneId.getOrDefault(geneId, Collections.emptySet()), this.recordsByOtherGeneId.getOrDefault(geneId, Collections.emptySet())));
            this.cache.put(key, orthologyRecords);
        }
        return orthologyRecords;
    }

    public Set<OrthologyRecord> getOrthologsInSpecies(String geneId, String targetTaxId) {
        OrthologKey key = new OrthologKey(geneId, targetTaxId);
        Set<OrthologyRecord> orthologyRecords = this.cache.get(key);
        if (orthologyRecords == null) {
            this.readOrthologsFile();
            orthologyRecords = this.getOrthologs(geneId).stream().filter(r -> r.getTaxId().equals(targetTaxId) || r.getOtherTaxId().equals(targetTaxId)).collect(Collectors.toSet());
            this.cache.put(key, orthologyRecords);
        }
        return orthologyRecords;
    }

    private static class OrthologKey
    implements Serializable {
        private final String geneId;
        private final String targetTaxId;

        public OrthologKey(String geneId) {
            this(geneId, null);
        }

        public OrthologKey(String geneId, String targetTaxId) {
            this.geneId = geneId;
            this.targetTaxId = targetTaxId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OrthologKey that = (OrthologKey)o;
            return Objects.equals(this.geneId, that.geneId) && Objects.equals(this.targetTaxId, that.targetTaxId);
        }

        public int hashCode() {
            return Objects.hash(this.geneId, this.targetTaxId);
        }
    }
}

