/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase.genemodel;

import de.julielab.geneexpbase.TermNormalizer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class GeneName
implements Serializable {
    public static final Pattern EC_NUMBER_REGEX = Pattern.compile("EC\\s*([0-9]*\\.*)+");
    private String normalizedText;
    private List<String> normalizedTextVariant;
    private transient TermNormalizer normalizer;
    private String text;
    private Set<GeneName> alternatives;
    private GeneName nominalPhraseContext;
    private List<GeneName> appositionContexts;

    public GeneName(String text, TermNormalizer normalizer) {
        this.text = text;
        this.normalizer = normalizer;
        this.alternatives = Collections.emptySet();
        this.appositionContexts = Collections.emptyList();
    }

    public GeneName(GeneName geneName) {
        this.normalizer = geneName.normalizer;
        this.text = geneName.text;
        this.normalizedText = geneName.normalizedText;
        if (geneName.normalizedTextVariant != null) {
            this.normalizedTextVariant = new ArrayList<String>(geneName.normalizedTextVariant);
        }
        if (geneName.alternatives != null) {
            this.alternatives = geneName.alternatives.stream().map(GeneName::new).collect(Collectors.toSet());
        }
        if (geneName.nominalPhraseContext != null) {
            this.nominalPhraseContext = new GeneName(geneName.nominalPhraseContext);
        }
        if (geneName.appositionContexts != null) {
            this.appositionContexts = geneName.appositionContexts.stream().map(GeneName::new).collect(Collectors.toList());
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeneName other = (GeneName)obj;
        if (this.text == null) {
            return other.text == null;
        }
        return this.text.equals(other.text);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getNormalizedText());
        if (this.alternatives != null && !this.alternatives.isEmpty()) {
            sb.append(" [ALT ");
            this.alternatives.forEach(a -> sb.append(a.getNormalizedText()));
            sb.append("]");
        }
        if (this.nominalPhraseContext != null) {
            sb.append(" [NP ").append(this.nominalPhraseContext.getNormalizedText()).append("]");
        }
        return sb.toString();
    }

    public String getNormalizedText() {
        if (null == this.normalizedText) {
            this.normalizedText = this.getNormalizer().normalize(this.text);
        }
        return this.normalizedText;
    }

    public List<String> getNormalizedTextVariant() {
        if (null == this.normalizedTextVariant) {
            this.normalizedTextVariant = this.getNormalizer().generateVariants(this.text).stream().map(this.getNormalizer()::normalize).collect(Collectors.toList());
        }
        return this.normalizedTextVariant;
    }

    public TermNormalizer getNormalizer() {
        return this.normalizer;
    }

    public void setNormalizer(TermNormalizer normalizer) {
        this.normalizer = normalizer;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.normalizedText = null;
        this.normalizedTextVariant = null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public Set<GeneName> getAlternatives() {
        return this.alternatives;
    }

    public void addAlternative(GeneName geneName) {
        if (this.alternatives.isEmpty()) {
            this.alternatives = new HashSet<GeneName>();
        }
        this.alternatives.add(geneName);
    }

    public GeneName getNominalPhraseContext() {
        return this.nominalPhraseContext;
    }

    public void setNominalPhraseContext(String nominalPhraseContext) {
        this.nominalPhraseContext = new GeneName(nominalPhraseContext, this.normalizer);
    }

    public List<GeneName> getAppositionContexts() {
        return this.appositionContexts;
    }

    public void addAppositionContext(String appositionText) {
        if (this.appositionContexts.isEmpty()) {
            this.appositionContexts = new ArrayList<GeneName>();
        }
        this.appositionContexts.add(new GeneName(appositionText, this.normalizer));
    }

    public void addAppositionContext(GeneName geneName) {
        if (this.appositionContexts.isEmpty()) {
            this.appositionContexts = new ArrayList<GeneName>();
        }
        this.appositionContexts.add(geneName);
    }

    public String getEcNumber() {
        Matcher ecNumberMatcher = EC_NUMBER_REGEX.matcher(this.text);
        return ecNumberMatcher.find() ? ecNumberMatcher.group(1) : null;
    }
}

