/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase.genemodel;

import cc.mallet.types.FeatureVector;
import cc.mallet.types.InstanceList;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import de.julielab.geneexpbase.TermNormalizer;
import de.julielab.geneexpbase.candidateretrieval.SynHit;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneName;
import de.julielab.geneexpbase.genemodel.GeneSet;
import de.julielab.geneexpbase.genemodel.GeneSets;
import de.julielab.geneexpbase.genemodel.GeneSpeciesOccurrence;
import de.julielab.geneexpbase.genemodel.MentionMappingResult;
import de.julielab.geneexpbase.genemodel.PosTag;
import de.julielab.java.utilities.spanutils.Span;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.Range;
import org.apache.lucene.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneMention
implements Span {
    public static final String NOID = "NoId";
    private static final Logger log = LoggerFactory.getLogger(GeneMention.class);
    private Object originalMappedObject;
    private String docId;
    private GeneName geneName;
    private String id = "NoId";
    private TermNormalizer normalizer;
    private Range<Integer> offsets;
    private String text;
    private String goldTaxonomyId;
    private List<GeneMention> overlappingGoldMentions;
    private String taxonomyId;
    private List<String> ids = Collections.emptyList();
    private Set<String> taxonomyCandidates;
    private boolean isTaxonomyCandidatesConjunctive;
    private List<String> taxonomyIds = Collections.emptyList();
    private Multimap<String, GeneSpeciesOccurrence> taxonomyOcurrences = HashMultimap.create();
    private Map<String, Double> taxonomyScores;
    private Map<String, Double> processedTaxonomyScores;
    private Set<String> taxonomyIdsSet;
    private boolean specificTypeFrozen;
    private GeneSpeciesOccurrence taxonomyReliability;
    private String documentContext;
    private Query contextQuery;
    private GeneTagger tagger = GeneTagger.UNKNOWN;
    private SpecificType specificType = SpecificType.UNKNOWN;
    private double specificTypeConfidence;
    private MentionMappingResult mentionMappingResult;
    private GeneDocument geneDocument;
    private List<String> taggingModifiers;
    private GeneSets geneSets;
    private GeneMention parent;
    private List<GeneMention> children;
    private boolean isCompositeMention;
    private List<PosTag> posTags;
    private FeatureVector featureVector;
    private String reducedNameForExactMatch;
    private InstanceList instances;
    private List<SynHit> familyNames;
    private String bestCandidateSynonym;
    private String compositeResolver;
    private Set<String> nameTokenSet;
    private Map<String, Double> familyFeatures = new HashMap<String, Double>();

    public GeneMention(GeneMention gm) {
        if (gm.geneName != null) {
            this.geneName = new GeneName(gm.geneName);
        }
        this.contextQuery = gm.contextQuery;
        this.docId = gm.docId;
        this.documentContext = gm.documentContext;
        this.geneDocument = gm.geneDocument;
        this.id = gm.id;
        if (gm.ids != null) {
            this.ids = new ArrayList<String>(gm.ids);
        }
        this.normalizer = gm.normalizer;
        this.offsets = gm.offsets;
        this.tagger = gm.tagger;
        this.taxonomyOcurrences = gm.taxonomyOcurrences;
        this.taxonomyId = gm.taxonomyId;
        this.taxonomyIds = gm.getTaxonomyIds();
        this.taxonomyScores = gm.taxonomyScores;
        this.processedTaxonomyScores = gm.processedTaxonomyScores;
        this.text = gm.text;
        this.originalMappedObject = gm.originalMappedObject;
        this.parent = gm.parent;
        this.children = gm.children;
        this.overlappingGoldMentions = gm.overlappingGoldMentions;
        this.specificType = gm.getSpecificType();
        this.specificTypeConfidence = gm.getSpecificTypeConfidence();
        this.overlappingGoldMentions = gm.overlappingGoldMentions;
        if (gm.getMentionMappingResult() != null) {
            this.mentionMappingResult = new MentionMappingResult(gm.getMentionMappingResult());
        }
        this.familyFeatures = new HashMap<String, Double>(gm.familyFeatures);
    }

    public GeneMention(String text) {
        this();
        this.text = text;
        this.children = Collections.emptyList();
    }

    public GeneMention() {
    }

    public GeneMention(String text, TermNormalizer normalizer) {
        this(text);
        this.setNormalizer(normalizer);
    }

    public GeneMention(String text, int begin, int end) {
        this(text);
        this.offsets = Range.between(begin, end);
    }

    public GeneMention(String text, int begin, int end, TermNormalizer normalizer) {
        this(text, begin, end);
        this.setNormalizer(normalizer);
    }

    public Double addFamilyFeature(String featureName, double value) {
        return this.familyFeatures.put(featureName, value);
    }

    public Map<String, Double> getFamilyFeatures() {
        return this.familyFeatures;
    }

    public boolean matchesFamilyName() {
        return this.familyNames != null && !this.familyNames.isEmpty();
    }

    public GeneSet getSingleGeneSet() {
        if (this.geneSets.size() != 1) {
            throw new IllegalArgumentException("There is not a single geneset associated with this gene mention but there are " + this.geneSets.size() + " for gene mention " + this + ": " + this.geneSets);
        }
        return (GeneSet)this.geneSets.stream().findAny().get();
    }

    public void addGeneSet(GeneSet geneSet) {
        if (geneSet == null || geneSet.isEmpty()) {
            throw new IllegalArgumentException("The passed geneset is " + (geneSet == null ? "null" : "empty") + ".");
        }
        if (this.geneSets == null) {
            this.geneSets = new GeneSets();
        }
        this.geneSets.add(geneSet);
    }

    public boolean isTaxonomyCandidatesConjunctive() {
        return this.isTaxonomyCandidatesConjunctive;
    }

    public void setTaxonomyCandidatesConjunctive(boolean taxonomyCandidatesConjunctive) {
        this.isTaxonomyCandidatesConjunctive = taxonomyCandidatesConjunctive;
    }

    public Set<String> getTaxonomyCandidates() {
        return this.taxonomyCandidates != null ? this.taxonomyCandidates : Collections.emptySet();
    }

    public void setTaxonomyCandidates(Set<String> taxonomyCandidates) {
        this.taxonomyCandidates = taxonomyCandidates;
    }

    public List<SynHit> getFamilyNames() {
        return this.familyNames;
    }

    public void setFamilyNames(List<SynHit> matchedFamilyNames) {
        this.familyNames = matchedFamilyNames;
    }

    public Map<String, Double> getProcessedTaxonomyScores() {
        return this.processedTaxonomyScores;
    }

    public void setProcessedTaxonomyScores(Map<String, Double> processedTaxonomyScores) {
        this.processedTaxonomyScores = processedTaxonomyScores;
    }

    public GeneMention getFirstGoldMention() {
        if (!this.hasGoldMentions()) {
            return null;
        }
        return this.overlappingGoldMentions.get(0);
    }

    public Object getOriginalMappedObject() {
        return this.originalMappedObject;
    }

    public void setOriginalMappedObject(Object originalMappedObject) {
        this.originalMappedObject = originalMappedObject;
    }

    public List<String> getIds() {
        return this.ids;
    }

    public void setIds(List<String> ids) {
        assert (!ids.stream().anyMatch(Objects::isNull)) : "There is a null item in the IDs to be set.";
        assert (ids.indexOf("null") == -1) : "The string 'null' is among the IDs to be set.";
        this.ids = ids;
    }

    public Stream<SynHit> getMappedSynHits() {
        if (this.mentionMappingResult == null) {
            throw new IllegalArgumentException("This gene mention was not yet mapped, there are no final ranked candidates.");
        }
        return this.mentionMappingResult.getResultCandidates();
    }

    public Stream<String> getMappedIds() {
        assert (this.getMappedSynHits().filter(Predicate.not(SynHit::isRejectionCandidate)).map(SynHit::getId).noneMatch(Objects::isNull)) : "A null ID is returned for " + this;
        return this.getMappedSynHits().filter(Predicate.not(SynHit::isRejectionCandidate)).map(SynHit::getId);
    }

    public Set<String> getMappedIdSet() {
        return this.getMappedIds().collect(Collectors.toSet());
    }

    public void addId(String id) {
        if (this.ids.isEmpty()) {
            this.ids = new ArrayList<String>();
        }
        this.ids.add(id);
    }

    public void addTaxonomyId(String id) {
        this.taxonomyIdsSet = null;
        if (this.taxonomyIds.isEmpty()) {
            this.taxonomyIds = new ArrayList<String>();
        }
        this.taxonomyIds.add(id);
    }

    public List<String> getTaxonomyIds() {
        if (this.taxonomyIds != null) {
            return this.taxonomyIds;
        }
        if (this.taxonomyId != null) {
            return Collections.singletonList(this.taxonomyId);
        }
        return Collections.emptyList();
    }

    public void setTaxonomyIds(List<String> taxonomyIds) {
        this.taxonomyIds = taxonomyIds;
        this.taxonomyIdsSet = null;
    }

    public List<String> getNonRejectedTaxonomyIds() {
        if (this.mentionMappingResult == null) {
            return this.getTaxonomyIds();
        }
        return this.getTaxonomyIds().stream().filter(taxId -> !this.mentionMappingResult.tax2lexicallyRerankedCandidates.get(taxId).get(0).isRejectionCandidate()).collect(Collectors.toList());
    }

    public Set<String> getTaxonomyIdsSet() {
        if (this.taxonomyIdsSet == null) {
            this.taxonomyIdsSet = new HashSet<String>(this.getTaxonomyIds());
        }
        return this.taxonomyIdsSet;
    }

    public void addChild(GeneMention child) {
        if (this.children.isEmpty()) {
            this.children = new ArrayList<GeneMention>();
        }
        this.children.add(child);
    }

    public boolean isCompositeMention() {
        return this.isCompositeMention || !this.children.isEmpty();
    }

    public List<GeneMention> getOverlappingGoldMentions() {
        return this.overlappingGoldMentions;
    }

    public void setOverlappingGoldMentions(List<GeneMention> overlappingGoldMentions) {
        this.overlappingGoldMentions = overlappingGoldMentions;
    }

    public String getAnyGoldTaxonomyId() {
        if (!this.hasGoldMentions()) {
            return null;
        }
        return this.overlappingGoldMentions.get(0).getTaxonomyIds().get(0);
    }

    public List<String> getAnyGoldTaxonomyIds() {
        if (!this.hasGoldMentions()) {
            return Collections.emptyList();
        }
        return this.overlappingGoldMentions.get(0).getTaxonomyIds();
    }

    public List<String> getAllGoldTaxonomyIdsAsList() {
        return this.getAllGoldTaxonomyIds(Collectors.toList(), Collections::emptyList);
    }

    public Set<String> getAllGoldTaxonomyIdsAsSet() {
        return this.getAllGoldTaxonomyIds(Collectors.toSet(), Collections::emptySet);
    }

    public <T, R, A> R getAllGoldTaxonomyIds(Collector<? super T, A, R> collector, Supplier<R> emptyResultSupplier) {
        if (!this.hasGoldMentions()) {
            return emptyResultSupplier.get();
        }
        return this.overlappingGoldMentions.stream().map(GeneMention::getTaxonomyIds).flatMap(Collection::stream).map(id -> id).collect(collector);
    }

    public Stream<String> getAllGoldTaxonomyIds() {
        return this.overlappingGoldMentions.stream().map(GeneMention::getTaxonomyIds).flatMap(Collection::stream);
    }

    public String getAnyGoldId() {
        if (!this.hasGoldMentions()) {
            return null;
        }
        return this.overlappingGoldMentions.get(0).getGoldMentionId();
    }

    public List<String> getAnyGoldIds() {
        if (!this.hasGoldMentions()) {
            return Collections.emptyList();
        }
        return this.overlappingGoldMentions.get(0).getIds();
    }

    public List<String> getAllGoldIdsAsList() {
        return this.getAllGoldIds(Collectors.toList(), Collections::emptyList);
    }

    public Set<String> getAllGoldIdAsSet() {
        return this.getAllGoldIds(Collectors.toSet(), Collections::emptySet);
    }

    private <T, R, A> R getAllGoldIds(Collector<? super T, A, R> collector, Supplier<R> emptyResultSupplier) {
        if (!this.hasGoldMentions()) {
            return emptyResultSupplier.get();
        }
        return this.getAllGoldIds().map(id -> id).collect(collector);
    }

    public Stream<String> getAllGoldIds() {
        if (!this.hasGoldMentions()) {
            return Stream.empty();
        }
        return this.overlappingGoldMentions.stream().map(GeneMention::getIds).flatMap(Collection::stream);
    }

    public boolean hasGoldMentions() {
        return this.overlappingGoldMentions != null && !this.overlappingGoldMentions.isEmpty();
    }

    public String getGoldTaxonomyId() {
        return this.goldTaxonomyId;
    }

    public void setGoldTaxonomyId(String goldTaxonomyId) {
        this.goldTaxonomyId = goldTaxonomyId;
    }

    public void setTaxonomyScore(String tax, double score) {
        if (this.taxonomyScores == null) {
            this.taxonomyScores = new HashMap<String, Double>();
        }
        this.taxonomyScores.put(tax, score);
    }

    public void setProcessedTaxonomyScore(String tax, double score) {
        if (this.processedTaxonomyScores == null) {
            this.processedTaxonomyScores = new HashMap<String, Double>();
        }
        this.processedTaxonomyScores.put(tax, score);
    }

    public double getTaxonomyScore(String taxonomyId) {
        return this.taxonomyScores == null ? 0.0 : this.taxonomyScores.getOrDefault(taxonomyId, 0.0);
    }

    public double getProcessedTaxonomyScore(String taxonomyId) {
        return this.processedTaxonomyScores == null ? 0.0 : this.processedTaxonomyScores.getOrDefault(taxonomyId, 0.0);
    }

    public Map<String, Double> getTaxonomyScores() {
        return this.taxonomyScores;
    }

    public void setTaxonomyScores(Map<String, Double> taxonomyScores) {
        this.taxonomyScores = taxonomyScores;
    }

    public GeneSpeciesOccurrence getTaxonomyReliability() {
        return this.taxonomyReliability;
    }

    public void setTaxonomyReliability(GeneSpeciesOccurrence taxonomyReliability) {
        this.taxonomyReliability = taxonomyReliability;
    }

    public List<String> getTaggingModifiers() {
        return this.taggingModifiers;
    }

    public String getTaxonomyId() {
        if (this.taxonomyId != null) {
            return this.taxonomyId;
        }
        if (this.taxonomyIds == null || this.taxonomyIds.isEmpty()) {
            return null;
        }
        return this.taxonomyIds.get(0);
    }

    public void setTaxonomyId(String taxonomyId) {
        this.taxonomyId = taxonomyId;
        this.taxonomyIds = new ArrayList<String>();
        if (taxonomyId != null) {
            this.taxonomyIds.add(taxonomyId);
        }
    }

    public Multimap<String, GeneSpeciesOccurrence> getTaxonomyOccurrences() {
        return this.taxonomyOcurrences;
    }

    public void setTaxonomyOcurrences(Multimap<String, GeneSpeciesOccurrence> taxonomyOcurrences) {
        this.taxonomyOcurrences = taxonomyOcurrences;
    }

    public String getDocumentContext() {
        return this.documentContext;
    }

    public void setDocumentContext(String documentContext) {
        this.documentContext = documentContext;
    }

    public Stream<String> getDocumentContext(int numTokens, Set<String> excludedTokens, boolean excludeGeneMentions) {
        return this.geneDocument.getDocumentContext(this.offsets, excludedTokens, excludeGeneMentions, numTokens);
    }

    public Stream<String> getDocumentContext(int numTokens) {
        return this.geneDocument.getDocumentContext(this.offsets, numTokens);
    }

    public Query getContextQuery() {
        return this.contextQuery;
    }

    public void setContextQuery(Query contextQuery) {
        this.contextQuery = contextQuery;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.docId == null ? 0 : this.docId.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.offsets == null ? 0 : this.offsets.hashCode());
        result = 31 * result + (this.tagger == null ? 0 : this.tagger.hashCode());
        result = 31 * result + (this.taxonomyId == null ? 0 : this.taxonomyId.hashCode());
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeneMention other = (GeneMention)obj;
        if (this.docId == null ? other.docId != null : !this.docId.equals(other.docId)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.offsets == null ? other.offsets != null : !this.offsets.equals(other.offsets)) {
            return false;
        }
        if (this.tagger != other.tagger) {
            return false;
        }
        if (this.taxonomyId == null ? other.taxonomyId != null : !this.taxonomyId.equals(other.taxonomyId)) {
            return false;
        }
        if (this.text == null) {
            return other.text == null;
        }
        return this.text.equals(other.text);
    }

    @Override
    public int getBegin() {
        return this.offsets.getMinimum();
    }

    public boolean isRejected() {
        return this.mentionMappingResult != null && this.mentionMappingResult.isRejected();
    }

    public String getDocId() {
        return this.docId;
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    @Override
    public int getEnd() {
        return this.offsets.getMaximum();
    }

    public GeneName getGeneName() {
        if (this.geneName == null && this.normalizer == null) {
            throw new IllegalStateException("This GeneMention has not set a TermNormalizer and thus cannot create a GeneName instance.");
        }
        if (this.geneName == null) {
            this.geneName = new GeneName(this.text, this.normalizer);
        }
        return this.geneName;
    }

    public void setGeneName(GeneName geneName) {
        this.geneName = geneName;
    }

    @Deprecated
    public String getGoldMentionId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TermNormalizer getNormalizer() {
        return this.normalizer;
    }

    public void setNormalizer(TermNormalizer normalizer) {
        this.normalizer = normalizer;
        if (this.geneName != null) {
            this.geneName.setNormalizer(normalizer);
        }
    }

    @Override
    public Range<Integer> getOffsets() {
        return this.offsets;
    }

    public void setOffsets(Range<Integer> offsets) {
        this.offsets = offsets;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        if (this.geneName != null) {
            this.geneName.setText(text);
        }
    }

    public String getRightExtendedText() {
        Integer chunkend;
        Set<Map.Entry<Range<Integer>, String>> chunkNP = this.geneDocument.getOverlappingChunks(this.getOffsets(), "ChunkNP");
        if (!chunkNP.isEmpty() && (chunkend = chunkNP.iterator().next().getKey().getMaximum()) > this.getEnd()) {
            return this.geneDocument.getCoveredText(this.getBegin(), chunkend);
        }
        return this.text;
    }

    public Range<Integer> getRightExtendedOffsets() {
        Integer chunkend;
        Set<Map.Entry<Range<Integer>, String>> chunkNP = this.geneDocument.getOverlappingChunks(this.getOffsets(), "ChunkNP");
        if (!chunkNP.isEmpty() && (chunkend = chunkNP.iterator().next().getKey().getMaximum()) > this.getEnd()) {
            return Range.between(this.getBegin(), chunkend);
        }
        return this.offsets;
    }

    public Range<Integer> getPhraseExtendesOffsets() {
        Set<Map.Entry<Range<Integer>, String>> chunkNP = this.geneDocument.getOverlappingChunks(this.getOffsets(), "ChunkNP");
        if (!chunkNP.isEmpty()) {
            return chunkNP.iterator().next().getKey();
        }
        return this.offsets;
    }

    public String getPhraseExtendedText() {
        return this.geneDocument.getCoveredText(this.getPhraseExtendesOffsets());
    }

    public String toString() {
        String id = this.mentionMappingResult != null && this.mentionMappingResult.tax2finalRankedCandidates != null ? this.mentionMappingResult.getResultCandidates().map(SynHit::getId).collect(Collectors.joining(", ")) : NOID;
        return "GeneMention [text=" + this.text + ", offsets=" + this.offsets + ", docId=" + this.docId + ", id=" + id + ",  taxonomyIds=" + this.taxonomyIds + ", goldIds=" + this.getAllGoldIdsAsList() + ", goldTaxIds=" + this.getAllGoldTaxonomyIdsAsList() + ", tagger=" + this.tagger + "]";
    }

    public String getNormalizedText() {
        return this.getGeneName().getNormalizedText();
    }

    public List<String> getNormalizedTextVariant() {
        return this.getGeneName().getNormalizedTextVariant();
    }

    public GeneTagger getTagger() {
        return this.tagger;
    }

    public void setTagger(GeneTagger tagger) {
        this.tagger = tagger;
    }

    public MentionMappingResult getMentionMappingResult() {
        return this.mentionMappingResult;
    }

    public void setMentionMappingResult(MentionMappingResult mentionMappingResult) {
        this.mentionMappingResult = mentionMappingResult;
    }

    public SynHit getResultCandidate(String taxonomyId) {
        assert (this.mentionMappingResult != null) : "The mention mapping result is null";
        return this.mentionMappingResult.getResultCandidate(taxonomyId);
    }

    public Stream<SynHit> getResultCandidates() {
        assert (this.mentionMappingResult != null) : "The mention mapping result is null";
        return this.mentionMappingResult.getResultCandidates();
    }

    public GeneDocument getGeneDocument() {
        return this.geneDocument;
    }

    public void setGeneDocument(GeneDocument geneDocument) {
        this.geneDocument = geneDocument;
    }

    public GeneMention getParent() {
        return this.parent;
    }

    public void setParent(GeneMention parent) {
        this.parent = parent;
    }

    public void addTaggingModifier(String modifier) {
        if (this.taggingModifiers == null) {
            this.taggingModifiers = new ArrayList<String>();
        }
        this.taggingModifiers.add(modifier);
    }

    public List<PosTag> getPosTags() {
        return this.posTags;
    }

    public void setPosTags(List<PosTag> posTags) {
        this.posTags = posTags;
    }

    public SpecificType getSpecificType() {
        return this.specificType;
    }

    public void setSpecificType(SpecificType specificType) {
        if (!this.specificTypeFrozen) {
            this.specificType = specificType;
        } else {
            log.warn("Specific type not set: It is frozen");
        }
    }

    public FeatureVector getFeatureVector() {
        return this.featureVector;
    }

    public void setFeatureVector(FeatureVector featureVector) {
        this.featureVector = featureVector;
    }

    public boolean isAbbreviationLongForm() {
        return !this.geneDocument.getOverlappingAcronymLongforms(this.offsets).isEmpty();
    }

    public boolean isAbbreviation() {
        return !this.geneDocument.getOverlappingAcronyms(this.offsets).isEmpty();
    }

    public double getSpecificTypeConfidence() {
        return this.specificTypeConfidence;
    }

    public void setSpecificTypeConfidence(double specificTypeConfidence) {
        this.specificTypeConfidence = specificTypeConfidence;
    }

    public String getReducedNameForExactMatch() {
        return this.reducedNameForExactMatch;
    }

    public void setReducedNameForExactMatch(String reducedNameForExactMatch) {
        this.reducedNameForExactMatch = reducedNameForExactMatch;
    }

    public void freezeSpecificType() {
        this.specificTypeFrozen = true;
    }

    public boolean hasExactCandidateMatch() {
        Map<String, List<SynHit>> tax2originalCandidates;
        if (this.mentionMappingResult != null && (tax2originalCandidates = this.mentionMappingResult.tax2originalCandidates) != null) {
            return tax2originalCandidates.keySet().stream().map(tax2originalCandidates::get).flatMap(Collection::stream).anyMatch(SynHit::isExactMatch);
        }
        return false;
    }

    public boolean hasApproximateCandidateMatch() {
        if (this.mentionMappingResult != null) {
            Map<String, List<SynHit>> tax2originalCandidates = this.mentionMappingResult.tax2originalCandidates;
            return tax2originalCandidates.keySet().stream().map(tax2originalCandidates::get).filter(Predicate.not(List::isEmpty)).map(list -> (SynHit)list.get(0)).anyMatch(Predicate.not(SynHit::isExactMatch));
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasOnlyApproximateCandidateMatches() {
        if (this.mentionMappingResult == null) return false;
        Map<String, List<SynHit>> tax2originalCandidates = this.mentionMappingResult.tax2originalCandidates;
        if (!this.mentionMappingResult.tax2originalCandidates.values().stream().flatMap(Collection::stream).findAny().isPresent()) return false;
        if (!tax2originalCandidates.keySet().stream().map(tax2originalCandidates::get).filter(Predicate.not(List::isEmpty)).map(list -> (SynHit)list.get(0)).allMatch(Predicate.not(SynHit::isExactMatch))) return false;
        return true;
    }

    public String getBestCandidateSynonym() {
        if (this.mentionMappingResult != null && this.bestCandidateSynonym == null) {
            Map<String, List<SynHit>> tax2originalCandidates = this.mentionMappingResult.tax2originalCandidates;
            this.bestCandidateSynonym = tax2originalCandidates.keySet().stream().map(tax2originalCandidates::get).filter(Predicate.not(Collection::isEmpty)).map(list -> (SynHit)list.get(0)).map(SynHit::getSynonym).findFirst().get();
        }
        return this.bestCandidateSynonym;
    }

    public Set<String> getAllBestCandidateSynonyms() {
        return this.getAllBestCandidateSynonyms(null);
    }

    public Set<String> getAllBestCandidateSynonyms(Set<String> filterTax) {
        if (this.mentionMappingResult != null) {
            Map<String, List<SynHit>> tax2originalCandidates = this.mentionMappingResult.tax2originalCandidates;
            for (String taxId : tax2originalCandidates.keySet()) {
                List<SynHit> candidates;
                if (filterTax != null && !filterTax.isEmpty() && !filterTax.contains(taxId) || (candidates = tax2originalCandidates.get(taxId)).isEmpty()) continue;
                if (candidates.get(0).isExactMatch() || candidates.size() == 1 || candidates.get(0).getLexicalScore() > candidates.get(1).getLexicalScore()) {
                    return Set.of(candidates.get(0).getSynonym());
                }
                HashSet<String> bestSynonyms = new HashSet<String>();
                double bestScore = candidates.get(0).getLexicalScore();
                for (int i = 0; i < candidates.size() && candidates.get(i).getLexicalScore() - bestScore < 1.0E-4; ++i) {
                    bestSynonyms.add(candidates.get(i).getSynonym());
                }
                return bestSynonyms;
            }
        }
        return Collections.emptySet();
    }

    public Optional<String> getTaxonomyCandidateWithOccurrence(GeneSpeciesOccurrence occurrenceType) {
        return this.taxonomyOcurrences != null ? this.taxonomyOcurrences.keySet().stream().filter(taxId -> this.taxonomyOcurrences.get((String)taxId).contains((Object)occurrenceType)).findAny() : Optional.empty();
    }

    public boolean hasCorrectTaxonomyId() {
        boolean goldHasOffsets = this.geneDocument.isGoldHasOffsets();
        if (goldHasOffsets) {
            return !Sets.intersection(this.getAllGoldTaxonomyIdsAsSet(), this.getTaxonomyIdsSet()).isEmpty();
        }
        return !Sets.intersection(this.geneDocument.getGoldTaxonomyIds(), this.getTaxonomyIdsSet()).isEmpty();
    }

    public GeneDocument.MentionCorrectness getGenesetCorrectnessLevel(String goldId) {
        int genesetSize;
        if (!this.hasGoldMentions()) {
            return GeneDocument.MentionCorrectness.CANT_FIND;
        }
        HashSet seenOffsets = new HashSet();
        int goldGenesetSize = (int)this.geneDocument.getGenes().filter(GeneMention::hasGoldMentions).map(GeneMention::getOverlappingGoldMentions).flatMap(Collection::stream).filter(goldGm -> goldGm.getIds().contains(goldId)).filter(goldGm -> seenOffsets.add(goldGm.getOffsets())).map(GeneMention::getIds).flatMap(Collection::stream).count();
        Optional<GeneSet> any = this.geneSets.stream().filter(gs -> ((GeneMention)gs.stream().findAny().get()).getAllGoldIdAsSet().contains(goldId)).findAny();
        int n = genesetSize = any.isPresent() ? any.get().size() : 0;
        if (goldGenesetSize == genesetSize) {
            return GeneDocument.MentionCorrectness.CORRECT_ID;
        }
        return GeneDocument.MentionCorrectness.WRONG_ID;
    }

    public boolean isAnchor(String taxId) {
        SynHit resultEntry;
        if (this.mentionMappingResult != null && (resultEntry = this.mentionMappingResult.getResultCandidate(taxId)) != null) {
            return resultEntry.isAnchor();
        }
        return false;
    }

    public boolean hasFamilyCandidateWithinRank(int n, String taxId) {
        if (this.mentionMappingResult != null) {
            List<SynHit> synHits = this.mentionMappingResult.tax2originalCandidates.get(taxId);
            for (int i = 0; i < Math.min(synHits.size(), n); ++i) {
                SynHit synHit = synHits.get(i);
                if (!synHit.isFamilyName()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasExactMatchInTax(String taxId) {
        if (this.mentionMappingResult != null) {
            List<SynHit> synHits = this.mentionMappingResult.tax2originalCandidates.get(taxId);
            try {
                return !synHits.isEmpty() && synHits.get(0).isExactMatch();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public InstanceList getInstances() {
        return this.instances;
    }

    public void setInstances(InstanceList instances) {
        this.instances = instances;
    }

    public boolean isExactFamilyNameMatch() {
        return this.familyNames != null && this.familyNames.stream().anyMatch(SynHit::isExactMatch);
    }

    public double getFamilyNameMatchScore() {
        return this.familyNames != null && !this.familyNames.isEmpty() ? this.familyNames.get(0).getLexicalScore() : 0.0;
    }

    public boolean isAmbiguous() {
        return !this.getAmbiguityTypes().isEmpty();
    }

    public Set<AmbiguityType> getAmbiguityTypes() {
        HashSet<AmbiguityType> ambiguityTypes = new HashSet<AmbiguityType>();
        if (this.mentionMappingResult != null) {
            boolean exactInOneSpecies = false;
            Map<String, List<SynHit>> tax2originalCandidates = this.mentionMappingResult.tax2originalCandidates;
            for (String taxId : tax2originalCandidates.keySet()) {
                List<SynHit> candidates4tax = tax2originalCandidates.get(taxId);
                if (candidates4tax.size() > 1 && candidates4tax.get(0).isExactMatch() && candidates4tax.get(1).isExactMatch()) {
                    ambiguityTypes.add(AmbiguityType.LEXICAL);
                }
                if (candidates4tax.isEmpty() || !candidates4tax.get(0).isExactMatch()) continue;
                if (exactInOneSpecies) {
                    ambiguityTypes.add(AmbiguityType.INTRASPECIES);
                }
                exactInOneSpecies = true;
            }
        }
        return ambiguityTypes;
    }

    public Set<String> getNameTokenSet() {
        if (this.nameTokenSet == null) {
            Function<GeneName, Stream> gnTokensFunc = gn -> Arrays.stream(this.normalizer.normalize(gn.getText()).split("\\s+"));
            Stream nameTokens = gnTokensFunc.apply(this.geneName);
            for (GeneName alt : this.geneName.getAlternatives()) {
                nameTokens = Stream.concat(nameTokens, gnTokensFunc.apply(alt));
            }
            this.nameTokenSet = nameTokens.collect(Collectors.toSet());
        }
        return this.nameTokenSet;
    }

    public String getEcNumber() {
        return this.geneName.getEcNumber();
    }

    public String getCompositeResolver() {
        return this.compositeResolver;
    }

    public void setCompositeResolver(String compositeResolver) {
        this.compositeResolver = compositeResolver;
    }

    public Stream<GeneName> getContextGeneNames() {
        if (this.geneDocument == null) {
            return Stream.empty();
        }
        return this.geneDocument.getGenes().filter(g2 -> g2 != this).map(GeneMention::getGeneName);
    }

    public GeneSets getGeneSets() {
        return this.geneSets;
    }

    public void removeGeneSet(GeneSet geneSet) {
        this.geneSets.remove(geneSet);
    }

    public void clearGeneSets() {
        if (this.geneSets != null) {
            this.geneSets.clear();
        }
    }

    public void reject(MentionMappingResult.RejectReason reason) {
        HashSet<String> taxIds = new HashSet<String>();
        taxIds.addAll(this.getTaxonomyIds());
        if (this.mentionMappingResult != null && this.mentionMappingResult.tax2originalCandidates != null) {
            taxIds.addAll(this.mentionMappingResult.tax2originalCandidates.keySet());
        }
        if (this.mentionMappingResult != null && this.mentionMappingResult.tax2lexicallyRerankedCandidates != null) {
            taxIds.addAll(this.mentionMappingResult.tax2lexicallyRerankedCandidates.keySet());
        }
        for (String tax : taxIds) {
            this.reject(tax, reason);
        }
    }

    public void reject(String tax, MentionMappingResult.RejectReason reason) {
        if (this.mentionMappingResult == null) {
            this.mentionMappingResult = new MentionMappingResult(this);
        }
        if (this.mentionMappingResult.tax2lexicallyRerankedCandidates == null) {
            this.mentionMappingResult.tax2lexicallyRerankedCandidates = new HashMap<String, List<SynHit>>();
        }
        if (this.mentionMappingResult.tax2finalRankedCandidates == null) {
            this.mentionMappingResult.tax2finalRankedCandidates = new HashMap<String, List<SynHit>>();
        }
        this.mentionMappingResult.tax2lexicallyRerankedCandidates.put(tax, List.of(MentionMappingResult.REJECTION));
        this.mentionMappingResult.tax2finalRankedCandidates.put(tax, List.of(MentionMappingResult.REJECTION));
        this.mentionMappingResult.setRejectReason(tax, reason);
    }

    public static enum AmbiguityType {
        INTRASPECIES,
        LEXICAL;

    }

    public static enum SpecificType {
        GENE,
        FAMILYNAME,
        DOMAINMOTIF,
        GENE_ENUM,
        NO_GENE,
        GROUP,
        COMPLEX,
        UNKNOWN;

    }

    public static enum GeneTagger {
        JNET,
        BANNER,
        FLAIR,
        FLAIR_JPG_COLLAPSED_VAR,
        FLAIR_JPG_COLLAPSED_VARCOMPENUM,
        FLAIR_BC2TRAINTEST,
        FLAIR_GNORMPLUSNLMIAT,
        GOLD,
        FLAIR_JPG_NOBC2TEST_NOTEST,
        FLAIR_JPG_NOBC2TEST_NOTEST_COLLAPSED_VAR,
        FLAIR_JPG_GNP_ENTITIES,
        CONSISTENCY_TAGGER,
        EXPANSION_TAGGER,
        GNORM_PLUS,
        UNKNOWN,
        GAZETTEER;

    }
}

