/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase.genemodel;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneLocation {
    public static final Pattern MAP_LOC_PATTERN = Pattern.compile("([0-9xyXY]+)([pq])([0-9]+)(\\.[0-9]+)?(-?[pq])?([0-9]+)?(\\.[0-9]+)?");
    private static final Logger log = LoggerFactory.getLogger(GeneLocation.class);
    private String chromosome;
    private String arm;
    private String position;
    private String subband;
    private String armRange;
    private String positionRange;
    private String subbandRange;

    public GeneLocation(String geneLocationString) {
        Matcher m3 = MAP_LOC_PATTERN.matcher(geneLocationString);
        m3.matches();
        try {
            this.initFromMatcher(m3);
        }
        catch (IllegalStateException e) {
            log.error("No chromosomal gene location match for string {}", (Object)geneLocationString);
            throw e;
        }
    }

    public GeneLocation(Matcher m3) {
        this.initFromMatcher(m3);
    }

    public GeneLocation() {
    }

    public void setChromosome(String chromosome) {
        this.chromosome = chromosome;
    }

    public void setArm(String arm) {
        this.arm = arm;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public void setSubband(String subband) {
        this.subband = subband;
    }

    public void setArmRange(String armRange) {
        this.armRange = armRange;
    }

    public void setPositionRange(String positionRange) {
        this.positionRange = positionRange;
    }

    public void setSubbandRange(String subbandRange) {
        this.subbandRange = subbandRange;
    }

    public String getChromosome() {
        return this.chromosome;
    }

    public String getArm() {
        return this.arm;
    }

    public String getPosition() {
        return this.position;
    }

    public String getSubband() {
        return this.subband;
    }

    private void initFromMatcher(Matcher m3) {
        String armRangeGroup;
        this.chromosome = m3.group(1);
        this.arm = m3.group(2);
        this.position = m3.group(3);
        String subbandGroup = m3.group(4);
        if (subbandGroup != null) {
            this.subband = subbandGroup.replace(".", "");
        }
        if ((armRangeGroup = m3.group(5)) != null) {
            this.armRange = armRangeGroup.replace("-", "");
        }
        this.positionRange = m3.group(6);
        String subbandRangeGroup = m3.group(7);
        if (subbandRangeGroup != null) {
            this.subbandRange = subbandRangeGroup.replace(".", "");
        }
    }

    public String toString() {
        StringBuilder loc = new StringBuilder(this.chromosome).append(this.arm).append(this.position);
        if (this.subband != null) {
            loc.append(".").append(this.subband);
        }
        return loc.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeneLocation that = (GeneLocation)o;
        return this.chromosome.equals(that.chromosome) && this.arm.equals(that.arm) && this.position.equals(that.position) && Objects.equals(this.subband, that.subband);
    }

    public int hashCode() {
        return Objects.hash(this.chromosome, this.arm, this.position, this.subband);
    }

    public String getArmRange() {
        return this.armRange;
    }

    public String getPositionRange() {
        return this.positionRange;
    }

    public String getSubbandRange() {
        return this.subbandRange;
    }
}

