/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase.genemodel;

import java.io.Serializable;
import java.util.Arrays;

public class GeneEmbeddingCentroid
implements Serializable {
    private static final long serialVersionUID = 20200114L;
    private int numVectors;
    private final double[] vectorSum;
    private transient String geneId;

    public GeneEmbeddingCentroid(double[] initVector, boolean includeInCount) {
        this.vectorSum = initVector;
        if (includeInCount) {
            this.numVectors = 1;
        }
    }

    public void addVector(double[] vector) {
        if (vector.length != this.vectorSum.length) {
            throw new IllegalArgumentException("The current vector has a length of " + this.vectorSum.length + " but a vector of length " + vector.length + " should be added.");
        }
        ++this.numVectors;
        for (int i = 0; i < vector.length; ++i) {
            if (Double.MAX_VALUE - vector[i] < this.vectorSum[i]) {
                throw new IllegalStateException("Position " + i + " of the current vector sum has the value " + this.vectorSum[i] + " and the value " + vector[i] + " should be added. But this would cause a numerical overflow.");
            }
            int n = i;
            this.vectorSum[n] = this.vectorSum[n] + vector[i];
        }
    }

    public int getNumVectors() {
        return this.numVectors;
    }

    public double[] getVectorSum() {
        return this.vectorSum;
    }

    public double[] getMeanVector() {
        double[] centroid = new double[this.vectorSum.length];
        System.arraycopy(this.vectorSum, 0, centroid, 0, this.vectorSum.length);
        int i = 0;
        while (i < centroid.length) {
            int n = i++;
            centroid[n] = centroid[n] / (double)this.numVectors;
        }
        return centroid;
    }

    public String getGeneId() {
        return this.geneId;
    }

    public void setGeneId(String geneId) {
        this.geneId = geneId;
    }

    public String toString() {
        return this.numVectors + " contributing vectors. Sum: " + Arrays.toString(this.vectorSum);
    }
}

