/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase.genemodel;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import com.lahodiuk.ahocorasick.AhoCorasickOptimized;
import de.julielab.geneexpbase.AhoCorasickLongestMatchCallback;
import de.julielab.geneexpbase.TermNormalizer;
import de.julielab.geneexpbase.genemodel.Acronym;
import de.julielab.geneexpbase.genemodel.AcronymLongform;
import de.julielab.geneexpbase.genemodel.Apposition;
import de.julielab.geneexpbase.genemodel.CoreferenceExpression;
import de.julielab.geneexpbase.genemodel.CoreferenceSet;
import de.julielab.geneexpbase.genemodel.GeneLocation;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.GeneName;
import de.julielab.geneexpbase.genemodel.GeneSet;
import de.julielab.geneexpbase.genemodel.GeneSets;
import de.julielab.geneexpbase.genemodel.MentionMappingResult;
import de.julielab.geneexpbase.genemodel.MeshHeading;
import de.julielab.geneexpbase.genemodel.PosTag;
import de.julielab.geneexpbase.genemodel.SpeciesCandidates;
import de.julielab.geneexpbase.genemodel.SpeciesMention;
import de.julielab.java.utilities.spanutils.OffsetMap;
import de.julielab.java.utilities.spanutils.OffsetSet;
import de.julielab.java.utilities.spanutils.OffsetSpanComparator;
import de.julielab.java.utilities.spanutils.Span;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneDocument {
    public static final Pattern lociRegExp = Pattern.compile("[0-9]+[Xqp][0-9.-]+");
    private static final Logger log = LoggerFactory.getLogger(GeneDocument.class);
    private final Matcher pluralMatcher = Pattern.compile("[A-Z]+s").matcher("");
    private OffsetMap<Acronym> acronyms;
    private OffsetMap<AcronymLongform> acronymLongforms;
    private OffsetMap<String> chunks;
    private OffsetMap<PosTag> posTags;
    private OffsetMap<String> ontologyClassMentions;
    private String documentText;
    private String documentTitle;
    private NavigableSet<GeneMention> allGenes;
    private OffsetMap<List<GeneMention>> genes;
    private OffsetMap<List<GeneMention>> goldGenes = OffsetMap.emptyOffsetMap();
    private Set<String> goldIds = Collections.emptySet();
    private boolean goldHasOffsets;
    private boolean goldOffsetsInferred;
    private GeneSets geneSets;
    private String id;
    private OffsetSet sentences;
    private SpeciesCandidates species;
    private AhoCorasickOptimized geneNameDictionary;
    private TermNormalizer termNormalizer;
    private Collection<MeshHeading> meshHeadings;
    private Set<State> state;
    private Set<GeneLocation> chromosomeLocations;
    private Set<String> geneMentionTexts;
    private String abstractText;
    private Range<Integer> titleOffsets;
    private Range<Integer> abstractOffsets;
    private Set<String> goldTaxonomyIds = Collections.emptySet();
    private boolean completelyAnnotated;
    private Collection<CoreferenceSet> coreferenceSets;
    private OffsetMap<CoreferenceExpression> coreferenceExpressions;
    private OffsetMap<Apposition> appositions;
    private OffsetSet nonGenePhrases;

    public GeneDocument() {
        this.state = new LinkedHashSet<State>();
        this.termNormalizer = new TermNormalizer();
    }

    public GeneDocument(GeneDocument template) {
        this.acronyms = template.acronyms;
        this.acronymLongforms = template.acronymLongforms;
        this.coreferenceSets = template.coreferenceSets;
        this.coreferenceExpressions = template.coreferenceExpressions;
        this.appositions = template.appositions;
        this.chunks = template.chunks;
        this.ontologyClassMentions = template.ontologyClassMentions;
        this.posTags = template.posTags;
        this.documentText = template.documentText;
        this.documentTitle = template.documentTitle;
        TreeMap orgToNew = new TreeMap(Comparator.comparingInt(System::identityHashCode));
        template.allGenes.forEach(g2 -> {
            GeneMention newGm = new GeneMention((GeneMention)g2);
            newGm.setGeneDocument(this);
            orgToNew.put((GeneMention)g2, newGm);
        });
        this.allGenes = template.allGenes.stream().map(old -> Objects.requireNonNull((GeneMention)orgToNew.get(old))).collect(Collectors.toCollection(this::createAllGenesSet));
        this.genes = new OffsetMap();
        for (Map.Entry original : template.genes.entrySet()) {
            this.genes.put((Range)original.getKey(), ((List)original.getValue()).stream().map(k -> Objects.requireNonNull((GeneMention)orgToNew.get(k))).collect(Collectors.toList()));
        }
        template.goldGenes.values().stream().flatMap(Collection::stream).map(GeneMention::new).forEach(this::putGoldGene);
        if (template.geneSets != null) {
            this.geneSets = new GeneSets();
            for (GeneSet gs : template.geneSets) {
                GeneSet newSet = new GeneSet();
                newSet.setFeatureVector(gs.getFeatureVector());
                newSet.setInstance(gs.getInstance());
                newSet.setSetId(gs.getSetId());
                newSet.setSpecificType(gs.getSpecificType());
                gs.forEach(g2 -> newSet.add((GeneMention)orgToNew.get(g2)));
                this.geneSets.add(newSet);
                newSet.forEach(g2 -> g2.addGeneSet(newSet));
            }
        }
        if (template.meshHeadings != null) {
            this.meshHeadings = template.meshHeadings.stream().map(MeshHeading::clone).collect(Collectors.toSet());
        }
        this.id = template.id;
        this.sentences = template.sentences;
        this.nonGenePhrases = template.nonGenePhrases;
        if (template.species != null) {
            this.species = template.species.clone();
        }
        this.geneNameDictionary = template.geneNameDictionary;
        this.termNormalizer = template.termNormalizer;
        this.state = new HashSet<State>(template.state);
        this.goldHasOffsets = template.goldHasOffsets;
        this.goldOffsetsInferred = template.goldOffsetsInferred;
        if (template.goldIds != null) {
            this.goldIds = new HashSet<String>(template.goldIds);
        }
        if (template.goldTaxonomyIds != null) {
            this.goldTaxonomyIds = new HashSet<String>(template.goldTaxonomyIds);
        }
        if (template.chromosomeLocations != null) {
            this.chromosomeLocations = new HashSet<GeneLocation>(template.chromosomeLocations);
        }
        if (template.geneMentionTexts != null) {
            this.geneMentionTexts = new HashSet<String>(template.geneMentionTexts);
        }
    }

    public GeneDocument(String id) {
        this();
        this.id = id;
    }

    private TreeSet<GeneMention> createAllGenesSet() {
        return new TreeSet<GeneMention>(Comparator.comparingInt(GeneMention::getBegin).thenComparingInt(GeneMention::getEnd).thenComparing(GeneMention::getTagger));
    }

    public OffsetMap<List<GeneMention>> getGoldGenes() {
        return this.goldGenes;
    }

    public Range<Integer> getTitleOffsets() {
        return this.titleOffsets != null ? this.titleOffsets : Range.between(0, 0);
    }

    public void setTitleOffsets(Range<Integer> titleOffsets) {
        this.titleOffsets = titleOffsets;
    }

    public Range<Integer> getAbstractOffsets() {
        return this.abstractOffsets != null ? this.abstractOffsets : Range.between(0, 0);
    }

    public void setAbstractOffsets(Range<Integer> abstractOffsets) {
        this.abstractOffsets = abstractOffsets;
    }

    public Set<String> getGoldIds() {
        return this.goldIds;
    }

    public void setGoldIds(Set<String> goldIds) {
        this.goldIds = goldIds;
    }

    public void addState(State state) {
        this.state.add(state);
    }

    public boolean hasState(State state) {
        if (state == null) {
            return false;
        }
        return this.state.contains((Object)state);
    }

    public AcronymLongform getAcronymLongformAndOffsets(Acronym acronym) {
        AcronymLongform longform = acronym.getLongform();
        if (null == longform.getText()) {
            Range<Integer> range = longform.getOffsets();
            longform.setText(this.getDocumentText().substring(range.getMinimum(), range.getMaximum()));
        }
        return longform;
    }

    public void setNominalPhrasesOfGenesToNames() {
        for (GeneMention gm : this.getAllGenes()) {
            Optional chunkNP = this.getOverlappingChunks(gm.getOffsets(), "ChunkNP").stream().findFirst();
            if (!chunkNP.isPresent()) continue;
            gm.getGeneName().setNominalPhraseContext(this.getCoveredText((Range)((Map.Entry)chunkNP.get()).getKey()));
        }
    }

    public void setAcronymsAsGeneNameAlternatives() {
        ArrayList<String> longformTexts = new ArrayList<String>();
        HashMultimap<String, String> long2short = HashMultimap.create();
        for (AcronymLongform longForm : this.getAcronymLongforms().values()) {
            String longformText = this.getCoveredText(longForm);
            longformTexts.add(longformText);
            String acronymText = null;
            for (Acronym acronym : longForm.getAcronyms()) {
                acronymText = this.getCoveredText(acronym);
                long2short.put(longformText, acronymText);
                Iterator acroIt = this.getOverlappingGenes(acronym.getOffsets()).iterator();
                while (acroIt.hasNext()) {
                    GeneMention acroGene = (GeneMention)acroIt.next();
                    String longText = acroGene.getText().replace(acronymText, longformText);
                    if (longText.equals(acroGene.getText())) continue;
                    GeneName longName = new GeneName(longText, this.getTermNormalizer());
                    acroGene.getGeneName().addAlternative(longName);
                }
            }
        }
        AhoCorasickOptimized longformAc = new AhoCorasickOptimized(longformTexts);
        AhoCorasickLongestMatchCallback callback = new AhoCorasickLongestMatchCallback();
        for (GeneMention gm : this.getGenesIterable()) {
            callback.clear();
            longformAc.match(gm.getText(), callback);
            Optional<String> match = callback.getLongestMatches().values().stream().findAny();
            if (!match.isPresent()) continue;
            String longform = match.get();
            Collection shortforms = long2short.get(longform);
            for (String shortform : shortforms) {
                String shortText = gm.getText().replace(longform, shortform);
                GeneName shortName = new GeneName(shortText, this.getTermNormalizer());
                gm.getGeneName().addAlternative(shortName);
            }
        }
    }

    public OffsetMap<Acronym> getAcronyms() {
        return this.acronyms;
    }

    public void setAcronyms(OffsetMap<Acronym> acronyms) {
        this.acronyms = acronyms;
        this.addState(State.ACRONYMS_SET);
    }

    public void setAcronyms(Stream<Acronym> acronyms) {
        this.acronyms = new OffsetMap();
        this.acronymLongforms = new OffsetMap();
        acronyms.forEach(a -> {
            this.acronyms.put(a.getOffsets(), (Acronym)a);
            this.acronymLongforms.put(a.getLongform().getOffsets(), a.getLongform());
        });
        this.addState(State.ACRONYMS_SET);
    }

    public void setAcronyms(Acronym ... acronyms) {
        this.setAcronyms(Stream.of(acronyms));
    }

    public void setAcronyms(Collection<Acronym> acronyms) {
        this.setAcronyms(acronyms.stream());
    }

    public OffsetMap<AcronymLongform> getAcronymLongforms() {
        return this.acronymLongforms;
    }

    public OffsetMap<String> getOntologyClassMentions() {
        return this.ontologyClassMentions;
    }

    public void setOntologyClassMentions(OffsetMap<String> ontologyClassMentions) {
        this.ontologyClassMentions = ontologyClassMentions;
        this.addState(State.ONTOLOGY_CLASS_MENTONS_SET);
    }

    public OffsetMap<String> getChunks() {
        return this.chunks;
    }

    public void setChunks(OffsetMap<String> chunks) {
        this.chunks = chunks;
        this.addState(State.CHUNKS_SET);
    }

    public String getDocumentText() {
        return this.documentText;
    }

    public void setDocumentText(String documentText) {
        this.documentText = documentText;
    }

    public String getDocumentTitle() {
        return this.documentText.substring(this.getTitleOffsets().getMinimum(), this.getTitleOffsets().getMaximum());
    }

    @Deprecated
    public void setDocumentTitle(String documentTitle) {
        this.documentTitle = documentTitle;
    }

    public String getAbstractText() {
        return this.documentText.substring(this.abstractOffsets.getMinimum(), this.abstractOffsets.getMaximum());
    }

    public OffsetMap<List<GeneMention>> getGeneMap() {
        if (this.genes == null) {
            throw new IllegalStateException("The internal genes map has to be built first by calling an appropriate method after setting the original set of genes.");
        }
        return this.genes;
    }

    public Stream<GeneMention> getGeneMentionsAtOffsets(Range<Integer> offsets) {
        return this.getGenes().filter(g2 -> g2.getOffsets().isOverlappedBy(offsets));
    }

    public NavigableSet<GeneMention> getAllGeneMentions(GeneMention gm, GeneMention.GeneTagger tagger) {
        GeneMention gmKey = new GeneMention();
        gmKey.setOffsets(gm.getOffsets());
        gmKey.setTagger(tagger);
        return this.getAllGenes().subSet(gmKey, true, gmKey, true);
    }

    public Stream<GeneMention> getGenes() {
        if (this.genes == null) {
            throw new IllegalStateException("The internal genes map has to be built first by calling an appropriate method after setting the original set of genes.");
        }
        return this.genes.values().stream().flatMap(Collection::stream);
    }

    public void setGenes(GeneMention ... genes) {
        this.allGenes = this.createAllGenesSet();
        this.setGenes(Stream.of(genes));
    }

    public void setGenes(Stream<GeneMention> genes) {
        if (this.allGenes != null) {
            this.allGenes.clear();
        } else {
            this.allGenes = this.createAllGenesSet();
        }
        genes.forEach(this.allGenes::add);
        this.allGenes.forEach(g2 -> g2.setGeneDocument(this));
        if (this.termNormalizer != null) {
            this.allGenes.forEach(g2 -> g2.setNormalizer(this.termNormalizer));
        }
    }

    public void setGenes(Collection<GeneMention> genes) {
        if (this.allGenes == null) {
            this.allGenes = this.createAllGenesSet();
        }
        this.setGenes(genes.stream());
    }

    public void addGene(GeneMention gene) {
        if (this.allGenes == null) {
            this.allGenes = this.createAllGenesSet();
        }
        this.allGenes.add(gene);
        gene.setGeneDocument(this);
        if (this.termNormalizer != null) {
            gene.setNormalizer(this.termNormalizer);
        }
        if (gene.getTagger() == GeneMention.GeneTagger.GOLD) {
            this.putGene(gene);
        }
    }

    public Iterable<GeneMention> getGenesIterable() {
        return () -> this.getGenes().iterator();
    }

    public Iterable<GeneMention> getNonRejectedGenesIterable() {
        return () -> this.getNonRejectedGenes().iterator();
    }

    public Stream<GeneMention> getNonRejectedGenes() {
        return this.getGenes().filter(Predicate.not(GeneMention::isRejected));
    }

    public GeneSets getGeneSets() {
        if (this.geneSets != null) {
            return this.geneSets;
        }
        GeneSets geneSets = new GeneSets();
        this.getGenes().forEach(gm -> {
            List<String> taxonomyIds = gm.getTaxonomyIds() != null && !gm.getTaxonomyIds().isEmpty() ? gm.getTaxonomyIds() : List.of("NoId");
            for (String taxId : taxonomyIds) {
                GeneSet geneSet = new GeneSet();
                geneSet.setTaxId(taxId);
                geneSet.add((GeneMention)gm);
                gm.addGeneSet(geneSet);
                geneSet.setDocId(this.id);
                geneSet.setSpecificType(gm.getSpecificType());
                if (gm.getCompositeResolver() == null) {
                    this.getLastPosTag(gm.getOffsets(), PosTag.stopTags).ifPresent(tag -> geneSet.setPlural(tag.getTag().equals("NNS")));
                }
                geneSets.add(geneSet);
            }
        });
        this.geneSets = geneSets;
        return geneSets;
    }

    public void resetGeneSets() {
        if (this.geneSets != null) {
            this.geneSets.stream().flatMap(Collection::stream).forEach(gm -> gm.getGeneSets().clear());
        }
        this.geneSets = null;
        if (this.state != null) {
            this.state.removeAll(EnumSet.of(State.AGGLOMERATION_BY_NAME, State.AGGLOMERATION_BY_ACRONYMS));
        }
    }

    public GeneSet addGeneSet(Collection<GeneMention> newGs) {
        GeneSet geneSet = new GeneSet();
        geneSet.addAll((Collection<? extends GeneMention>)newGs);
        geneSet.setDocId(this.id);
        newGs.forEach(gm -> gm.addGeneSet(geneSet));
        newGs.stream().findAny().ifPresent(gm -> {
            geneSet.setSpecificType(gm.getSpecificType());
            this.getLastPosTag(gm.getOffsets(), PosTag.stopTags).ifPresent(tag -> geneSet.setPlural(tag.getTag().equals("NNS")));
        });
        this.geneSets.add(geneSet);
        return geneSet;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Collection<Acronym> getOverlappingAcronyms(Range<Integer> range) {
        return this.acronyms.getOverlapping(range).values();
    }

    public Collection<AcronymLongform> getOverlappingAcronymLongforms(Range<Integer> range) {
        return this.acronymLongforms.getOverlapping(range).values();
    }

    public Range<Integer> getOverlappingSentence(Span span) {
        return this.getOverlappingSentence(span.getOffsets());
    }

    public Range<Integer> getOverlappingSentence(Range<Integer> range) {
        Range<Integer> sentence = this.sentences.locate(range);
        return sentence != null ? sentence : Range.between(0, 0);
    }

    public Set<Map.Entry<Range<Integer>, String>> getOverlappingOntologyClassMentions(Range<Integer> range) {
        return this.ontologyClassMentions != null ? this.ontologyClassMentions.getOverlapping(range).entrySet() : Collections.emptySet();
    }

    public Set<Map.Entry<Range<Integer>, String>> getOverlappingOntologyClassMentions(Range<Integer> range, String specificType) {
        return this.getOverlappingOntologyClassMentions(range).stream().filter(e -> ((String)e.getValue()).equals(specificType)).collect(Collectors.toSet());
    }

    public Set<Map.Entry<Range<Integer>, String>> getOverlappingChunks(Range<Integer> range) {
        return this.chunks.getOverlapping(range).entrySet();
    }

    public Collection<Apposition> getOverlappingAppositions(Range<Integer> range) {
        return this.appositions.getOverlapping(range).values();
    }

    public Set<Map.Entry<Range<Integer>, String>> getOverlappingChunks(Range<Integer> range, String chunkType) {
        return this.getOverlappingChunks(range).stream().filter(e -> ((String)e.getValue()).equals(chunkType)).collect(Collectors.toSet());
    }

    public Collection<PosTag> getOverlappingPosTags(Range<Integer> range) {
        if (this.posTags == null) {
            return Collections.emptyList();
        }
        return this.posTags.getOverlapping(range).values();
    }

    public Optional<PosTag> getLastPosTag(Range<Integer> range, Set<String> excludedTags) {
        List posList = this.getOverlappingPosTags(range).stream().collect(Collectors.toList());
        if (posList.isEmpty()) {
            return Optional.empty();
        }
        for (int i = posList.size() - 1; i >= 0; --i) {
            PosTag posTag = (PosTag)posList.get(i);
            if (excludedTags != null && !excludedTags.isEmpty() && excludedTags.contains(posTag.getTag())) continue;
            return Optional.of(posTag);
        }
        return Optional.empty();
    }

    public OffsetMap<PosTag> getPosTags() {
        return this.posTags;
    }

    public void setPosTags(Stream<PosTag> posTags) {
        this.posTags = new OffsetMap();
        posTags.map(pos -> {
            if (pos.getTag().equals("NN") && this.documentText != null && pos.getEnd() < this.documentText.length()) {
                Matcher matcher = this.pluralMatcher;
                synchronized (matcher) {
                    this.pluralMatcher.reset(this.getCoveredText((Span)pos));
                    if (this.pluralMatcher.matches()) {
                        pos.setTag("NNS");
                    }
                }
            }
            return pos;
        }).forEach(this.posTags::put);
        this.addState(State.POS_SET);
    }

    public void setPosTags(Collection<PosTag> posTags) {
        this.setPosTags(posTags.stream());
    }

    public Stream<GeneMention> getOverlappingGenes(Range<Integer> range) {
        return this.genes.getOverlapping(range).values().stream().flatMap(list -> list.stream());
    }

    public Stream<GeneMention> getOverlappingGoldGenes(Range<Integer> range) {
        if (this.goldGenes == null) {
            return Stream.empty();
        }
        return this.goldGenes.getOverlapping(range).values().stream().flatMap(list -> list.stream());
    }

    public NavigableSet<Range<Integer>> getSentences() {
        return this.sentences;
    }

    public void setSentences(OffsetSet sentences) {
        this.sentences = sentences;
        this.addState(State.SENTENCES_SET);
    }

    public SpeciesCandidates getSpecies() {
        return this.species;
    }

    public void setSpecies(SpeciesCandidates species) {
        this.species = species;
        this.addState(State.SPECIES_MENTIONS_SET);
    }

    public void selectAllGenes() {
        this.genes = new OffsetMap();
        if (this.allGenes == null) {
            this.allGenes = this.createAllGenesSet();
        }
        this.allGenes.forEach(g2 -> this.putGene((GeneMention)g2));
        this.addState(State.GENES_SELECTED);
    }

    public void selectGeneMentionsByTagger(GeneMention.GeneTagger ... tagger) {
        if (this.genes == null) {
            this.genes = new OffsetMap();
        }
        HashSet<GeneMention.GeneTagger> includedTaggers = new HashSet<GeneMention.GeneTagger>(Arrays.asList(tagger));
        for (GeneMention g2 : this.allGenes) {
            if (g2.getTagger() == null) {
                log.error("Gene {} in document {} does not have a tagger set", (Object)g2.getText(), (Object)g2.getDocId());
                continue;
            }
            if (!includedTaggers.contains((Object)g2.getTagger()) || !this.genes.getOverlapping(g2.getOffsets()).isEmpty()) continue;
            this.putGene(g2, false);
        }
        this.addState(State.GENES_SELECTED);
    }

    public void expectState(EnumSet<State> expectedStates) {
        for (State s2 : expectedStates) {
            if (this.state.contains((Object)s2)) continue;
            throw new IllegalStateException("Expected state " + s2 + " which is not set to this document. The current document processing state is " + this.state);
        }
    }

    public void allowGeneMentionsByRegularExpression(GeneMention.GeneTagger tagger, Pattern ... regExes) {
        Matcher[] ms = new Matcher[regExes.length];
        for (int i = 0; i < regExes.length; ++i) {
            ms[i] = regExes[i].matcher("");
        }
        for (GeneMention gm : this.allGenes) {
            if (tagger != null && gm.getTagger() != tagger) continue;
            boolean allowed = false;
            for (int i = 0; i < regExes.length && !allowed; ++i) {
                ms[i].reset(gm.getText());
                if (!ms[i].matches()) continue;
                allowed = true;
            }
            if (!allowed) continue;
            this.putGene(gm);
        }
    }

    public void unifyGeneMentionsAtEqualOffsets(GeneMention.GeneTagger ... taggerPriorities) {
        this.genes = new OffsetMap();
        HashMap priorities = new HashMap();
        IntStream.range(0, taggerPriorities.length).forEach(i -> priorities.put(taggerPriorities[i], i));
        for (GeneMention gm : this.allGenes) {
            List genesAtOffset = (List)this.genes.get(gm.getOffsets());
            if (genesAtOffset == null) {
                this.putGene(gm);
                continue;
            }
            for (GeneMention gmInMap : genesAtOffset) {
                int priorityInMap = priorities.getOrDefault((Object)gmInMap.getTagger(), Integer.MAX_VALUE);
                int gmPriority = priorities.getOrDefault((Object)gm.getTagger(), Integer.MAX_VALUE);
                if (gmPriority <= priorityInMap) continue;
                this.replaceGene(gmInMap, gm);
            }
        }
    }

    public void unifyAcronymsLongerFirst() {
        TreeSet<Span> unifiedSet = this.unifySpanLongerFirst(this.acronyms.values());
        this.acronyms = new OffsetMap();
        unifiedSet.forEach(g2 -> this.acronyms.put(g2.getOffsets(), (Acronym)g2));
    }

    public void unifyAllGenesLongerFirst() {
        TreeSet<Span> unifiedSet = this.unifySpanLongerFirst(this.allGenes);
        this.genes = new OffsetMap();
        unifiedSet.forEach(g2 -> this.putGene((GeneMention)g2));
    }

    public void unifyAllGenesLongerFirst(GeneMention.GeneTagger ... taggers) {
        this.selectGeneMentionsByTagger(taggers);
        TreeSet<Span> unifiedSet = this.unifySpanLongerFirst(this.genes.values().stream().flatMap(list -> list.stream()).collect(Collectors.toList()));
        this.genes = new OffsetMap();
        unifiedSet.forEach(g2 -> this.putGene((GeneMention)g2));
    }

    private TreeSet<Span> unifySpanLongerFirst(Collection<? extends Span> spans) {
        Span otherGene = null;
        TreeSet<Span> sortedGenes = new TreeSet<Span>(new OffsetSpanComparator());
        for (Span span : spans) {
            int otherLength;
            int gmLength;
            if (sortedGenes.contains(span)) continue;
            otherGene = sortedGenes.floor(span);
            if (null != otherGene) {
                if (otherGene.getOffsets().isOverlappedBy(span.getOffsets())) {
                    gmLength = span.getOffsets().getMaximum() - span.getOffsets().getMinimum();
                    if (gmLength <= (otherLength = otherGene.getOffsets().getMaximum() - otherGene.getOffsets().getMinimum()) || !sortedGenes.remove(otherGene)) continue;
                    sortedGenes.add(span);
                    continue;
                }
                sortedGenes.add(span);
                continue;
            }
            otherGene = sortedGenes.ceiling(span);
            if (null != otherGene) {
                if (otherGene.getOffsets().isOverlappedBy(span.getOffsets())) {
                    gmLength = span.getOffsets().getMaximum() - span.getOffsets().getMinimum();
                    if (gmLength <= (otherLength = otherGene.getOffsets().getMaximum() - otherGene.getOffsets().getMinimum()) || !sortedGenes.remove(otherGene)) continue;
                    sortedGenes.add(span);
                    continue;
                }
                sortedGenes.add(span);
                continue;
            }
            sortedGenes.add(span);
        }
        return sortedGenes;
    }

    public void unifyGenesPrioritizeTagger(NavigableSet<GeneMention> sortedGenes, GeneMention.GeneTagger tagger) {
        this.allGenes.forEach(gm -> {
            GeneMention otherGene = null;
            if (sortedGenes.contains(gm)) {
                GeneMention.GeneTagger candidateTagger = gm.getTagger();
                if (candidateTagger == tagger && sortedGenes.remove(gm)) {
                    sortedGenes.add((GeneMention)gm);
                }
            } else {
                otherGene = sortedGenes.floor((GeneMention)gm);
                if (null != otherGene) {
                    if (otherGene.getOffsets().isOverlappedBy(gm.getOffsets())) {
                        GeneMention.GeneTagger candidateTagger = gm.getTagger();
                        if (candidateTagger == tagger && sortedGenes.remove(otherGene)) {
                            sortedGenes.add((GeneMention)gm);
                        }
                    } else {
                        sortedGenes.add((GeneMention)gm);
                    }
                } else {
                    otherGene = sortedGenes.ceiling((GeneMention)gm);
                    if (null != otherGene) {
                        if (otherGene.getOffsets().isOverlappedBy(gm.getOffsets())) {
                            GeneMention.GeneTagger candidateTagger = gm.getTagger();
                            if (candidateTagger == tagger && sortedGenes.remove(otherGene)) {
                                sortedGenes.add((GeneMention)gm);
                            }
                        } else {
                            sortedGenes.add((GeneMention)gm);
                        }
                    } else {
                        sortedGenes.add((GeneMention)gm);
                    }
                }
            }
        });
        this.genes = new OffsetMap();
        sortedGenes.forEach(g2 -> this.putGene((GeneMention)g2));
    }

    public NavigableSet<GeneMention> getAllGenes() {
        return this.allGenes == null ? Collections.emptyNavigableSet() : this.allGenes;
    }

    private void putGene(GeneMention gm) {
        this.putGene(gm, true);
    }

    private void putGene(GeneMention gm, boolean addToAllGenes) {
        if (gm.getOffsets() == null) {
            throw new IllegalArgumentException("The passed gene mention does not specify text offsets: " + gm);
        }
        if (this.genes == null) {
            this.genes = new OffsetMap();
        }
        this.putGene(gm, this.genes);
        if (addToAllGenes) {
            if (this.allGenes == null) {
                this.allGenes = this.createAllGenesSet();
            }
            try {
                this.allGenes.add(gm);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println(gm + "; " + gm.getTagger());
                throw e;
            }
        }
    }

    public void putGoldGene(GeneMention gm) {
        if (gm.getOffsets() == null) {
            throw new IllegalArgumentException("The passed gene mention does not specify text offsets: " + gm);
        }
        if (this.goldGenes.isEmpty()) {
            this.goldGenes = new OffsetMap();
        }
        this.putGene(gm, this.goldGenes);
    }

    private void putGene(GeneMention gm, OffsetMap<List<GeneMention>> geneMap) {
        assert (geneMap != null);
        if (gm.getOffsets() == null) {
            throw new IllegalArgumentException("The passed gene mention does not specify text offsets: " + gm);
        }
        ArrayList<GeneMention> gmList = (ArrayList<GeneMention>)geneMap.get(gm.getOffsets());
        if (gmList == null) {
            gmList = new ArrayList<GeneMention>();
            geneMap.put(gm.getOffsets(), gmList);
        }
        if (!gmList.contains(gm)) {
            gmList.add(gm);
        }
        gm.setGeneDocument(this);
        this.resetGeneSets();
    }

    private void replaceGene(GeneMention gene, GeneMention replacement) {
        List gmList = (List)this.genes.get(gene.getOffsets());
        int index = gmList.indexOf(gene);
        gmList.set(index, replacement);
    }

    public String getCoveredText(Span span) {
        return this.getCoveredText(span.getOffsets());
    }

    public String getCoveredText(Range<Integer> range) {
        return this.getCoveredText(range.getMinimum(), range.getMaximum());
    }

    public String getCoveredText(int begin, int end) {
        return this.documentText.substring(begin, end);
    }

    public void selectGene(GeneMention gm) {
        this.putGene(gm);
    }

    public TermNormalizer getTermNormalizer() {
        return this.termNormalizer;
    }

    public void setTermNormalizer(TermNormalizer termNormalizer) {
        this.termNormalizer = termNormalizer;
    }

    public boolean removeGene(GeneMention gm) {
        boolean success = false;
        List genesAtOffset = (List)this.getGeneMap().get(gm.getOffsets());
        if (genesAtOffset != null) {
            genesAtOffset.remove(gm);
            if (genesAtOffset.isEmpty()) {
                boolean bl = success = this.getGeneMap().remove(gm.getOffsets()) != null;
                if (success) {
                    this.resetGeneSets();
                }
            }
        }
        this.allGenes.remove(gm);
        return success;
    }

    public AhoCorasickOptimized getGeneNameDictionary() {
        if (this.geneNameDictionary == null) {
            this.geneNameDictionary = new AhoCorasickOptimized(this.getGenes().map(GeneMention::getText).map(String::toLowerCase).collect(Collectors.toList()));
        }
        return this.geneNameDictionary;
    }

    public void agglomerateByAcronyms() {
        if (this.hasState(State.AGGLOMERATION_BY_ACRONYMS)) {
            return;
        }
        Collection docAcronyms = this.getAcronyms().values();
        if (docAcronyms.isEmpty()) {
            return;
        }
        if (this.geneSets == null) {
            this.getGeneSets();
        }
        for (Acronym acronym : this.getAcronyms().values()) {
            GeneMention longGm;
            Collection gms = this.getOverlappingGenes(acronym.getOffsets()).collect(Collectors.toList());
            if (gms.isEmpty()) continue;
            String acronymText = this.getCoveredText(acronym);
            GeneMention gm = (GeneMention)gms.stream().findFirst().get();
            AcronymLongform longform = acronym.getLongform();
            Collection longGms = this.getOverlappingGenes(longform.getOffsets()).collect(Collectors.toList());
            if (longGms.isEmpty() || gm.equals(longGm = (GeneMention)longGms.stream().findFirst().get()) || gm.getText().length() > acronymText.length() + 2 || !gm.getText().endsWith(acronymText) || gm.getText().length() != acronymText.length() && !Character.isLowerCase(gm.getText().charAt(0))) continue;
            int gmsize = gm.getGeneSets().size();
            int longsize = longGm.getGeneSets().size();
            for (GeneSet gmSet : gm.getGeneSets()) {
                for (GeneSet longGmSet : longGm.getGeneSets()) {
                    GeneSet to;
                    GeneSet from;
                    if (longGms == gmSet || !gmSet.getTaxId().equals(longGmSet.getTaxId()) || gmSet.isPlural() ^ longGmSet.isPlural()) continue;
                    if (gmSet.size() > longGmSet.size()) {
                        from = longGmSet;
                        to = gmSet;
                    } else {
                        from = gmSet;
                        to = longGmSet;
                    }
                    if (from == to) continue;
                    to.addAll(from, false);
                    from.clear();
                }
            }
        }
        this.cleanAndEnumerateGeneSets();
        this.getGenes().forEach(GeneMention::clearGeneSets);
        this.geneSets.forEach(gs -> gs.forEach(gm -> gm.addGeneSet((GeneSet)gs)));
        this.addState(State.AGGLOMERATION_BY_ACRONYMS);
    }

    public void agglomerateByCoreference() {
        if (this.hasState(State.AGGLOMERATION_BY_COREFERENCES)) {
            return;
        }
        if (this.coreferenceSets == null || this.coreferenceSets.isEmpty()) {
            return;
        }
        if (this.geneSets == null) {
            this.getGeneSets();
        }
        for (CoreferenceSet corefSet : this.coreferenceSets) {
            HashMap<String, GeneSet> tax2geneset = new HashMap<String, GeneSet>();
            for (CoreferenceExpression corefExp : corefSet) {
                Iterator geneIt = this.getOverlappingGenes(corefExp.getOffsets()).iterator();
                while (geneIt.hasNext()) {
                    GeneMention gm = (GeneMention)geneIt.next();
                    for (String taxId : gm.getTaxonomyIds()) {
                        GeneSet oldGs;
                        GeneSet gs2 = tax2geneset.compute(taxId, (arg_0, arg_1) -> GeneDocument.lambda$agglomerateByCoreference$32(oldGs = gm.getGeneSets().getGeneSet(taxId), arg_0, arg_1));
                        if (gs2 == oldGs) continue;
                        HashSet<GeneMention> tmp = new HashSet<GeneMention>(oldGs);
                        oldGs.clear();
                        tmp.forEach(g2 -> g2.getGeneSets().remove(oldGs));
                        gs2.addAll((Collection<? extends GeneMention>)tmp);
                    }
                }
            }
        }
        this.cleanAndEnumerateGeneSets();
        this.getGenes().forEach(GeneMention::clearGeneSets);
        this.geneSets.forEach(gs -> gs.forEach(gm -> gm.addGeneSet((GeneSet)gs)));
        this.addState(State.AGGLOMERATION_BY_COREFERENCES);
    }

    private void cleanAndEnumerateGeneSets() {
        int number = 0;
        Iterator iterator = this.getGeneSets().iterator();
        while (iterator.hasNext()) {
            GeneSet gs = (GeneSet)iterator.next();
            if (gs.isEmpty()) {
                iterator.remove();
                continue;
            }
            gs.setNumber(number++);
        }
    }

    public void agglomerateByNames(boolean dontMergeDifferentTaxonomyIds) {
        if (this.hasState(State.AGGLOMERATION_BY_NAME)) {
            return;
        }
        if (this.geneSets == null) {
            this.getGeneSets();
        }
        for (GeneMention gm1 : this.getGenesIterable()) {
            for (GeneMention gm2 : this.getGenesIterable()) {
                for (String tax1 : gm1.getTaxonomyIds()) {
                    for (String tax2 : gm2.getTaxonomyIds()) {
                        Set jNameSet;
                        GeneSet jSet;
                        GeneSet iSet = gm1.getGeneSets().getGeneSet(tax1);
                        if (iSet == (jSet = gm2.getGeneSets().getGeneSet(tax2)) || iSet.isEmpty() || jSet.isEmpty() || !iSet.getTaxId().equals(jSet.getTaxId()) || iSet.isPlural() ^ jSet.isPlural() || dontMergeDifferentTaxonomyIds && !iSet.getTaxId().equals(jSet.getTaxId())) continue;
                        Function<GeneMention, Stream> gm2gnFunc = gm -> Stream.concat(Stream.of(gm.getGeneName()), gm.getGeneName().getAlternatives().stream()).map(gn -> this.termNormalizer.normalize(gn.getText())).map(s2 -> Arrays.stream(s2.split("\\s+")).collect(Collectors.toSet()));
                        Set iNameSet = iSet.stream().flatMap(gm2gnFunc).collect(Collectors.toSet());
                        if (Sets.intersection(iNameSet, jNameSet = jSet.stream().flatMap(gm2gnFunc).collect(Collectors.toSet())).isEmpty()) continue;
                        iSet.addAll(jSet, false);
                        jSet.clear();
                    }
                }
            }
        }
        this.cleanAndEnumerateGeneSets();
        this.getGenes().forEach(GeneMention::clearGeneSets);
        this.geneSets.forEach(gs -> gs.forEach(gm -> gm.addGeneSet((GeneSet)gs)));
        this.addState(State.AGGLOMERATION_BY_NAME);
    }

    public void generateGeneNameVariants() {
        if (this.hasState(State.GENE_VARIANTS_GENERATED)) {
            return;
        }
        Map<String, String> acro2long = this.acronyms.values().stream().collect(Collectors.toMap(acronym -> this.getCoveredText(acronym.getOffsets()), acronym -> this.getCoveredText(acronym.getLongform().getOffsets()), (x, y) -> x));
        HashMap<String, String> acro2longvariants = new HashMap<String, String>();
        for (String acro : acro2long.keySet()) {
            String longform = acro2long.get(acro);
            if (!acro.endsWith("s") || !longform.endsWith("s")) continue;
            acro2longvariants.put(acro.substring(0, acro.length() - 1), longform.substring(0, longform.length() - 1));
        }
        acro2long.putAll(acro2longvariants);
        AhoCorasickOptimized acroAc = new AhoCorasickOptimized(acro2long.keySet());
        Function<GeneMention, Stream> gm2gnFunc = gm -> Stream.concat(Stream.of(gm.getGeneName()), gm.getGeneName().getAlternatives().stream()).flatMap(gn -> Stream.of(gn.getText(), this.termNormalizer.normalize(gn.getText()))).flatMap(s2 -> {
            Stream.Builder<String> variantBuilder = Stream.builder();
            variantBuilder.accept((String)s2);
            acroAc.match((String)s2, (start, end, match) -> variantBuilder.accept(new StringBuilder((String)s2).replace(start, end + 1, (String)acro2long.get(match)).toString()));
            Stream build = variantBuilder.build();
            List collect = build.collect(Collectors.toList());
            return collect.stream();
        }).filter(Objects::nonNull).map(s2 -> new GeneName((String)s2, this.termNormalizer));
        for (GeneMention gm2 : this.getGenesIterable()) {
            Set alreadyKnownAlternatives = Stream.concat(Stream.of(this.termNormalizer.normalize(gm2.getText())), gm2.getGeneName().getAlternatives().stream().map(gn -> this.termNormalizer.normalize(gn.getText()))).collect(Collectors.toSet());
            List<GeneName> variantsWithNonDesc = gm2gnFunc.apply(gm2).filter(gn -> alreadyKnownAlternatives.add(this.termNormalizer.normalize(gn.getText()))).collect(Collectors.toList());
            variantsWithNonDesc.forEach(gm2.getGeneName()::addAlternative);
            List variantsWithoutNonDesc = gm2gnFunc.apply(gm2).map(GeneName::getText).filter(s2 -> alreadyKnownAlternatives.add(this.termNormalizer.normalize(TermNormalizer.removeNondescriptives(s2)))).map(s2 -> new GeneName(TermNormalizer.removeNondescriptives(s2), this.termNormalizer)).collect(Collectors.toList());
            for (GeneName gn2 : variantsWithoutNonDesc) {
                gm2.getGeneName().addAlternative(gn2);
            }
        }
        this.addState(State.GENE_VARIANTS_GENERATED);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeneDocument that = (GeneDocument)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public Collection<MeshHeading> getMeshHeadings() {
        return this.meshHeadings != null ? this.meshHeadings : Collections.emptyList();
    }

    public void setMeshHeadings(Collection<MeshHeading> meshHeadings) {
        this.meshHeadings = meshHeadings;
    }

    public Stream<GeneMention> getGenesWithText(String text) {
        return this.getGenes().filter(gm -> gm.getText().equals(text));
    }

    public Map.Entry<Range<Integer>, SpeciesMention> getNearestPreviousSpeciesMention(Range<Integer> range, String taxId) {
        OffsetMap<SpeciesMention> speciesCandidates = this.species.getAllMentionCandidates();
        Map.Entry<Range<Integer>, SpeciesMention> lower = speciesCandidates.lowerEntry(range);
        while (lower != null && (!((SpeciesMention)lower.getValue()).getTaxId().equals(taxId) && taxId != null || lower.getKey().isOverlappedBy(range))) {
            lower = speciesCandidates.lowerEntry(lower.getKey());
        }
        if (lower != null && !((SpeciesMention)lower.getValue()).getTaxId().equals(taxId) && taxId != null) {
            lower = null;
        }
        return lower;
    }

    public Map.Entry<Range<Integer>, SpeciesMention> getNearestPreviousSpeciesMention(Range<Integer> range) {
        return this.getNearestPreviousSpeciesMention(range, null);
    }

    public Map.Entry<Range<Integer>, SpeciesMention> getNearestNextSpeciesMention(Range<Integer> range, String taxId) {
        OffsetMap<SpeciesMention> speciesCandidates = this.species.getAllMentionCandidates();
        Map.Entry<Range<Integer>, SpeciesMention> higher = speciesCandidates.higherEntry(range);
        while (higher != null && (!((SpeciesMention)higher.getValue()).getTaxId().equals(taxId) && taxId != null || higher.getKey().isOverlappedBy(range))) {
            higher = speciesCandidates.higherEntry(higher.getKey());
        }
        if (higher != null && !((SpeciesMention)higher.getValue()).getTaxId().equals(taxId) && taxId != null) {
            higher = null;
        }
        return higher;
    }

    public Set<GeneLocation> findChromosomeLocations() {
        if (this.chromosomeLocations == null) {
            this.chromosomeLocations = new HashSet<GeneLocation>();
            Matcher m3 = GeneLocation.MAP_LOC_PATTERN.matcher(this.getDocumentText());
            while (m3.find()) {
                this.chromosomeLocations.add(new GeneLocation(m3));
            }
        }
        return this.chromosomeLocations;
    }

    public Stream<String> getDocumentContext(Range<Integer> inputOffsets, int numTokens) {
        return this.getDocumentContext(inputOffsets, Collections.emptySet(), false, numTokens);
    }

    public Stream<String> getDocumentContext(Range<Integer> inputOffsets, Set<String> excludedTokens, boolean excludeGeneMentions, int numTokens) {
        String coveredText;
        Range<Integer> tokenOffset;
        int i;
        Set<Object> allstopwords;
        if (numTokens == 0) {
            return Stream.empty();
        }
        Set<Object> set = allstopwords = !excludedTokens.isEmpty() || excludeGeneMentions ? new HashSet() : Collections.emptySet();
        if (excludeGeneMentions) {
            if (this.geneMentionTexts == null) {
                for (GeneMention gm : this.getGenesIterable()) {
                    this.geneMentionTexts = Stream.of(gm.getText().split("\\s+")).collect(Collectors.toSet());
                }
            }
            allstopwords.addAll(this.geneMentionTexts);
        }
        String[] contextTokens = new String[numTokens];
        Range<Integer> focusOffsets = inputOffsets;
        for (i = (int)((double)numTokens / 2.0); i >= 0 && (tokenOffset = this.posTags.lowerKey(focusOffsets)) != null; --i) {
            coveredText = this.getCoveredText(tokenOffset);
            if (allstopwords.isEmpty() || !allstopwords.contains(coveredText)) {
                contextTokens[i] = coveredText;
            }
            focusOffsets = tokenOffset;
        }
        focusOffsets = inputOffsets;
        for (i = (int)((double)numTokens / 2.0) + 1; i < numTokens && (tokenOffset = this.posTags.higherKey(focusOffsets)) != null; ++i) {
            coveredText = this.getCoveredText(tokenOffset);
            if (allstopwords.isEmpty() || !allstopwords.contains(coveredText)) {
                contextTokens[i] = coveredText;
            }
            focusOffsets = tokenOffset;
        }
        return Arrays.stream(contextTokens).filter(Objects::nonNull);
    }

    public void reset() {
        this.resetGeneSets();
        this.getGenes().forEach(gm -> {
            gm.setMentionMappingResult(null);
            gm.setTaxonomyOcurrences(HashMultimap.create());
        });
        this.state = new LinkedHashSet<State>();
    }

    public boolean isGoldHasOffsets() {
        return this.goldHasOffsets;
    }

    public void setGoldMentionsWithOffsets(boolean goldHasOffsets) {
        this.goldHasOffsets = goldHasOffsets;
    }

    public String getPubTatorString() {
        String ls = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        if (this.documentTitle != null && !this.documentTitle.isBlank()) {
            sb.append(this.id).append("|t|").append(this.documentTitle).append(ls);
        }
        if (this.documentText != null && !this.documentText.isBlank()) {
            sb.append(this.id).append("|a|").append(this.abstractText).append(ls);
        }
        for (GeneMention gm : this.getGenesIterable()) {
            MentionMappingResult mmr = gm.getMentionMappingResult();
            if (gm.isRejected()) continue;
            sb.append(this.id).append("\t").append(gm.getBegin()).append("\t").append(gm.getEnd()).append("\t").append(gm.getText()).append("\t").append("Gene");
            sb.append(ls);
        }
        return sb.toString();
    }

    @Deprecated
    public void setDocumentAbstract(String abstractText) {
        this.abstractText = abstractText;
    }

    public String getInspectionText(Function<GeneMention, MentionCorrectness> correctnessFunction, Map<MentionCorrectness, Function<GeneMention, String>> renderFunctions) {
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        for (GeneMention gm : () -> this.getGenes().sorted(Comparator.comparingInt(GeneMention::getBegin)).iterator()) {
            int begin = gm.getBegin();
            sb.append(this.documentText, Math.min(pos, begin), begin);
            MentionCorrectness correctness = correctnessFunction.apply(gm);
            Function<GeneMention, String> geneMentionStringFunction = renderFunctions.get((Object)correctness);
            String apply = geneMentionStringFunction.apply(gm);
            sb.append(apply);
            pos = gm.getEnd();
        }
        sb.append(this.documentText, pos, this.documentText.length());
        return sb.toString();
    }

    public String getGenesetInspectionText(BiFunction<GeneMention, String, MentionCorrectness> correctnessFunction, Map<MentionCorrectness, BiFunction<GeneMention, String, String>> renderFunctions) {
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        for (GeneMention gm : () -> this.getGenes().sorted(Comparator.comparingInt(GeneMention::getBegin)).iterator()) {
            List<String> goldIdList = gm.hasGoldMentions() ? gm.getAllGoldIdsAsList() : List.of("NoId");
            List overlappingGenes = gm.getGeneDocument().getOverlappingGenes(gm.getOffsets()).collect(Collectors.toList());
            int index = overlappingGenes.indexOf(gm);
            String goldId = goldIdList.get(Math.min(index, goldIdList.size() - 1));
            int begin = gm.getBegin();
            sb.append(this.documentText, Math.min(pos, begin), begin);
            BiFunction<GeneMention, String, String> geneMentionStringFunction = renderFunctions.get((Object)correctnessFunction.apply(gm, goldId));
            String apply = geneMentionStringFunction.apply(gm, goldId);
            sb.append(apply);
            pos = gm.getEnd();
        }
        sb.append(this.documentText, pos, this.documentText.length());
        return sb.toString();
    }

    public Set<String> getGoldTaxonomyIds() {
        return this.goldTaxonomyIds;
    }

    public void setGoldTaxonomyIds(Set<String> goldTaxonomyIds) {
        this.goldTaxonomyIds = goldTaxonomyIds;
    }

    public boolean isCompletelyAnnotated() {
        return this.completelyAnnotated;
    }

    public void setCompletelyAnnotated(boolean completelyAnnotated) {
        this.completelyAnnotated = completelyAnnotated;
    }

    public boolean isGoldOffsetsInferred() {
        return this.goldOffsetsInferred;
    }

    public void setGoldOffsetsInferred(boolean goldOffsetsInferred) {
        this.goldOffsetsInferred = goldOffsetsInferred;
    }

    public void clearSelectedGenes() {
        this.genes = null;
    }

    public Collection<CoreferenceSet> getCoreferenceSets() {
        return this.coreferenceSets;
    }

    public void setCoreferenceRelations(Collection<CoreferenceSet> coreferenceSets) {
        this.coreferenceSets = coreferenceSets;
        this.coreferenceExpressions = new OffsetMap();
        coreferenceSets.stream().flatMap(Collection::stream).forEach(this.coreferenceExpressions::put);
    }

    public void setAppositions(Collection<Apposition> appositions) {
        this.appositions = new OffsetMap(appositions);
    }

    public void setAppositionContextToGeneNames() {
        for (GeneMention gm : this.getGenesIterable()) {
            Apposition overlappingApposition = this.appositions.getFirstLargestIntersectionValue(gm.getOffsets());
            if (overlappingApposition == null) continue;
            Apposition inApposition = overlappingApposition.getOther();
            gm.getGeneName().addAppositionContext(this.getCoveredText(inApposition));
        }
    }

    public Range<Integer> getOverlappingNonGenePhrases(Range<Integer> offsets) {
        Range<Integer> nonGenePhrase = this.nonGenePhrases.isEmpty() ? null : this.nonGenePhrases.locate(offsets);
        return nonGenePhrase != null && nonGenePhrase.isOverlappedBy(offsets) ? nonGenePhrase : Range.between(0, 0);
    }

    public OffsetSet getNonGenePhrases() {
        return this.nonGenePhrases;
    }

    public void setNonGenePhrases(OffsetSet nonGenePhrases) {
        this.nonGenePhrases = nonGenePhrases;
    }

    public void rejectGenesOverlappingNonGenePhrases() {
        for (GeneMention gm : this.getGenesIterable()) {
            if (this.getOverlappingNonGenePhrases(gm.getOffsets()).getMaximum() <= 0) continue;
            gm.reject(MentionMappingResult.RejectReason.IS_NON_GENE_WORD);
        }
    }

    private static /* synthetic */ GeneSet lambda$agglomerateByCoreference$32(GeneSet oldGs, String k, GeneSet v) {
        return v != null && !v.isEmpty() ? v : oldGs;
    }

    public static enum State {
        GENES_SELECTED,
        SENTENCES_SET,
        SPECIES_MENTIONS_SET,
        ACRONYMS_SET,
        CHUNKS_SET,
        POS_SET,
        SPECIES_CANDIDATES_ASSIGNED,
        SYNONYM_CANDIDATES_ASSIGNED,
        SPECIES_CANDIDATES_FILTERED,
        MESH_TAX_IDS_ASSIGNED,
        REFERENCE_SPECIES_ADDED,
        SPECIES_SCORES_ASSIGNED,
        AGGLOMERATION_BY_ACRONYMS,
        AGGLOMERATION_BY_NAME,
        AGGLOMERATION_BY_COREFERENCES,
        SPECIES_ASSIGNED_TO_GENES,
        ONTOLOGY_CLASS_MENTONS_SET,
        GENE_VARIANTS_GENERATED;

    }

    public static enum MentionCorrectness {
        CORRECT_ID,
        WRONG_ID,
        CANT_FIND;

    }
}

