/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase.genemodel;

import de.julielab.geneexpbase.genemodel.DictionaryGeneIdRecordItem;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class DictionaryGeneIdRecord {
    private String geneName;
    private final List<DictionaryGeneIdRecordItem> recordItems;

    public DictionaryGeneIdRecord(String recordString) {
        String[] split = recordString.split("\t");
        this.geneName = split[0];
        this.recordItems = Arrays.stream(split[1].split("\\|")).map(DictionaryGeneIdRecordItem::new).collect(Collectors.toList());
    }

    public String getGeneName() {
        return this.geneName;
    }

    public void setGeneName(String geneName) {
        this.geneName = geneName;
    }

    public Stream<DictionaryGeneIdRecordItem> getRecordItemsForTaxId(String tax) {
        return this.recordItems.stream().filter(r -> r.getTaxId().equals(tax));
    }

    public Stream<String> getGeneIds() {
        return this.recordItems.stream().map(DictionaryGeneIdRecordItem::getGeneId);
    }

    public Stream<String> getTaxIds() {
        return this.recordItems.stream().map(DictionaryGeneIdRecordItem::getTaxId);
    }

    public IntStream getPriorities() {
        return this.recordItems.stream().mapToInt(DictionaryGeneIdRecordItem::getPriority);
    }
}

