/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase.data;

import com.ximpleware.ParseException;
import com.ximpleware.XPathParseException;
import de.julielab.geneexpbase.candidateretrieval.CandidateRetrieval;
import de.julielab.xml.JulieXMLTools;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneInformation {
    private static final Logger log = LoggerFactory.getLogger(GeneInformation.class);
    public static Set<String> DISCONTINUED = new HashSet<String>(Arrays.asList("7683036", "5692362", "3637603", "2087", "8156091", "1236923", "5331242", "1236924", "1236921", "1236926", "1236922", "1236925", "8382257", "2703416", "1114633", "1113606", "899850", "3733184", "1207690", "2956481", "988404", "2770142", "2553144", "1123836", "1124516", "1173020", "5331715", "960243", "956561", "5859591", "7011691", "1183025", "17494192"));
    public static Map<String, String> REPLACED = new HashMap<String, String>();
    public static Map<String, String> GENE2TAX;

    public static String replaceGeneByTaxId(String geneId, CandidateRetrieval candidateRetrieval) {
        String usedGeneId = geneId;
        try {
            String taxId = candidateRetrieval.mapGeneIdToTaxId(usedGeneId);
            if (taxId == null || taxId.trim().isEmpty()) {
                log.info("The index does not contain a taxonomy ID for gene {}. Checking the internal map for deprecated genes", (Object)usedGeneId);
                taxId = GENE2TAX.get(usedGeneId);
                if (taxId != null) {
                    log.info("Retrieved taxonomy ID {} from the internal map for gene ID {}", (Object)taxId, (Object)usedGeneId);
                }
            }
            if (taxId == null && DISCONTINUED.contains(usedGeneId)) {
                log.info("Gene {} is discontinued and not yet added to the internal map, requesting NCBI EUtils for the taxonomy ID because it is not present in the index", (Object)usedGeneId);
                taxId = JulieXMLTools.getXpathValue("//TaxID", new URL("https://eutils.ncbi.nlm.nih.gov/entrez/eutils/esummary.fcgi?db=gene&id=" + usedGeneId).openStream());
                if (taxId == null) {
                    log.warn("Retrieval of the taxonomy ID of the gene ID {} via eUtils was not successful", (Object)usedGeneId);
                } else {
                    log.info("Retrieved taxonomy ID {} for gene ID {}", (Object)taxId, (Object)usedGeneId);
                }
            }
            if (taxId == null && REPLACED.containsKey(usedGeneId)) {
                usedGeneId = REPLACED.get(usedGeneId);
                log.info("The gene with ID {} has been replaced by ID {}. Trying to find a taxonomy ID for the newer ID.", (Object)geneId, (Object)usedGeneId);
                taxId = candidateRetrieval.mapGeneIdToTaxId(usedGeneId);
            }
            if (taxId == null) {
                log.warn("Gene ID " + usedGeneId + " does not have a taxonomy ID in the mention index and no entry in the internal maps leading to a taxonomy ID.");
            }
            return taxId;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (XPathParseException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    static {
        REPLACED.put("422", "7043");
        REPLACED.put("7330", "283556");
        REPLACED.put("4197", "2122");
        REPLACED.put("4276", "100507436");
        REPLACED.put("6686", "123606");
        REPLACED.put("769896", "101748159");
        REPLACED.put("3974666", "10322146");
        REPLACED.put("6435", "653509");
        REPLACED.put("5904", "727851");
        GENE2TAX = new HashMap<String, String>();
        GENE2TAX.put("7683036", "488221");
        GENE2TAX.put("5692362", "438753");
        GENE2TAX.put("3637603", "237561");
        GENE2TAX.put("105369247", "9606");
        GENE2TAX.put("2087", "9606");
        GENE2TAX.put("8156091", "866768");
        GENE2TAX.put("1236923", "266834");
        GENE2TAX.put("5331242", "426430");
        GENE2TAX.put("1236924", "266834");
        GENE2TAX.put("1236921", "266834");
        GENE2TAX.put("1236926", "266834");
        GENE2TAX.put("1236922", "266834");
        GENE2TAX.put("1236925", "266834");
        GENE2TAX.put("8382257", "1396");
        GENE2TAX.put("192343", "9606");
        GENE2TAX.put("3293002", "770");
        GENE2TAX.put("2828033", "1280");
        GENE2TAX.put("2703416", "10298");
        GENE2TAX.put("1114633", "272623");
        GENE2TAX.put("1113606", "272623");
        GENE2TAX.put("899850", "85962");
        GENE2TAX.put("3733184", "316273");
        GENE2TAX.put("3974662", "4530");
        GENE2TAX.put("3293595", "260799");
        GENE2TAX.put("3760030", "4565");
        GENE2TAX.put("192347", "7227");
        GENE2TAX.put("1207690", "226900");
        GENE2TAX.put("192346", "7955");
        GENE2TAX.put("3293289", "28450");
        GENE2TAX.put("2829141", "29488");
        GENE2TAX.put("192344", "10090");
        GENE2TAX.put("2956481", "273123");
        GENE2TAX.put("988404", "195102");
        GENE2TAX.put("2828679", "11320");
        GENE2TAX.put("2770142", "267671");
        GENE2TAX.put("10322146", "746128");
        GENE2TAX.put("2553144", "242619");
        GENE2TAX.put("2828219", "3702");
        GENE2TAX.put("3760026", "4081");
        GENE2TAX.put("1123836", "158879");
        GENE2TAX.put("3293160", "446");
        GENE2TAX.put("1124516", "158879");
        GENE2TAX.put("2828139", "1773");
        GENE2TAX.put("286789", "6239");
        GENE2TAX.put("1173020", "214092");
        GENE2TAX.put("5331715", "426430");
        GENE2TAX.put("2827869", "210");
        GENE2TAX.put("3974689", "5833");
        GENE2TAX.put("3293367", "51453");
        GENE2TAX.put("960243", "155864");
        GENE2TAX.put("956561", "11588");
        GENE2TAX.put("2827909", "487");
        GENE2TAX.put("899205", "85962");
        GENE2TAX.put("5859591", "471473");
    }
}

