/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase.data;

import de.julielab.geneexpbase.genemodel.GeneMention;
import java.io.File;
import java.util.List;
import java.util.Set;

public class DocumentSourceFiles {
    private String name;
    private String basePath = "";
    private String predictedGenesPath;
    private String sentencesPath;
    private String chunksPath;
    private String posPath;
    private String speciesPath;
    private String acronymsPath;
    private String corefPath;
    private String appositionsPath;
    private String meshPath;
    private String substancesPath;
    private String ontologyMentionsPath;
    private String docTextPath;
    private String goldGeneList;
    private List<String> allowedGeneTypes;
    private Set<GeneMention.GeneTagger> taggersToUse;
    private boolean filterSpecies;
    private boolean addReferenceSpecies;
    private boolean hasGeneIds = true;
    private final GeneMention.SpecificType defaultEntityType = GeneMention.SpecificType.GENE;
    private boolean speciesCorpus;
    private boolean inferDocumentLevelLabelsToMentions;
    private boolean completelyAnnotated;
    private String nonGenePhrasesPath;
    private String gazetteerMatchesWithIds;

    public String getAppositionsPath() {
        return this.appositionsPath;
    }

    public void setAppositionsPath(String appositionsPath) {
        this.appositionsPath = this.resolveToBasePath(appositionsPath);
    }

    public String getCorefPath() {
        return this.corefPath;
    }

    public void setCorefPath(String corefPath) {
        this.corefPath = this.resolveToBasePath(corefPath);
    }

    public GeneMention.SpecificType getDefaultEntityType() {
        return this.defaultEntityType;
    }

    @Deprecated
    public boolean isAddReferenceSpecies() {
        return this.addReferenceSpecies;
    }

    @Deprecated
    public void setAddReferenceSpecies(boolean addReferenceSpecies) {
        this.addReferenceSpecies = addReferenceSpecies;
    }

    @Deprecated
    public boolean isFilterSpecies() {
        return this.filterSpecies;
    }

    @Deprecated
    public void setFilterSpecies(boolean filterSpecies) {
        this.filterSpecies = filterSpecies;
    }

    public List<String> getAllowedGeneTypes() {
        return this.allowedGeneTypes;
    }

    public void setAllowedGeneTypes(List<String> allowedGeneTypes) {
        this.allowedGeneTypes = allowedGeneTypes;
    }

    public Set<GeneMention.GeneTagger> getTaggersToUse() {
        return this.taggersToUse;
    }

    public void setTaggersToUse(Set<GeneMention.GeneTagger> taggersToUse) {
        this.taggersToUse = taggersToUse;
    }

    public String getPosPath() {
        return this.posPath;
    }

    public void setPosPath(String posPath) {
        this.posPath = this.resolveToBasePath(posPath);
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getPredictedGenesPath() {
        return this.predictedGenesPath;
    }

    public void setPredictedGenesPath(String predictedGenesPath) {
        this.predictedGenesPath = this.resolveToBasePath(predictedGenesPath);
    }

    public String getSentencesPath() {
        return this.sentencesPath;
    }

    public void setSentencesPath(String sentencesPath) {
        this.sentencesPath = this.resolveToBasePath(sentencesPath);
    }

    public String getChunksPath() {
        return this.chunksPath;
    }

    public void setChunksPath(String chunksPath) {
        this.chunksPath = this.resolveToBasePath(chunksPath);
    }

    public String getSpeciesPath() {
        return this.speciesPath;
    }

    public void setSpeciesPath(String speciesPath) {
        this.speciesPath = this.resolveToBasePath(speciesPath);
    }

    public String getAcronymsPath() {
        return this.acronymsPath;
    }

    public void setAcronymsPath(String acronymsPath) {
        this.acronymsPath = this.resolveToBasePath(acronymsPath);
    }

    public String getMeshPath() {
        return this.meshPath;
    }

    public void setMeshPath(String meshPath) {
        this.setMeshPath(meshPath, true);
    }

    public String getSubstancesPath() {
        return this.substancesPath;
    }

    public void setSubstancesPath(String substancesPath) {
        this.setSubstancesPath(substancesPath, true);
    }

    public String getDocTextPath() {
        return this.docTextPath;
    }

    public void setDocTextPath(String docTextPath) {
        this.docTextPath = this.resolveToBasePath(docTextPath);
    }

    public String getGoldGeneList() {
        return this.goldGeneList;
    }

    public void setGoldGeneList(String goldGeneList) {
        this.goldGeneList = this.resolveToBasePath(goldGeneList);
    }

    public void setMeshPath(String meshPath, boolean appendToBasePath) {
        this.meshPath = appendToBasePath ? this.resolveToBasePath(meshPath) : meshPath;
    }

    public void setSubstancesPath(String substancesPath, boolean appendtoBasePath) {
        this.substancesPath = appendtoBasePath ? this.resolveToBasePath(substancesPath) : substancesPath;
    }

    public boolean hashMesh() {
        return this.meshPath != null && !this.meshPath.isBlank();
    }

    public boolean hasSubstances() {
        return this.substancesPath != null && !this.substancesPath.isBlank();
    }

    private String resolveToBasePath(String path) {
        return this.basePath.isBlank() ? path : this.basePath + File.separator + path;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isHasGeneIds() {
        return this.hasGeneIds;
    }

    public void setHasGeneIds(boolean hasGeneIds) {
        this.hasGeneIds = hasGeneIds;
    }

    public boolean isSpeciesCorpus() {
        return this.speciesCorpus;
    }

    public void setSpeciesCorpus(boolean speciesCorpus) {
        this.speciesCorpus = speciesCorpus;
    }

    public boolean getInferDocumentLevelLabelsToMentions() {
        return this.inferDocumentLevelLabelsToMentions;
    }

    public void setInferDocumentLevelLabelsToMentions(boolean inferDocumentLevelLabelsToMentions) {
        this.inferDocumentLevelLabelsToMentions = inferDocumentLevelLabelsToMentions;
    }

    public boolean isCompletelyAnnotated() {
        return this.completelyAnnotated;
    }

    public void setCompletelyAnnotated(boolean completelyAnnotated) {
        this.completelyAnnotated = completelyAnnotated;
    }

    public String getOntologyMentionsPath() {
        return this.ontologyMentionsPath;
    }

    public void setOntologyMentionsPath(String ontologyMentionsPath) {
        this.ontologyMentionsPath = this.resolveToBasePath(ontologyMentionsPath);
    }

    public void setNonGenePhrasesPath(String nonGenePhrasesPath) {
        this.nonGenePhrasesPath = this.resolveToBasePath(nonGenePhrasesPath);
    }

    public String getNonGenePhrasesPath() {
        return this.nonGenePhrasesPath;
    }

    public String getGazetteerMatchesWithIds() {
        return this.gazetteerMatchesWithIds;
    }

    public void setGazetteerMatchesWithIds(String gazetteerMatchesWithIds) {
        this.gazetteerMatchesWithIds = this.resolveToBasePath(gazetteerMatchesWithIds);
    }
}

