/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase.configuration;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import de.julielab.geneexpbase.GeneExpRuntimeException;
import de.julielab.geneexpbase.configuration.Configuration;
import de.julielab.java.utilities.FileUtilities;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parameters
extends LinkedHashMap<String, Object> {
    private static final long serialVersionUID = 14012021L;
    private static final Logger log = LoggerFactory.getLogger(Parameters.class);
    private final Multimap<String, String> trackedParameters = HashMultimap.create();
    private final Set<String> parameterTrackingKeys = new HashSet<String>();
    private List<String> keysGivenByHpo;

    public Parameters() {
    }

    public Parameters(Properties configuration) {
        this.loadFromProperties(configuration);
    }

    public Parameters(Map<? extends String, ?> m3) {
        super(m3);
    }

    public Parameters(File file) {
        Properties properties = new Properties();
        try (BufferedReader br = FileUtilities.getReaderFromFile(file);){
            properties.load(br);
        }
        catch (IOException e) {
            throw new GeneExpRuntimeException(e);
        }
        this.loadFromProperties(properties);
    }

    public static Parameters of(String key, Object value) {
        Parameters params = new Parameters();
        params.put(key, value);
        return params;
    }

    public static Parameters of(Object ... keysValues) {
        if (keysValues.length % 2 == 1) {
            throw new IllegalArgumentException("There must be an equal number of keys and values.");
        }
        Parameters params = new Parameters();
        for (int i = 0; i < keysValues.length; i += 2) {
            Object key = keysValues[i];
            params.put(key.toString(), keysValues[i + 1]);
        }
        return params;
    }

    public static Parameters load(File source) throws IOException {
        Configuration c = new Configuration(source);
        return new Parameters(c);
    }

    private void loadFromProperties(Properties configuration) {
        for (String key : configuration.stringPropertyNames()) {
            this.put(key, configuration.get(key));
        }
    }

    @Override
    public Object getOrDefault(Object key, Object defaultValue) {
        this.parameterTrackingKeys.forEach((? super T k) -> this.trackedParameters.put((String)k, key.toString()));
        return super.getOrDefault(key, defaultValue);
    }

    @Override
    public Object get(Object key) {
        this.parameterTrackingKeys.forEach((? super T k) -> this.trackedParameters.put((String)k, key.toString()));
        Object o = super.get(key);
        if (o == null) {
            throw new IllegalArgumentException("No value for key " + key + " in the parameter map.");
        }
        return o;
    }

    public <K, V> Map<K, V> getMap(String parameter) {
        return this.get(parameter, HashMap.class::cast);
    }

    public <K, V> Map<K, V> getMap(String parameter, Map<K, V> defaultValue) {
        HashMap map = this.get(parameter, HashMap.class::cast);
        if (map != null) {
            return map;
        }
        return defaultValue;
    }

    public int getInt(String parameter) {
        return this.get(parameter, Integer::parseInt);
    }

    public double getDouble(String parameter) {
        return this.get(parameter, Double::parseDouble);
    }

    public <T> T get(String parameter, Function<String, T> conversionFunction) {
        this.parameterTrackingKeys.forEach((? super T k) -> this.trackedParameters.put((String)k, parameter));
        Object o = this.get(parameter);
        if (o instanceof String) {
            o = conversionFunction.apply((String)o);
            this.put(parameter, o);
        }
        return (T)o;
    }

    public String getString(String parameter) {
        Object o = this.get(parameter);
        return o instanceof String ? (String)o : String.valueOf(o);
    }

    public boolean getBoolean(String parameter) {
        return this.get(parameter, Boolean::parseBoolean);
    }

    public boolean getBoolean(String parameter, boolean defaultValue) {
        boolean exists = this.containsKey(parameter);
        return exists ? this.getBoolean(parameter) : defaultValue;
    }

    public String getString(String parameter, String defaultValue) {
        String o = super.getOrDefault(parameter, defaultValue);
        return o instanceof String ? o : String.valueOf(o);
    }

    public int getInt(String parameter, int defaultValue) {
        boolean exists = this.containsKey(parameter);
        return exists ? this.getInt(parameter) : defaultValue;
    }

    public double getDouble(String parameter, double defaultValue) {
        boolean exists = this.containsKey(parameter);
        return exists ? this.getDouble(parameter) : defaultValue;
    }

    @Override
    public String toString() {
        ArrayList<CallSite> lines = new ArrayList<CallSite>();
        for (String key : this.keySet()) {
            lines.add((CallSite)((Object)(key + " = " + this.get(key))));
        }
        return String.join((CharSequence)"\n", lines);
    }

    public void startParameterUsageTracking(String key) {
        this.parameterTrackingKeys.add(key);
    }

    public void stopParameterUsageTracking(String key) {
        this.parameterTrackingKeys.remove(key);
    }

    public Collection<String> getTrackedParameters(String key) {
        return this.trackedParameters.get(key);
    }

    public boolean isTrackingParameters(String key) {
        return this.parameterTrackingKeys.contains(key);
    }

    public void setKeysGivenBySmac() {
        this.keysGivenByHpo = new ArrayList(this.keySet());
    }

    public List<String> getKeysGivenByHpo() {
        assert (this.keysGivenByHpo != null) : "The keys given by SMAC have never been set.";
        return this.keysGivenByHpo;
    }

    public void store(File destination, boolean onlyKeysGivenBySmac) throws IOException {
        try (BufferedWriter bw = FileUtilities.getWriterToFile(destination);){
            for (String key : onlyKeysGivenBySmac ? this.getKeysGivenByHpo() : this.keySet()) {
                bw.write(key);
                bw.write(" = ");
                bw.write(String.valueOf(this.get(key)));
                bw.newLine();
            }
        }
    }

    public Parameters getTrackedSubConfiguration(String trackingKey) {
        if (this.parameterTrackingKeys == null || this.parameterTrackingKeys.isEmpty() || !this.parameterTrackingKeys.contains(trackingKey)) {
            throw new IllegalArgumentException("The sub configuration for the parameter tracking key '" + trackingKey + "' was requested but this GeneMapperParameters instance did not track for that key.");
        }
        Collection<String> trackedParameters = this.getTrackedParameters(trackingKey);
        if (trackedParameters.isEmpty()) {
            log.warn("The tracked parameter set for the tracking key '{}' is empty.", (Object)trackingKey);
        }
        Parameters subConfiguration = new Parameters();
        for (String p : trackedParameters) {
            subConfiguration.put(p, this.get(p));
        }
        return subConfiguration;
    }
}

