/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase.classification;

import cc.mallet.classify.Classification;
import cc.mallet.classify.Classifier;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.LabelVector;
import de.julielab.geneexpbase.classification.svm.SVM;
import de.julielab.geneexpbase.classification.svm.SVMModel;
import de.julielab.geneexpbase.classification.svm.SVMTrainOptions;
import libsvm.svm_model;

public class SVMClassifier
extends Classifier {
    private SVMModel model;

    @Override
    public Classification classify(Instance instance) {
        svm_model svmModel = this.model.svmModel;
        if (!this.model.trainOptions.probability && svmModel.nr_class != 2) {
            throw new IllegalArgumentException("This method can only be used for two-class problems or when the SVM was trained with probability estimates.");
        }
        double[] scores = SVM.predict(instance, this.model);
        if (scores.length == 1) {
            double[] fullScores = new double[]{scores[0], -1.0 * scores[0]};
            scores = fullScores;
        }
        double[] orderedScores = new double[scores.length];
        for (int i = 0; i < scores.length; ++i) {
            int labelIndex = svmModel.label[i];
            orderedScores[labelIndex] = scores[i];
        }
        return new Classification(instance, this, new LabelVector(this.getLabelAlphabet(), scores));
    }

    public void train(InstanceList instances, SVMTrainOptions options) {
        this.model = SVM.train(instances, options);
        this.instancePipe = instances.getPipe();
    }
}

