/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase.classification;

import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import de.julielab.geneexpbase.classification.MinMaxScalingStats;
import de.julielab.geneexpbase.classification.StandardizationStats;
import de.julielab.geneexpbase.classification.svm.SVMTrainData;
import de.julielab.geneexpbase.genemodel.GeneMention;
import java.util.Arrays;
import java.util.LinkedHashSet;
import libsvm.svm_node;

public class FeatureUtils {
    public static MinMaxScalingStats scaleFeatures(double[][] featureMatrix) {
        int j;
        double[] features;
        int i;
        double[] maxFeatureValues = new double[featureMatrix[0].length];
        double[] minFeatureValues = new double[featureMatrix[0].length];
        for (i = 0; i < featureMatrix.length; ++i) {
            features = featureMatrix[i];
            for (j = 0; j < features.length; ++j) {
                double featureValue = features[j];
                maxFeatureValues[j] = Math.max(maxFeatureValues[j], featureValue);
                minFeatureValues[j] = Math.min(minFeatureValues[j], featureValue);
            }
        }
        for (i = 0; i < featureMatrix.length; ++i) {
            features = featureMatrix[i];
            for (j = 0; j < features.length; ++j) {
                double numerator = features[j] - minFeatureValues[j];
                double denominator = maxFeatureValues[j] - minFeatureValues[j];
                if (numerator == 0.0 || denominator == 0.0) continue;
                features[j] = numerator / denominator;
            }
        }
        return new MinMaxScalingStats(minFeatureValues, maxFeatureValues);
    }

    public static MinMaxScalingStats scaleFeatures(InstanceList instances) {
        double[] maxFeatureValues = new double[((Instance)instances.get(0)).getDataAlphabet().size()];
        double[] minFeatureValues = new double[((Instance)instances.get(0)).getDataAlphabet().size()];
        for (Instance instance : instances) {
            cc.mallet.types.FeatureVector fv = (cc.mallet.types.FeatureVector)instance.getData();
            int numLocations = fv.numLocations();
            int[] indices = fv.getIndices();
            for (int i = 0; i < numLocations; ++i) {
                int index = indices != null ? indices[i] : i;
                double featureValue = fv.isBinary() ? 1.0 : fv.getValues()[i];
                maxFeatureValues[index] = Math.max(maxFeatureValues[index], featureValue);
                minFeatureValues[index] = Math.min(minFeatureValues[index], featureValue);
            }
        }
        FeatureUtils.scaleInstances(instances, maxFeatureValues, minFeatureValues, 0, 1);
        return new MinMaxScalingStats(minFeatureValues, maxFeatureValues);
    }

    public static void scaleInstances(InstanceList instances, double[] maxFeatureValues, double[] minFeatureValues, int lowerBound, int upperBound) {
        if (lowerBound != 0) {
            throw new IllegalArgumentException("Lower bounds other than 0 are currently not supported for feature scaling. The reason is that the feature vectors are sparse and we need to add value to the feature values that are implicitly zero. This can be done, however, look at the standardization code.");
        }
        for (Instance instance : instances) {
            FeatureUtils.scaleInstance(instance, minFeatureValues, maxFeatureValues, lowerBound, upperBound);
        }
    }

    public static void scaleInstance(Instance instance, double[] minFeatureValues, double[] maxFeatureValues, int lowerBound, int upperBound) {
        cc.mallet.types.FeatureVector fv = (cc.mallet.types.FeatureVector)instance.getData();
        int numLocations = fv.numLocations();
        int[] indices = fv.getIndices();
        for (int i = 0; i < numLocations; ++i) {
            int index = indices != null ? indices[i] : i;
            double value = fv.value(index);
            double maxFeatureValue = maxFeatureValues[index];
            double minFeatureValue = minFeatureValues[index];
            double newValue = FeatureUtils.doMinMaxScaling(value, minFeatureValue, maxFeatureValue, lowerBound, upperBound);
            fv.setValue(index, newValue);
        }
    }

    public static double doMinMaxScaling(double originalValue, double min2, double max, double lowerBound, double upperBound) {
        double normalizationFactor = max - min2;
        return normalizationFactor != 0.0 ? Math.min(Math.max(lowerBound + (originalValue - min2) * (upperBound - lowerBound) / normalizationFactor, lowerBound), upperBound) : 0.0;
    }

    public static void rangeScaleFeatures(double[] features, MinMaxScalingStats scalingStats) {
        for (int i = 0; i < features.length; ++i) {
            double numerator = features[i] - scalingStats.minValues[i];
            double denominator = scalingStats.maxValues[i] - scalingStats.minValues[i];
            if (numerator == 0.0 || denominator == 0.0) continue;
            features[i] = numerator / denominator;
        }
    }

    public static void rangeScaleFeatures(InstanceList instances, MinMaxScalingStats scalingStats) {
        instances.forEach(i -> FeatureUtils.rangeScaleFeatures(i, scalingStats));
    }

    public static void rangeScaleFeatures(Instance instance, MinMaxScalingStats scalingStats) {
        FeatureUtils.scaleInstance(instance, scalingStats.minValues, scalingStats.maxValues, scalingStats.lowerBound, scalingStats.upperBound);
    }

    public static double[] centerFeatures(double[][] featureMatrix) {
        double[] means = FeatureUtils.getFeatureMeans(featureMatrix);
        for (int i = 0; i < featureMatrix.length; ++i) {
            double[] features = featureMatrix[i];
            for (int j = 0; j < features.length; ++j) {
                int n = j;
                features[n] = features[n] - means[j];
            }
        }
        return means;
    }

    public static double[] getFeatureMeans(double[][] featureMatrix) {
        int i;
        double[] means = new double[featureMatrix[0].length];
        for (i = 0; i < featureMatrix.length; ++i) {
            double[] features = featureMatrix[i];
            int j = 0;
            while (j < features.length) {
                double featureValue = features[j];
                int n = j++;
                means[n] = means[n] + featureValue;
            }
        }
        i = 0;
        while (i < means.length) {
            int n = i++;
            means[n] = means[n] / (double)featureMatrix.length;
        }
        return means;
    }

    public static double[] centerFeatures(InstanceList instances) {
        double[] means = FeatureUtils.getFeatureMeans(instances);
        for (Instance instance : instances) {
            cc.mallet.types.FeatureVector fv = (cc.mallet.types.FeatureVector)instance.getData();
            for (int j = 0; j < fv.numLocations(); ++j) {
                int index = fv.getIndices()[j];
                fv.setValue(index, fv.getValues()[j] - means[index]);
            }
        }
        return means;
    }

    public static void centerFeatures(Instance instance, double[] featureMeans) {
        cc.mallet.types.FeatureVector fv = (cc.mallet.types.FeatureVector)instance.getData();
        for (int j = 0; j < fv.numLocations(); ++j) {
            int index = fv.getIndices()[j];
            fv.setValue(index, fv.getValues()[j] - featureMeans[index]);
        }
    }

    public static double[] getFeatureMeans(InstanceList instances) {
        int numFeatures = ((Instance)instances.get(0)).getDataAlphabet().size();
        double[] means = new double[numFeatures];
        for (Instance instance : instances) {
            cc.mallet.types.FeatureVector fv = (cc.mallet.types.FeatureVector)instance.getData();
            for (int j = 0; j < fv.numLocations(); ++j) {
                int index = fv.getIndices()[j];
                double featureValue = fv.isBinary() ? 1.0 : fv.getValues()[j];
                int n = index;
                means[n] = means[n] + featureValue;
            }
        }
        int i = 0;
        while (i < means.length) {
            int n = i++;
            means[n] = means[n] / (double)numFeatures;
        }
        return means;
    }

    public static void centerFeatures(double[] features, double[] featureMeans) {
        for (int i = 0; i < features.length; ++i) {
            int n = i;
            features[n] = features[n] - featureMeans[i];
        }
    }

    public static void centerFeatures(svm_node[] features, double[] featureMeans) {
        for (int i = 0; i < features.length; ++i) {
            features[i].value -= featureMeans[features[i].index];
        }
    }

    public static StandardizationStats standardizeFeatures(double[][] featureMatrix) {
        double[] means = FeatureUtils.getFeatureMeans(featureMatrix);
        double[] stdDevs = FeatureUtils.getFeatureStdDeviations(featureMatrix, means);
        for (int i = 0; i < featureMatrix.length; ++i) {
            double[] features = featureMatrix[i];
            for (int j = 0; j < features.length; ++j) {
                int n = j;
                features[n] = features[n] - means[j];
                int n2 = j;
                features[n2] = features[n2] / stdDevs[j];
                if (!Double.isNaN(features[j])) continue;
                features[j] = 0.0;
            }
        }
        return new StandardizationStats(means, stdDevs);
    }

    public static double[] getFeatureStdDeviations(double[][] featureMatrix, double[] means) {
        int i;
        double[] stdDevs = new double[featureMatrix[0].length];
        for (i = 0; i < featureMatrix.length; ++i) {
            double[] features = featureMatrix[i];
            for (int j = 0; j < features.length; ++j) {
                double featureValue = features[j];
                int n = j;
                stdDevs[n] = stdDevs[n] + Math.pow(featureValue - means[j], 2.0);
            }
        }
        for (i = 0; i < stdDevs.length; ++i) {
            int n = i;
            stdDevs[n] = stdDevs[n] / (double)featureMatrix.length;
            stdDevs[i] = Math.sqrt(stdDevs[i]);
        }
        return stdDevs;
    }

    public static StandardizationStats standardizeFeatures(InstanceList instances) {
        double[] means = FeatureUtils.getFeatureMeans(instances);
        double[] stdDevs = FeatureUtils.getFeatureStdDeviations(instances, means);
        for (Instance instance : instances) {
            FeatureUtils.standardizeFeatures(instance, means, stdDevs);
        }
        return new StandardizationStats(means, stdDevs);
    }

    public static double[] getFeatureStdDeviations(InstanceList instances, double[] means) {
        int numFeatures = ((Instance)instances.get(0)).getDataAlphabet().size();
        double[] stdDevs = new double[numFeatures];
        for (Instance instance : instances) {
            cc.mallet.types.FeatureVector fv = (cc.mallet.types.FeatureVector)instance.getData();
            assert (!fv.isBinary()) : "The feature vector of type " + fv.getClass().getCanonicalName() + " is binary which is not allowed for this algorithm";
            for (int j = 0; j < fv.numLocations(); ++j) {
                int index = fv.getIndices()[j];
                double featureValue = fv.isBinary() ? 1.0 : fv.getValues()[j];
                int n = index;
                stdDevs[n] = stdDevs[n] + Math.pow(featureValue - means[index], 2.0);
            }
        }
        for (int i = 0; i < means.length; ++i) {
            int n = i;
            stdDevs[n] = stdDevs[n] / (double)numFeatures;
            stdDevs[i] = Math.sqrt(stdDevs[i]);
        }
        return stdDevs;
    }

    public static void standardizeFeatures(double[] features, double[] featureMeans, double[] featureStdDeviations) {
        if (features.length != featureMeans.length) {
            throw new IllegalArgumentException("Feature dimension differs from the number of feature means. This means that the wrong model is being used for prediction. Feature dimension: " + features.length + ", number of feature means: " + featureMeans.length);
        }
        for (int i = 0; i < features.length; ++i) {
            int n = i;
            features[n] = features[n] - featureMeans[i];
            int n2 = i;
            features[n2] = features[n2] / featureStdDeviations[i];
            if (!Double.isNaN(features[i])) continue;
            features[i] = 0.0;
        }
    }

    public static void standardizeFeatures(InstanceList instances, double[] featureMeans, double[] featureStdDeviations) {
        instances.forEach(i -> FeatureUtils.standardizeFeatures(i, featureMeans, featureStdDeviations));
    }

    public static void standardizeFeatures(InstanceList instances, StandardizationStats standardizationStats) {
        instances.forEach(i -> FeatureUtils.standardizeFeatures(i, standardizationStats));
    }

    public static void standardizeFeatures(Instance instance, StandardizationStats standardizationStats) {
        FeatureUtils.standardizeFeatures(instance, standardizationStats.means, standardizationStats.stdDeviations);
    }

    public static void standardizeFeatures(Instance instance, double[] featureMeans, double[] featureStdDeviations) {
        assert (!instance.hasProperty("standardized") || !((Boolean)instance.getProperty("standardized")).booleanValue()) : "This instance's feature vector has already been standardized.";
        assert (instance.getData() instanceof cc.mallet.types.FeatureVector) : "The instance data is not a FeatureVector but of class " + instance.getData().getClass().getCanonicalName();
        cc.mallet.types.FeatureVector fv = (cc.mallet.types.FeatureVector)instance.getData();
        int i = fv.numLocations();
        int[] indices = fv.getIndices();
        if (indices != null && indices.length == 0) {
            return;
        }
        int maxIndex = indices != null ? indices[indices.length - 1] : i;
        double[] values = new double[maxIndex];
        int[] newIndices = new int[maxIndex];
        int pos = 0;
        for (int index = 0; index < maxIndex; ++index) {
            double mean = featureMeans[index];
            double val = fv.value(index) - mean;
            double stdDev = featureStdDeviations[index];
            if (val != 0.0 && stdDev != 0.0) {
                val /= stdDev;
            }
            if (val == 0.0) continue;
            values[pos] = val;
            newIndices[pos] = index;
            ++pos;
        }
        if (pos != maxIndex) {
            double[] finalValues = new double[pos];
            int[] finalIndices = new int[pos];
            System.arraycopy(values, 0, finalValues, 0, pos);
            System.arraycopy(newIndices, 0, finalIndices, 0, pos);
            values = finalValues;
            newIndices = finalIndices;
        }
        cc.mallet.types.FeatureVector newVector = new cc.mallet.types.FeatureVector(fv.getAlphabet(), newIndices, values);
        boolean locked = instance.isLocked();
        instance.unLock();
        instance.setData(newVector);
        if (locked) {
            instance.lock();
        }
        instance.setProperty("standardized", true);
    }

    public static SVMTrainData removeDuplicates(SVMTrainData data) {
        double[][] featureMatrix = data.featureMatrix;
        LinkedHashSet<FeatureVector> uniqueFeatureVectors = new LinkedHashSet<FeatureVector>(featureMatrix.length);
        for (int i = 0; i < featureMatrix.length; ++i) {
            double[] features = featureMatrix[i];
            uniqueFeatureVectors.add(new FeatureVector(features, i));
        }
        double[][] uniqueFeatureMatrix = new double[uniqueFeatureVectors.size()][];
        double[] uniqueFeatureVectorLabels = new double[uniqueFeatureVectors.size()];
        GeneMention[] uniqueFeatureVectorGenes = new GeneMention[uniqueFeatureVectors.size()];
        int i = 0;
        for (FeatureVector featureVector : uniqueFeatureVectors) {
            uniqueFeatureMatrix[i] = featureMatrix[featureVector.index];
            uniqueFeatureVectorLabels[i] = data.labels[featureVector.index];
            uniqueFeatureVectorGenes[i] = data.geneList.get(featureVector.index);
            ++i;
        }
        SVMTrainData uniqueData = new SVMTrainData(uniqueFeatureVectorLabels, uniqueFeatureMatrix);
        uniqueData.geneList = Arrays.asList(uniqueFeatureVectorGenes);
        return uniqueData;
    }

    private static class FeatureVector {
        double[] features;
        private final int index;

        public FeatureVector(double[] features, int index) {
            this.features = features;
            this.index = index;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.features);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FeatureVector other = (FeatureVector)obj;
            return Arrays.equals(this.features, other.features);
        }
    }
}

