/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase.candidateretrieval;

import de.julielab.geneexpbase.GeneExpRuntimeException;
import de.julielab.geneexpbase.genemodel.GeneName;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class SynHit
implements Comparable<SynHit>,
Cloneable,
Serializable {
    public static final String TYPE_GEPRO = "Gene/Protein";
    public static final String TYPE_GROUP = "Group";
    int random;
    private String synonym;
    private float luceneScore;
    private double lexicalScore;
    private double contextualScore;
    private double overallScore;
    private float relevanceScore;
    private boolean isExactMatch;
    private Map<String, Double> speciesMentionScores = new HashMap<String, Double>();
    private List<String> ids;
    private Set<String> idsSet;
    @Deprecated
    private String[] taxonomySpecificIds;
    private String id;
    private String source;
    private String mappedMention;
    private CompareType compareType = CompareType.ID;
    private String entityType;
    private List<String> taxIds;
    private Set<String> taxIdsSet;
    private String taxId;
    private GeneName mappedGeneName;
    private List<Number> synonymPriorities;
    private boolean anchor;
    private String comment;

    public SynHit(String syn, double score, String id, String source) {
        this.synonym = syn;
        this.lexicalScore = score;
        this.ids = Arrays.asList(id);
        this.id = id;
        this.source = source;
    }

    public SynHit(String synonym, double score, List<String> ids, String source, String entityType, List<String> taxIds) {
        this.synonym = synonym;
        this.lexicalScore = score;
        this.ids = ids;
        this.source = source;
        this.entityType = entityType;
        this.taxIds = taxIds;
    }

    public static Comparator<SynHit> getNormalizedExactMatchThenLuceneScoreComparator(String geneName) {
        Comparator<SynHit> comparator = Comparator.comparing(sh -> sh.getSynonym().equals(geneName));
        comparator = comparator.thenComparingDouble(sh -> sh.getLuceneScore()).reversed();
        return comparator;
    }

    public float getRelevanceScore() {
        return this.relevanceScore;
    }

    public void setRelevanceScore(float relevanceScore) {
        this.relevanceScore = relevanceScore;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public Map<String, Double> getSpeciesMentionScores() {
        return this.speciesMentionScores;
    }

    public Double getSpeciesMentionScore(String taxId) {
        return this.speciesMentionScores.get(taxId);
    }

    public void setSpeciesMentionScore(String taxId, double speciesMentionScore) {
        this.speciesMentionScores.put(taxId, speciesMentionScore);
    }

    public void restrictToTaxId(String taxId) {
        this.id = null;
        this.taxId = null;
        for (int i = 0; i < this.ids.size(); ++i) {
            if (!this.taxIds.get(i).equals(taxId)) continue;
            this.id = this.ids.get(i);
            this.taxId = taxId;
        }
        if (this.id == null) {
            throw new IllegalArgumentException("This SynHit does not contain taxonomy ID " + taxId + ": " + this);
        }
    }

    public double getLexicalScore() {
        return this.lexicalScore;
    }

    public void setLexicalScore(double score) {
        this.lexicalScore = score;
    }

    public double getContextualScore() {
        return this.contextualScore;
    }

    public void setContextualScore(double score) {
        this.contextualScore = score;
    }

    public String getSynonym() {
        return this.synonym;
    }

    public void setSynonym(String syn) {
        this.synonym = syn;
    }

    public String toString() {
        String result = "syn=" + this.synonym + "\tid=" + this.getId() + "\tscore=" + this.lexicalScore + "\tsemScore=" + this.contextualScore + "\tid=" + this.id + "\ttaxId=" + this.taxId;
        return result;
    }

    @Override
    public int compareTo(SynHit o) {
        int c = 0;
        if (this.compareType != o.compareType) {
            throw new IllegalStateException("Two SynHits are compared that don't use the same comparison type: " + this + ", " + o);
        }
        switch (this.compareType) {
            case RANDOM: {
                c = Integer.compare(o.random, this.random);
                break;
            }
            case SCORE: {
                c = Double.compare(o.lexicalScore, this.lexicalScore);
                break;
            }
            case SEMSCORE: {
                c = Double.compare(o.contextualScore, this.contextualScore);
                break;
            }
            case ID: {
                if (o.id == null || this.id == null) {
                    throw new IllegalStateException("Trying to compare SynHits by ID where the id is null.");
                }
                c = o.id.compareTo(this.id);
            }
        }
        return c;
    }

    public boolean equals(Object other) {
        boolean c;
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SynHit o = (SynHit)other;
        switch (this.compareType) {
            case RANDOM: {
                c = o.random == this.random;
                break;
            }
            case SCORE: {
                c = o.lexicalScore == this.lexicalScore;
                break;
            }
            case SEMSCORE: {
                c = o.contextualScore == this.contextualScore;
                break;
            }
            case ID: {
                if (o.id == null || this.id == null) {
                    throw new IllegalStateException("Trying to compare SynHits by ID where the id is null.");
                }
                c = o.id.equals(this.id);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + this.compareType);
            }
        }
        return c;
    }

    public int hashCode() {
        int c;
        switch (this.compareType) {
            case RANDOM: {
                c = Objects.hashCode(this.random);
                break;
            }
            case SCORE: {
                c = Objects.hashCode(this.lexicalScore);
                break;
            }
            case SEMSCORE: {
                c = Objects.hashCode(this.contextualScore);
                break;
            }
            case ID: {
                c = Objects.hashCode(this.id);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + this.compareType);
            }
        }
        return c;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public CompareType getCompareType() {
        return this.compareType;
    }

    public void setCompareType(CompareType type) {
        this.compareType = type;
    }

    public String getMappedMention() {
        return this.mappedMention;
    }

    public void setMappedMention(String mappedSynonym) {
        this.mappedMention = mappedSynonym;
    }

    public boolean isExactMatch() {
        return this.isExactMatch;
    }

    public void setExactMatch(boolean exactMatch) {
        this.isExactMatch = exactMatch;
    }

    public SynHit clone() {
        try {
            SynHit h2 = (SynHit)super.clone();
            h2.speciesMentionScores = new HashMap<String, Double>(this.speciesMentionScores);
            h2.ids = new ArrayList<String>(this.ids);
            if (this.taxIds != null) {
                h2.taxIds = new ArrayList<String>(this.taxIds);
            }
            if (this.synonymPriorities != null) {
                h2.synonymPriorities = new ArrayList<Number>(this.synonymPriorities);
            }
            return h2;
        }
        catch (CloneNotSupportedException e) {
            throw new GeneExpRuntimeException(e);
        }
    }

    public List<String> getIds() {
        return this.ids;
    }

    public void setIds(List<String> ids) {
        this.ids = ids;
        if (this.ids.size() == 1) {
            this.id = ids.get(0);
        } else if (this.ids.size() > 1) {
            this.id = null;
        }
        this.idsSet = null;
    }

    public Set<String> getIdsSet() {
        if (this.idsSet == null) {
            this.idsSet = new HashSet<String>(this.ids);
        }
        return this.idsSet;
    }

    public boolean isDisambiguated() {
        return this.id != null || this.ids.size() <= 1;
    }

    public boolean isAmbiguousInGeneral() {
        return this.ids.size() > 1;
    }

    public boolean isIntraSpeciesAmbiguousInGeneral() {
        HashSet<String> seenTaxIds = new HashSet<String>();
        boolean currentTaxIdWasNotYetSeen = false;
        for (int i = 0; i < this.taxIds.size() && (currentTaxIdWasNotYetSeen = seenTaxIds.add(this.taxIds.get(i))); ++i) {
        }
        return !currentTaxIdWasNotYetSeen;
    }

    public boolean isInterSpeciesAmbiguousInGeneral() {
        if (this.taxIds.size() <= 1) {
            return false;
        }
        HashSet<String> seenTaxIds = new HashSet<String>();
        seenTaxIds.add(this.taxIds.get(0));
        boolean currentTaxIdWasNotYetSeen = false;
        for (int i = 1; i < this.taxIds.size() && !(currentTaxIdWasNotYetSeen = seenTaxIds.add(this.taxIds.get(i))); ++i) {
        }
        return currentTaxIdWasNotYetSeen;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
        int idIndex = this.ids.indexOf(id);
        if (this.ids != null && this.taxIds != null && this.synonymPriorities != null && this.ids.size() == this.taxIds.size() && this.ids.size() == this.synonymPriorities.size()) {
            this.setIds(List.of(this.ids.get(idIndex)));
            this.setTaxIds(List.of(this.taxIds.get(idIndex)));
            this.setSynonymPriorities(List.of(this.synonymPriorities.get(idIndex)));
        }
    }

    public String getTaxIdForGeneId(String id) {
        int i = this.ids.indexOf(id);
        assert (i >= 0) : "Trying to set an ID to a SynHit that does not have this ID as a possibility.";
        return this.taxIds.get(i);
    }

    public List<String> getTaxIds() {
        return this.taxIds;
    }

    public void setTaxIds(List<String> taxIds) {
        assert (taxIds != null && !taxIds.isEmpty()) : "Trying to set an empty taxonomy ID list to a SynHit.";
        this.taxIds = taxIds;
        if (this.taxIds.size() == 1) {
            this.taxId = this.taxIds.get(0);
        } else if (this.taxIds.size() > 1) {
            this.taxId = null;
        }
    }

    public double getOverallScore() {
        return this.overallScore;
    }

    public void setOverallScore(double overallScore) {
        this.overallScore = overallScore;
    }

    public GeneName getMappedGeneName() {
        return this.mappedGeneName;
    }

    public void setMappedGeneName(GeneName mappedGeneName) {
        this.mappedGeneName = mappedGeneName;
    }

    public String getTaxId() {
        return this.taxId;
    }

    public void setTaxId(String taxId) {
        this.taxId = taxId;
    }

    @Deprecated
    public String[] getTaxonomySpecificIds() {
        return this.taxonomySpecificIds;
    }

    public List<Number> getPrioritiesOfIds(String[] idArray) {
        return this.getPrioritiesOfIds(Stream.of(idArray));
    }

    public List<Number> getPrioritiesOfIds(Stream<String> idStream) {
        Set idSet = idStream.collect(Collectors.toSet());
        return IntStream.range(0, this.ids.size()).filter(i -> idSet.contains(this.ids.get(i))).mapToObj(this.synonymPriorities::get).collect(Collectors.toList());
    }

    public boolean hasTaxId(String taxId) {
        return this.taxIds.indexOf(taxId) != -1;
    }

    public List<Number> getSynonymPriorities() {
        return this.synonymPriorities;
    }

    public void setSynonymPriorities(List<Number> synonymPriorities) {
        this.synonymPriorities = synonymPriorities;
    }

    public int getSynonymPriority() {
        return this.synonymPriorities.get(0).intValue();
    }

    public Stream<String> getGeneIdsOfTaxId(String taxId) {
        if (this.taxIds != null) {
            return IntStream.range(0, this.taxIds.size()).filter(i -> this.taxIds.get(i).equals(taxId)).mapToObj(this.ids::get);
        }
        return Stream.empty();
    }

    public Set<String> getTaxIdsSet() {
        if (this.taxIdsSet == null) {
            this.taxIdsSet = new HashSet<String>(this.taxIds);
        }
        return this.taxIdsSet;
    }

    public float getLuceneScore() {
        return this.luceneScore;
    }

    public void setLuceneScore(float luceneScore) {
        this.luceneScore = luceneScore;
    }

    public boolean isAnchor() {
        return this.anchor;
    }

    public void setAnchor(boolean isAnchor) {
        this.anchor = isAnchor;
    }

    public boolean isFamilyName() {
        return this.id != null && this.id.startsWith("GENO:");
    }

    public boolean isRejectionCandidate() {
        return false;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void removeEntriesWithPriority(Set<Integer> priorityToRemove) {
        int[] indicesToKeep = IntStream.range(0, this.synonymPriorities.size()).filter(i -> !priorityToRemove.contains(this.synonymPriorities.get(i))).toArray();
        if (indicesToKeep.length > 0) {
            this.setIds(IntStream.of(indicesToKeep).mapToObj(i -> this.ids.get(i)).collect(Collectors.toList()));
            this.setTaxIds(IntStream.of(indicesToKeep).mapToObj(i -> this.taxIds.get(i)).collect(Collectors.toList()));
            this.setSynonymPriorities(IntStream.of(indicesToKeep).mapToObj(i -> this.synonymPriorities.get(i)).collect(Collectors.toList()));
        }
    }

    public void removeAllEntriesButWithPriority(int priorityToKeep) {
        int[] indicesToKeep = IntStream.range(0, this.synonymPriorities.size()).filter(i -> this.synonymPriorities.get(i).equals(priorityToKeep)).toArray();
        if (indicesToKeep.length > 0) {
            this.setIds(IntStream.of(indicesToKeep).mapToObj(i -> this.ids.get(i)).collect(Collectors.toList()));
            this.setTaxIds(IntStream.of(indicesToKeep).mapToObj(i -> this.taxIds.get(i)).collect(Collectors.toList()));
            this.setSynonymPriorities(IntStream.of(indicesToKeep).mapToObj(i -> this.synonymPriorities.get(i)).collect(Collectors.toList()));
        }
    }

    public static enum CompareType {
        RANDOM,
        SCORE,
        SEMSCORE,
        ID;

    }
}

