/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase.candidateretrieval;

import com.sun.istack.NotNull;
import de.julielab.geneexpbase.candidateretrieval.QueryGenerator;
import de.julielab.geneexpbase.genemodel.GeneName;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.lucene.search.Query;

public class CandidateCacheKey
implements Serializable,
Comparable<CandidateCacheKey> {
    public static final int DEFAULT_MAX_CANDIDATES = 20;
    private transient GeneName geneName;
    private transient Collection<GeneName> contextNames;
    private transient String taxId;
    private transient Collection<String> geneIdsFilter;
    private transient QueryGenerator queryGenerator;
    private transient int maxHits = 20;
    private transient boolean loadSynHitFields;
    private transient Map<String, Float> fieldWeights;
    private transient String idPrefixFilter;
    private String hashString;
    private String termFilterField;
    private String termFilterTerm;

    public CandidateCacheKey(GeneName geneName) {
        this(geneName, null);
    }

    public CandidateCacheKey(GeneName geneName, String taxId) {
        this.setGeneName(geneName);
        this.setTaxId(taxId);
    }

    public Collection<GeneName> getContextNames() {
        return this.contextNames;
    }

    public void setContextNames(Collection<GeneName> contextNames) {
        this.contextNames = contextNames;
    }

    public String getTermFilterField() {
        return this.termFilterField;
    }

    public String getTermFilterTerm() {
        return this.termFilterTerm;
    }

    public String getHashString() {
        if (this.hashString == null) {
            String data = (this.getGeneName() != null ? this.getGeneName().toString() : null) + this.getTaxId() + this.getGeneIdsFilter() + (this.getQueryGenerator() != null ? this.getQueryGenerator().getName() : null) + this.getMaxHits() + this.isLoadSynHitFields() + this.getFieldWeights() + this.getIdPrefixFilter() + (this.contextNames != null ? this.contextNames.toString() : null) + this.termFilterField + this.termFilterTerm;
            this.hashString = DigestUtils.md5Hex(data);
        }
        return this.hashString;
    }

    @Override
    public int compareTo(@NotNull CandidateCacheKey o) {
        return this.getHashString().compareTo(o.getHashString());
    }

    public String toString() {
        return "CandidateCacheKey{geneName=" + this.getGeneName() + ", taxId='" + this.getTaxId() + "', geneIdsFilter=" + this.getGeneIdsFilter() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CandidateCacheKey that = (CandidateCacheKey)o;
        return this.getHashString().equals(that.getHashString());
    }

    public int hashCode() {
        return Objects.hash(this.getHashString());
    }

    public Query generateQuery() {
        if (this.getQueryGenerator() == null) {
            throw new NullPointerException("The queryGenerator is null.");
        }
        return this.getQueryGenerator().generateQuery(this);
    }

    public GeneName getGeneName() {
        return this.geneName;
    }

    public void setGeneName(GeneName geneName) {
        this.hashString = null;
        this.geneName = geneName;
    }

    public String getTaxId() {
        return this.taxId;
    }

    public void setTaxId(String taxId) {
        this.hashString = null;
        this.taxId = taxId;
    }

    public Collection<String> getGeneIdsFilter() {
        return this.geneIdsFilter;
    }

    public void setGeneIdsFilter(Collection<String> geneIdsFilter) {
        this.hashString = null;
        this.geneIdsFilter = geneIdsFilter;
    }

    public QueryGenerator getQueryGenerator() {
        return this.queryGenerator;
    }

    public void setQueryGenerator(QueryGenerator queryGenerator) {
        this.hashString = null;
        this.queryGenerator = queryGenerator;
    }

    public int getMaxHits() {
        return this.maxHits;
    }

    public void setMaxHits(int maxHits) {
        this.hashString = null;
        this.maxHits = maxHits;
    }

    public boolean isLoadSynHitFields() {
        return this.loadSynHitFields;
    }

    public void setLoadSynHitFields(boolean loadSynHitFields) {
        this.hashString = null;
        this.loadSynHitFields = loadSynHitFields;
    }

    public Map<String, Float> getFieldWeights() {
        return this.fieldWeights;
    }

    public void setFieldWeights(Map<String, Float> fieldWeights) {
        this.hashString = null;
        this.fieldWeights = fieldWeights;
    }

    public String getIdPrefixFilter() {
        return this.idPrefixFilter;
    }

    public void setIdPrefixFilter(String idPrefixFilter) {
        this.hashString = null;
        this.idPrefixFilter = idPrefixFilter;
    }

    public void setTermFilter(String field, String term) {
        this.hashString = null;
        this.termFilterField = field;
        this.termFilterTerm = term;
    }
}

