/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase;

import com.google.common.collect.Sets;
import de.julielab.geneexpbase.candidateretrieval.CandidateRetrieval;
import de.julielab.geneexpbase.candidateretrieval.QueryGenerator;
import de.julielab.geneexpbase.candidateretrieval.SynHit;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.scoring.Scorer;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class GeneIdCorrectness {
    public static GeneDocument.MentionCorrectness getIdCorrectnessLevel(GeneMention gm, String idType, @Nullable CandidateRetrieval candidateRetrieval, @Nullable QueryGenerator queryGenerator, @Nullable Scorer docLevelCandidateScorer, @Nullable Double docLevelCandidateScoreThreshold) {
        Supplier<Set> predictedIdSupplier;
        Supplier<Set> goldIdSupplier;
        if (idType.equals("gene")) {
            goldIdSupplier = gm::getAllGoldIdAsSet;
            predictedIdSupplier = () -> gm.getResultCandidates().map(SynHit::getId).collect(Collectors.toSet());
        } else if (idType.equals("taxonomy")) {
            goldIdSupplier = gm::getAllGoldTaxonomyIdsAsSet;
            predictedIdSupplier = gm::getTaxonomyIdsSet;
        } else {
            goldIdSupplier = () -> Set.of(gm.hasGoldMentions() ? "false" : "true");
            predictedIdSupplier = () -> Set.of(gm.isRejected() ? "true" : "false");
        }
        boolean goldHasOffsets = gm.getGeneDocument().isGoldHasOffsets();
        if (goldHasOffsets) {
            if (!gm.hasGoldMentions()) {
                return gm.isRejected() ? GeneDocument.MentionCorrectness.CORRECT_ID : GeneDocument.MentionCorrectness.CANT_FIND;
            }
            if (gm.isRejected()) {
                return GeneDocument.MentionCorrectness.WRONG_ID;
            }
            Set goldIdSet = goldIdSupplier.get();
            Set predictedIdSet = predictedIdSupplier.get();
            assert (goldIdSet != null && !goldIdSet.isEmpty()) : "It seems that the " + idType + " IDs of the gold gene mentions are not set.";
            return Sets.intersection(goldIdSet, predictedIdSet).isEmpty() ? GeneDocument.MentionCorrectness.WRONG_ID : GeneDocument.MentionCorrectness.CORRECT_ID;
        }
        Supplier<Set> documentLevelGoldIds = idType.equals("gene") ? gm.getGeneDocument()::getGoldIds : gm.getGeneDocument()::getGoldTaxonomyIds;
        boolean noCorrectIdFound = Sets.intersection(documentLevelGoldIds.get(), predictedIdSupplier.get()).isEmpty();
        if (idType.equals("taxonomy") && noCorrectIdFound) {
            List<SynHit> candidates = candidateRetrieval.getCandidates(gm, gm.getGeneDocument().getGoldIds(), queryGenerator);
            boolean candidateWithGoldTaxFound = candidates.stream().anyMatch(sh -> docLevelCandidateScorer.getScore(gm.getNormalizedText(), sh.getSynonym()) > docLevelCandidateScoreThreshold);
            return candidateWithGoldTaxFound ? GeneDocument.MentionCorrectness.WRONG_ID : GeneDocument.MentionCorrectness.CANT_FIND;
        }
        if (noCorrectIdFound && !gm.isRejected()) {
            return GeneDocument.MentionCorrectness.CANT_FIND;
        }
        return GeneDocument.MentionCorrectness.CORRECT_ID;
    }
}

