/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase;

import com.lahodiuk.ahocorasick.AhoCorasickOptimized;
import java.util.TreeMap;
import org.apache.commons.lang3.Range;

public class AhoCorasickLongestMatchCallback
implements AhoCorasickOptimized.MatchCallback {
    private final TreeMap<Range<Integer>, String> longestMatches = new TreeMap((r1, r2) -> {
        if (r1.isOverlappedBy(r2)) {
            return 0;
        }
        return (Integer)r1.getMinimum() < (Integer)r2.getMinimum() ? -1 : 1;
    });

    @Override
    public void onMatch(int startPosition, int endPosition, String matched) {
        Range<Integer> range = Range.between(startPosition, endPosition);
        Range<Integer> floor = this.longestMatches.floorKey(range);
        if (floor != null && floor.isOverlappedBy(range)) {
            if (range.getMaximum() - range.getMinimum() > floor.getMaximum() - floor.getMinimum()) {
                this.longestMatches.remove(floor);
                this.longestMatches.put(range, matched);
            }
        } else {
            this.longestMatches.put(range, matched);
        }
    }

    public TreeMap<Range<Integer>, String> getLongestMatches() {
        return this.longestMatches;
    }

    public void clear() {
        this.longestMatches.clear();
    }
}

