/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.gene.candidateretrieval;

import de.julielab.geneexpbase.GeneExpRuntimeException;
import de.julielab.geneexpbase.candidateretrieval.CandidateCacheKey;
import de.julielab.geneexpbase.candidateretrieval.QueryGenerator;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.stream.Stream;
import org.apache.lucene.analysis.custom.CustomAnalyzer;
import org.apache.lucene.analysis.ngram.NGramFilterFactory;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.QueryBuilder;

public class NGramQueryGenerator
extends QueryGenerator {
    private transient CustomAnalyzer ngramAnalyzer;
    private final int min;
    private final int max;

    public NGramQueryGenerator(int min2, int max) {
        this.min = min2;
        this.max = max;
        this.ngramAnalyzer = this.init();
    }

    public CustomAnalyzer init() {
        CustomAnalyzer ngramAnalyzer;
        try {
            HashMap<String, String> ngramFilterSettings = new HashMap<String, String>();
            ngramFilterSettings.put("minGramSize", String.valueOf(this.min));
            ngramFilterSettings.put("maxGramSize", String.valueOf(this.max));
            ngramAnalyzer = CustomAnalyzer.builder().withTokenizer("whitespace", new String[0]).addTokenFilter(NGramFilterFactory.class, ngramFilterSettings).build();
        }
        catch (IOException e) {
            throw new GeneExpRuntimeException(e);
        }
        return ngramAnalyzer;
    }

    @Override
    public Query generateQuery(CandidateCacheKey key) {
        if (this.ngramAnalyzer == null) {
            this.ngramAnalyzer = this.init();
        }
        String synonymsString = key.getGeneName().getText();
        Collection<String> geneIds = key.getGeneIdsFilter();
        QueryBuilder qb = new QueryBuilder(this.ngramAnalyzer);
        Query ngramQuery = qb.createBooleanQuery("indexed_syn_ngrams", synonymsString);
        BooleanQuery.Builder mainQb = new BooleanQuery.Builder().add(ngramQuery, BooleanClause.Occur.MUST);
        if (geneIds != null && !geneIds.isEmpty()) {
            Stream<TermQuery> idTermQueries = geneIds.stream().map(id -> new TermQuery(new Term("entry_id", (String)id)));
            BooleanQuery.Builder filterBuilder = new BooleanQuery.Builder();
            idTermQueries.forEach(q -> filterBuilder.add((Query)q, BooleanClause.Occur.SHOULD));
            mainQb.add(filterBuilder.build(), BooleanClause.Occur.FILTER);
        }
        return mainQb.build();
    }

    @Override
    public String getName() {
        return "NGrams";
    }
}

