/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.gene.candidateretrieval;

import de.julielab.gene.candidateretrieval.GeneRecordHit;
import de.julielab.geneexpbase.candidateretrieval.CandidateCacheKey;
import de.julielab.geneexpbase.candidateretrieval.QueryGenerator;
import de.julielab.geneexpbase.genemodel.GeneName;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class GeneRecordSynonymsQueryGenerator
extends QueryGenerator {
    public static final String[] ALL_FIELDS;
    public static final List<Function<GeneRecordHit, String[]>> ALL_FIELD_FUNCTIONS;
    private final boolean exact;
    private final String[] fieldsToSearch;
    private final BooleanClause.Occur tokenOccur;

    public GeneRecordSynonymsQueryGenerator(boolean exact) {
        this(exact, ALL_FIELDS);
    }

    public GeneRecordSynonymsQueryGenerator(boolean exact, String[] fieldsToSearch) {
        this(exact, fieldsToSearch, BooleanClause.Occur.MUST);
    }

    public GeneRecordSynonymsQueryGenerator(boolean exact, String[] fieldsToSearch, BooleanClause.Occur tokenOccur) {
        this.exact = exact;
        this.fieldsToSearch = fieldsToSearch;
        this.tokenOccur = tokenOccur;
    }

    @Override
    public Query generateQuery(CandidateCacheKey key) throws BooleanQuery.TooManyClauses {
        String[] stringArray;
        Map<String, Float> fieldWeights = key.getFieldWeights();
        GeneName geneName = key.getGeneName();
        BooleanQuery.Builder mainQb = new BooleanQuery.Builder();
        String normalizedGeneName = geneName.getNormalizedText();
        if (this.exact) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = normalizedGeneName;
        } else {
            stringArray = normalizedGeneName.split("\\s+");
        }
        String[] tokensToSearch = stringArray;
        BooleanQuery.Builder searchQuery = new BooleanQuery.Builder();
        for (String token : tokensToSearch) {
            BooleanQuery.Builder fieldsDisjunctionBuilder = new BooleanQuery.Builder();
            Stream<Query> termQueryStream = Arrays.stream(this.fieldsToSearch).map(field -> new Term(field + (this.exact ? "_exact" : ""), token)).map(TermQuery::new);
            if (fieldWeights != null) {
                termQueryStream = termQueryStream.map(TermQuery.class::cast).map(tq -> {
                    float weight = fieldWeights.getOrDefault(tq.getTerm().field(), Float.valueOf(1.0f)).floatValue();
                    return new BoostQuery((Query)tq, weight);
                });
            }
            termQueryStream.forEach(tq -> fieldsDisjunctionBuilder.add((Query)tq, BooleanClause.Occur.SHOULD));
            searchQuery.add(fieldsDisjunctionBuilder.build(), this.tokenOccur);
        }
        mainQb.add(searchQuery.build(), BooleanClause.Occur.MUST);
        if (key.getGeneIdsFilter() != null && !key.getGeneIdsFilter().isEmpty()) {
            BooleanQuery.Builder filterBuilder = new BooleanQuery.Builder();
            key.getGeneIdsFilter().stream().map(id -> new Term("entry_id", (String)id)).map(TermQuery::new).forEach(tq -> filterBuilder.add((Query)tq, BooleanClause.Occur.SHOULD));
            mainQb.add(filterBuilder.build(), BooleanClause.Occur.FILTER);
        }
        if (!StringUtils.isBlank(key.getTaxId())) {
            mainQb.add(new TermQuery(new Term("tax_id", key.getTaxId())), BooleanClause.Occur.FILTER);
        }
        return mainQb.build();
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName() + Arrays.toString(this.fieldsToSearch) + "-" + this.exact;
    }

    private static /* synthetic */ String[] lambda$static$8(GeneRecordHit h2) {
        return h2.getBioThesaurusNames();
    }

    private static /* synthetic */ String[] lambda$static$7(GeneRecordHit h2) {
        return h2.getUniprotNames();
    }

    private static /* synthetic */ String[] lambda$static$6(GeneRecordHit h2) {
        return new String[]{h2.getMapLocation()};
    }

    private static /* synthetic */ String[] lambda$static$5(GeneRecordHit h2) {
        return new String[]{h2.getChromosome()};
    }

    private static /* synthetic */ String[] lambda$static$4(GeneRecordHit h2) {
        return h2.getOtherDesignations();
    }

    private static /* synthetic */ String[] lambda$static$3(GeneRecordHit h2) {
        return h2.getFullNames();
    }

    private static /* synthetic */ String[] lambda$static$2(GeneRecordHit h2) {
        return h2.getSynonyms();
    }

    private static /* synthetic */ String[] lambda$static$1(GeneRecordHit h2) {
        return new String[]{h2.getSymbolFromNomenclature()};
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.applyExpressionRewriter(NewAnonymousArray.java:112)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

