/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.gene.candidateretrieval;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class GeneNameQueries {
    public static Query makeBooleanQuery(String searchString, String field, BooleanClause.Occur occur, int numAllowedNotToMatch) throws BooleanQuery.TooManyClauses {
        if (searchString == null) {
            return null;
        }
        String[] tokens = searchString.split(" ");
        BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
        if (occur == BooleanClause.Occur.SHOULD && numAllowedNotToMatch >= 0) {
            booleanQuery.setMinimumNumberShouldMatch(Math.max(1, tokens.length - numAllowedNotToMatch));
        }
        for (int i = 0; i < tokens.length; ++i) {
            Term term = new Term(field, tokens[i]);
            TermQuery q = new TermQuery(term);
            booleanQuery.add(q, occur);
        }
        return booleanQuery.build();
    }
}

