/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.evaluation.entities;

import de.julielab.evaluation.entities.FMeasure;

public class EvaluationStatistics {
    public int fp;
    public int fn;
    public int tp;

    public EvaluationStatistics(int tp, int fp, int fn) {
        this.tp = tp;
        this.fp = fp;
        this.fn = fn;
    }

    public int getFp() {
        return this.fp;
    }

    public int getFn() {
        return this.fn;
    }

    public int getTp() {
        return this.tp;
    }

    public EvaluationStatistics incrementTp(int delta) {
        this.tp += delta;
        return this;
    }

    public EvaluationStatistics incrementFp(int delta) {
        this.fp += delta;
        return this;
    }

    public EvaluationStatistics incrementFn(int delta) {
        this.fn += delta;
        return this;
    }

    public EvaluationStatistics incrementStats(int tpDelta, int fpDelta, int fnDelta) {
        this.incrementTp(tpDelta);
        this.incrementFp(fpDelta);
        this.incrementFn(fnDelta);
        return this;
    }

    public double getFMeasure() {
        return FMeasure.getFMeasure(this.tp, this.fp, this.fn);
    }

    public double getRecall() {
        return FMeasure.getRecall(this.tp, this.fp, this.fn);
    }

    public double getPrecision() {
        return FMeasure.getPrecision(this.tp, this.fp, this.fn);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fn;
        result = 31 * result + this.fp;
        result = 31 * result + this.tp;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EvaluationStatistics other = (EvaluationStatistics)obj;
        if (this.fn != other.fn) {
            return false;
        }
        if (this.fp != other.fp) {
            return false;
        }
        return this.tp == other.tp;
    }
}

