/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.evaluation.entities;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import de.julielab.evaluation.entities.EvaluationDataEntry;
import de.julielab.evaluation.entities.FMeasure;
import de.julielab.evaluation.entities.Statistics;

public class EvaluationDataEntrySets {
    public static final EvaluationDataEntrySets EMPTY = new EvaluationDataEntrySets(ImmutableMultiset.of(), ImmutableMultiset.of(), ImmutableMultiset.of());
    public Multiset<EvaluationDataEntry> tpSet;
    public Multiset<EvaluationDataEntry> fpSet;
    public Multiset<EvaluationDataEntry> fnSet;

    public EvaluationDataEntrySets(Multiset<EvaluationDataEntry> tpSet, Multiset<EvaluationDataEntry> fpSet, Multiset<EvaluationDataEntry> fnSet) {
        this.tpSet = tpSet;
        this.fpSet = fpSet;
        this.fnSet = fnSet;
    }

    public Multiset<EvaluationDataEntry> get(Statistics type) {
        switch (type) {
            case TP: {
                return this.tpSet;
            }
            case FP: {
                return this.fpSet;
            }
            case FN: {
                return this.fnSet;
            }
        }
        return null;
    }

    public double getFMeasure() {
        return FMeasure.getFMeasure(this.tpSet.size(), this.fpSet.size(), this.fnSet.size());
    }

    public double getRecall() {
        return FMeasure.getRecall(this.tpSet.size(), this.fpSet.size(), this.fnSet.size());
    }

    public double getPrecision() {
        return FMeasure.getPrecision(this.tpSet.size(), this.fpSet.size(), this.fnSet.size());
    }
}

