/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.evaluation.entities;

import java.util.Comparator;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;

public class EvaluationDataEntry
implements Comparable<EvaluationDataEntry> {
    public static Comparator<EvaluationDataEntry> beginComparator = (o1, o2) -> o1.getBegin() - o2.getBegin();
    private String docId;
    private String entityId;
    private String entityType;
    private String entityString;
    private String recognitionSystem;
    private Range<Integer> offsetRange;
    private ComparisonType comparisonType;
    private OverlapType overlapType;
    private int overlapSize;
    private String confidence;
    private Object referenceObject;

    public EvaluationDataEntry copy() {
        EvaluationDataEntry copy = new EvaluationDataEntry(this.docId, this.entityId, this.getBegin(), this.getEnd(), this.recognitionSystem, this.entityString, this.entityType);
        copy.setComparisonType(this.comparisonType);
        copy.setOverlapType(this.overlapType);
        copy.setOverlapSize(this.overlapSize);
        copy.setConfidence(this.confidence);
        copy.setReferenceObject(this.referenceObject);
        return copy;
    }

    public EvaluationDataEntry(String docId, String entityId) {
        this(docId, entityId, -1, -1);
    }

    public EvaluationDataEntry(String docId, String entityId, int begin, int end) {
        this.docId = docId;
        this.entityId = entityId;
        this.offsetRange = Range.between(begin, end);
        this.comparisonType = ComparisonType.EXACT;
        this.overlapType = OverlapType.PERCENT;
        this.overlapSize = 100;
        this.entityType = "entity";
    }

    public EvaluationDataEntry(String docId, String entityId, int begin, int end, String recognitionSystem) {
        this.docId = docId;
        this.entityId = entityId;
        this.offsetRange = Range.between(begin, end);
        this.comparisonType = ComparisonType.EXACT;
        this.overlapType = OverlapType.PERCENT;
        this.overlapSize = 100;
        this.entityType = "entity";
        this.recognitionSystem = recognitionSystem;
    }

    public EvaluationDataEntry(String docId, String entityId, int begin, int end, String recognitionSystem, String entityString) {
        this.docId = docId;
        this.entityId = entityId;
        this.offsetRange = Range.between(begin, end);
        this.comparisonType = ComparisonType.EXACT;
        this.overlapType = OverlapType.PERCENT;
        this.overlapSize = 100;
        this.entityType = "entity";
        this.recognitionSystem = recognitionSystem;
        this.entityString = entityString;
    }

    public EvaluationDataEntry(String docId, String entityId, int begin, int end, String entityString, String recognitionSystem, String entityType) {
        this(docId, entityId, begin, end);
        this.entityString = entityString;
        this.recognitionSystem = recognitionSystem;
        this.entityType = entityType;
    }

    public EvaluationDataEntry(String docId, String entityId, String entityString, String recognitionSystem) {
        this(docId, entityId, -1, -1);
        this.entityString = entityString;
        this.recognitionSystem = recognitionSystem;
    }

    public EvaluationDataEntry(String docId, String entityId, String entityString, String recognitionSystem, String entityType) {
        this(docId, entityId, -1, -1);
        this.entityString = entityString;
        this.recognitionSystem = recognitionSystem;
        this.entityType = entityType;
    }

    public EvaluationDataEntry() {
        this(null, null, -1, -1);
    }

    @Override
    public int compareTo(EvaluationDataEntry o) {
        boolean equal = this.equals(o);
        if (equal) {
            return 0;
        }
        int ret = this.docId.compareTo(o.getDocId());
        if (ret != 0) {
            return ret;
        }
        ret = this.entityId.compareTo(o.entityId);
        if (ret != 0) {
            return ret;
        }
        if (!this.hasComparableOffset(o)) {
            if (this.getBegin() < o.getBegin()) {
                return -1;
            }
            if (this.getBegin() > o.getBegin()) {
                return 1;
            }
            if (this.getEnd() < o.getEnd()) {
                return -1;
            }
            if (this.getEnd() > o.getEnd()) {
                return 1;
            }
        }
        throw new IllegalArgumentException("Comparison value should already be determined by now.");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EvaluationDataEntry other = (EvaluationDataEntry)obj;
        if (this.docId == null ? other.docId != null : !this.docId.equals(other.docId)) {
            return false;
        }
        if (this.entityId == null ? other.entityId != null : !this.entityId.equals(other.entityId)) {
            return false;
        }
        return this.hasComparableOffset(other);
    }

    public int getBegin() {
        return this.offsetRange.getMinimum();
    }

    public ComparisonType getComparisonType() {
        return this.comparisonType;
    }

    public String getConfidence() {
        return this.confidence;
    }

    public String getDocId() {
        return this.docId;
    }

    public int getEnd() {
        return this.offsetRange.getMaximum();
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getEntityString() {
        return this.entityString;
    }

    public Range<Integer> getOffsetRange() {
        return this.offsetRange;
    }

    public int getOverlapSize() {
        return this.overlapSize;
    }

    public OverlapType getOverlapType() {
        return this.overlapType;
    }

    public String getRecognitionSystem() {
        return this.recognitionSystem;
    }

    public boolean hasComparableOffset(EvaluationDataEntry other) {
        if (this.isMention() && other.isMention()) {
            if (!this.offsetRange.isOverlappedBy(other.offsetRange)) {
                return false;
            }
            if (this.comparisonType == ComparisonType.EXACT) {
                if (!this.offsetRange.equals(other.offsetRange)) {
                    return false;
                }
            } else if (this.comparisonType == ComparisonType.OVERLAP) {
                Range<Integer> intersection = this.offsetRange.intersectionWith(other.offsetRange);
                int intersectionLength = intersection.getMaximum() - intersection.getMinimum();
                if (this.overlapType == OverlapType.CHARS && intersectionLength < this.overlapSize) {
                    return false;
                }
                if (this.overlapType == OverlapType.PERCENT) {
                    int thisMentionLength = this.offsetRange.getMaximum() - this.offsetRange.getMinimum();
                    int otherMentionLength = other.offsetRange.getMaximum() - other.offsetRange.getMinimum();
                    int thisOverlapPercent = (int)Math.ceil((double)intersectionLength / (double)thisMentionLength * 100.0);
                    int otherOverlapPercent = (int)Math.ceil((double)intersectionLength / (double)otherMentionLength * 100.0);
                    if (thisOverlapPercent < this.overlapSize || otherOverlapPercent < this.overlapSize) {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.offsetRange.getMinimum();
        result = 31 * result + (this.docId == null ? 0 : this.docId.hashCode());
        result = 31 * result + this.offsetRange.getMaximum();
        result = 31 * result + (this.entityId == null ? 0 : this.entityId.hashCode());
        return result;
    }

    public boolean isMention() {
        return this.offsetRange.getMinimum() >= 0 && this.offsetRange.getMaximum() >= 0 && this.offsetRange.getMinimum() <= this.offsetRange.getMaximum();
    }

    public boolean overlaps(EvaluationDataEntry other) {
        return this.offsetRange.isOverlappedBy(other.offsetRange);
    }

    public void setBegin(int begin) {
        Integer end = this.offsetRange != null ? this.offsetRange.getMaximum() : begin;
        if (end < begin) {
            end = begin;
        }
        this.offsetRange = Range.between(begin, end);
    }

    public void setComparisonType(ComparisonType comparisonType) {
        this.comparisonType = comparisonType;
    }

    public void setConfidence(String confidence) {
        this.confidence = confidence;
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    public void setEnd(int end) {
        Integer begin = this.offsetRange != null ? this.offsetRange.getMinimum() : end;
        if (begin > end) {
            begin = end;
        }
        this.offsetRange = Range.between(begin, end);
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public void setEntityString(String entityString) {
        this.entityString = entityString;
    }

    public void setOverlapSize(int overlapSize) {
        this.overlapSize = overlapSize;
    }

    public void setOverlapType(OverlapType overlapType) {
        this.overlapType = overlapType;
    }

    public void setRecognitionSystem(String recognitionSystem) {
        this.recognitionSystem = recognitionSystem;
    }

    public EvaluationDataEntry toDocWiseEntry() {
        return this.isMention() ? new EvaluationDataEntry(this.docId, this.entityId, this.entityString, this.recognitionSystem) : this;
    }

    public String toShortString() {
        String entityId = StringUtils.isBlank(this.entityId) ? "0" : this.entityId;
        String ret = this.docId + " " + entityId + " " + this.entityString + " " + this.offsetRange.getMinimum() + "-" + this.offsetRange.getMaximum();
        if (null != this.confidence) {
            ret = ret + "\t(" + this.confidence + ")";
        }
        if (null != this.recognitionSystem) {
            ret = ret + "\t(" + this.recognitionSystem + ")";
        }
        return ret;
    }

    public String toString() {
        return "EvaluationDataEntry [docId=" + this.docId + ", entityId=" + this.entityId + ", begin=" + this.offsetRange.getMinimum() + ", end=" + this.offsetRange.getMaximum() + ", entityString=" + this.entityString + ", recognitionSystem=" + this.recognitionSystem + "]";
    }

    public Object getReferenceObject() {
        return this.referenceObject;
    }

    public void setReferenceObject(Object referenceObject) {
        this.referenceObject = referenceObject;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public static enum OverlapType {
        CHARS,
        PERCENT;

    }

    public static enum ComparisonType {
        EXACT,
        OVERLAP;

    }
}

