/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.evaluation.entities;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import de.julielab.evaluation.entities.EntityEvaluator;
import de.julielab.evaluation.entities.EvaluationDataEntry;
import de.julielab.evaluation.entities.NoOffsetsException;
import de.julielab.evaluation.entities.format.EvaluationDataColumn;
import de.julielab.evaluation.entities.format.EvaluationDataFormat;
import de.julielab.evaluation.entities.format.GeneNormalizationFormat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluationData
extends ArrayList<EvaluationDataEntry> {
    private static final Logger log = LoggerFactory.getLogger(EvaluationData.class);
    public static final String PROP_INPUT_FORMAT_CLASS = "input-format-class";
    public static final EvaluationDataFormat DEFAULT_FORMAT = new GeneNormalizationFormat();
    private static final long serialVersionUID = 7048898609514218622L;
    private boolean isMentionData;
    public static Comparator<EvaluationDataEntry> docIdComparator = new Comparator<EvaluationDataEntry>(){

        @Override
        public int compare(EvaluationDataEntry o1, EvaluationDataEntry o2) {
            return o1.getDocId().compareTo(o2.getDocId());
        }
    };
    public static Comparator<EvaluationDataEntry> offsetComparator = new Comparator<EvaluationDataEntry>(){

        @Override
        public int compare(EvaluationDataEntry o1, EvaluationDataEntry o2) {
            return Integer.compare(o1.getBegin(), o2.getBegin());
        }
    };
    private Multimap<String, EvaluationDataEntry> entriesByDocument;
    private EvaluationDataFormat dataFormat;

    public EvaluationData(EvaluationDataEntry ... entries) {
        this();
        for (EvaluationDataEntry e : entries) {
            this.add(e);
        }
    }

    public EvaluationData() {
        this(DEFAULT_FORMAT);
    }

    public EvaluationData(Properties properties) {
        this(EntityEvaluator.getDataFormatFromConfiguration(properties));
    }

    public EvaluationData(EvaluationDataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    public EvaluationData(List<String[]> records) {
        this(records, DEFAULT_FORMAT);
    }

    public EvaluationData(List<String[]> records, EvaluationDataFormat format) {
        this.dataFormat = format;
        boolean hasOffsets = false;
        if (!records.isEmpty()) {
            this.add(records.get(0), format);
            EvaluationDataEntry lastEntry = (EvaluationDataEntry)this.get(this.size() - 1);
            hasOffsets = lastEntry.isMention();
            if (hasOffsets) {
                log.debug("Got first line \"{}\", treating file as delivered with offsets.", (Object)records.get(0));
            } else {
                log.debug("Got first line \"{}\", treating file as delivered without offsets.", (Object)records.get(0));
            }
        }
        for (int i = 1; i < records.size(); ++i) {
            Object[] record = records.get(i);
            this.add((String[])record, format);
            EvaluationDataEntry lastEntry = (EvaluationDataEntry)this.get(this.size() - 1);
            if (!hasOffsets || lastEntry.isMention()) continue;
            throw new IllegalStateException("Input format error on line " + i + ": Offset information expected, but not both begin and end offsets where found. The input format is <docId> <entityId> [<beginOffset> <endOffset>]. Line was: " + Arrays.toString(record));
        }
    }

    public EvaluationData(String[] ... data) {
        this(DEFAULT_FORMAT, data);
    }

    public EvaluationData(EvaluationDataFormat format, String[] ... data) {
        this.dataFormat = format;
        for (int i = 0; i < data.length; ++i) {
            this.add(data[i], format);
        }
    }

    public EvaluationData(boolean mentionData) {
        this();
        this.isMentionData = mentionData;
    }

    @Override
    public boolean add(EvaluationDataEntry entry) {
        this.checkMentionMode(entry);
        return super.add(entry);
    }

    @Override
    public boolean addAll(Collection<? extends EvaluationDataEntry> c) {
        c.stream().findAny().ifPresent(this::checkMentionMode);
        return super.addAll(c);
    }

    protected void checkMentionMode(EvaluationDataEntry entry) {
        if (this.isEmpty()) {
            this.isMentionData = entry.isMention();
            if (entry.isMention()) {
                log.debug("Got first line \"{}\", treating file as delivered with offsets.", (Object)entry);
            } else {
                log.debug("Got first line \"{}\", treating file as delivered without offsets.", (Object)entry);
            }
        } else if (this.isMentionData && !entry.isMention()) {
            throw new NoOffsetsException("This data set is comprised of entity mentions with offset information. However, the new entry \"" + entry + "\" does not have valid offset information.");
        }
    }

    protected void checkMentionMode() {
        if (this.size() > 0) {
            this.isMentionData = ((EvaluationDataEntry)this.get(0)).isMention();
        }
        for (EvaluationDataEntry entry : this) {
            if (!this.isMentionData || entry.isMention()) continue;
            throw new NoOffsetsException("This data set is comprised of entity mentions with offset information. However, the new entry \"" + entry + "\" does not have valid offset information.");
        }
    }

    public boolean add(String[] dataRecord, EvaluationDataFormat format) {
        EvaluationDataEntry e = new EvaluationDataEntry();
        for (EvaluationDataColumn col : format.getColumns()) {
            col.set(e, format, dataRecord);
        }
        this.add(e);
        return true;
    }

    @Override
    public boolean add(String[] dataRecord) {
        return this.add(dataRecord, this.dataFormat);
    }

    @Override
    public void add(int index, EvaluationDataEntry element) {
        this.checkMentionMode(element);
        super.add(index, element);
    }

    public Multimap<String, EvaluationDataEntry> organizeByDocument() {
        this.entriesByDocument = ArrayListMultimap.create();
        for (EvaluationDataEntry entry : this) {
            this.entriesByDocument.put(entry.getDocId(), entry);
        }
        return this.entriesByDocument;
    }

    public boolean isMentionData() {
        return this.isMentionData;
    }

    public Multimap<String, EvaluationDataEntry> getEntriesByDocument() {
        return this.entriesByDocument;
    }

    public static EvaluationData readDataFile(File dataFile) {
        return EvaluationData.readDataFile(dataFile, DEFAULT_FORMAT);
    }

    public static EvaluationData readDataFile(File dataFile, Properties properties) {
        EvaluationDataFormat dataFormat = EntityEvaluator.getDataFormatFromConfiguration(properties);
        return EvaluationData.readDataFile(dataFile, dataFormat);
    }

    public static EvaluationData readDataFile(File dataFile, EvaluationDataFormat format) {
        EvaluationData data = new EvaluationData();
        int i = 0;
        try (BufferedReader br = new BufferedReader(new FileReader(dataFile));){
            String line;
            while ((line = br.readLine()) != null) {
                ++i;
                String[] splitLine = line.split("\t");
                data.add(splitLine, format);
            }
        }
        catch (IOException e) {
            log.error("IOException while reading evaluation data", e);
        }
        catch (NoOffsetsException e) {
            log.error("Error while reading file \"{}\" on line {}: ", dataFile.getAbsolutePath(), i, e);
        }
        return data;
    }

    public EvaluationData slice(String entityType) {
        return this.stream().filter(e -> e.getEntityType().equals(entityType)).collect(Collectors.toCollection(EvaluationData::new));
    }

    public Map<String, EvaluationData> groupByEntityTypes() {
        return this.stream().collect(Collectors.groupingBy(EvaluationDataEntry::getEntityType, HashMap::new, Collectors.mapping(Function.identity(), Collectors.toCollection(() -> new EvaluationData(this.isMentionData)))));
    }

    public Map<String, EvaluationData> groupByEntityLabel() {
        return this.stream().collect(Collectors.groupingBy(EvaluationDataEntry::getEntityId, HashMap::new, Collectors.mapping(Function.identity(), Collectors.toCollection(() -> new EvaluationData(this.isMentionData)))));
    }

    public static enum GroupingType {
        ENTITYTYPE,
        LABEL;

    }
}

