/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.evaluation.entities;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultiset;
import de.julielab.evaluation.entities.EntityEvaluationResult;
import de.julielab.evaluation.entities.EntityEvaluationResults;
import de.julielab.evaluation.entities.EvaluationData;
import de.julielab.evaluation.entities.EvaluationDataEntry;
import de.julielab.evaluation.entities.EvaluationMode;
import de.julielab.evaluation.entities.format.EvaluationDataFormat;
import de.julielab.evaluation.entities.format.GeneNormalizationFormat;
import de.julielab.evaluation.entities.format.GeneNormalizationNoOffsetsFormat;
import de.julielab.java.utilities.spanutils.OffsetMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityEvaluator {
    public static final String PROP_ERROR_ANALYZER = "error-analyzer";
    public static final String PROP_ERROR_STATS = "error-statistics-class";
    public static final String PROP_COMPARISON_TYPE = "comparison-type";
    public static final String PROP_OVERLAP_TYPE = "overlap-type";
    public static final String PROP_OVERLAP_SIZE = "overlap-size";
    public static final String PROP_WITH_IDS = "with-ids";
    public static final String PROP_GROUPING_TYPE = "grouping-type";
    public static final Logger log = LoggerFactory.getLogger(EntityEvaluator.class);
    private EvaluationDataEntry.ComparisonType comparisonType;
    private EvaluationDataEntry.OverlapType overlapType;
    private int overlapSize;
    private boolean withIds;
    private Properties properties;
    private EvaluationDataFormat dataFormat;

    public EntityEvaluator() {
        this.comparisonType = EvaluationDataEntry.ComparisonType.EXACT;
        this.overlapType = EvaluationDataEntry.OverlapType.PERCENT;
        this.overlapSize = 100;
        this.withIds = true;
        this.dataFormat = new GeneNormalizationFormat();
        log.debug("ComparisonType: {}", (Object)this.comparisonType);
        log.debug("OverlapType: {}", (Object)this.overlapType);
        log.debug("OverlapSize: {}", (Object)this.overlapSize);
        log.debug("WithIds: {}", (Object)this.withIds);
    }

    public EntityEvaluator(File propertiesFile) {
        this(((Supplier<Properties>)() -> {
            Properties p = new Properties();
            try {
                p.load(new FileInputStream(propertiesFile));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return p;
        }).get());
    }

    public EntityEvaluator(Properties properties) {
        this.properties = properties;
        this.comparisonType = EvaluationDataEntry.ComparisonType.valueOf(properties.getProperty(PROP_COMPARISON_TYPE, EvaluationDataEntry.ComparisonType.EXACT.toString()).toUpperCase());
        this.overlapType = EvaluationDataEntry.OverlapType.valueOf(properties.getProperty(PROP_OVERLAP_TYPE, EvaluationDataEntry.OverlapType.PERCENT.toString()).toUpperCase());
        this.overlapSize = Integer.parseInt(properties.getProperty(PROP_OVERLAP_SIZE, "100"));
        this.withIds = Boolean.parseBoolean(properties.getProperty(PROP_WITH_IDS, "true"));
        if (properties.containsKey("input-format-class")) {
            this.dataFormat = EntityEvaluator.getDataFormatFromConfiguration(properties);
        }
        String errorAnalyzerClass = properties.getProperty(PROP_ERROR_ANALYZER);
        String errorStatisticsClass = properties.getProperty(PROP_ERROR_STATS);
        log.debug("ComparisonType: {}", (Object)this.comparisonType);
        log.debug("OverlapType: {}", (Object)this.overlapType);
        log.debug("OverlapSize: {}", (Object)this.overlapSize);
        log.debug("Error analysis: {}", (Object)errorAnalyzerClass);
        log.debug("Print error statistics class: {}", (Object)errorStatisticsClass);
        log.debug("With IDs: {}", (Object)this.withIds);
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Usage: " + EntityEvaluator.class.getSimpleName() + " -g <gold data> [-a <alternative gold data>] -p <pred data> [-c configration file]");
            System.exit(1);
        }
        File goldFile = null;
        File goldAltFile = null;
        File predFile = null;
        File configFile = null;
        block19: for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.startsWith("-")) continue;
            if (i >= args.length) {
                System.err.println("Missing value for parameter " + arg);
                System.exit(1);
            }
            String value = args[i + 1];
            switch (arg) {
                case "-g": {
                    goldFile = new File(value);
                    continue block19;
                }
                case "-a": {
                    goldAltFile = new File(value);
                    continue block19;
                }
                case "-p": {
                    predFile = new File(value);
                    continue block19;
                }
                case "-c": {
                    configFile = new File(value);
                    continue block19;
                }
                default: {
                    System.err.println("Unknown parameter " + arg);
                    System.exit(2);
                }
            }
        }
        if (goldFile == null || predFile == null) {
            System.err.println("Missing gold or prediction file.");
            System.err.println("Usage: " + EntityEvaluator.class.getSimpleName() + " -g <gold data> [-a <alternative gold data>] -p <pred data> [-c configration file]");
            System.exit(3);
        }
        EntityEvaluator evaluator = configFile == null ? new EntityEvaluator() : new EntityEvaluator(configFile);
        EvaluationData goldData = null;
        EvaluationData goldAltData = null;
        EvaluationData predData = null;
        if (configFile == null || evaluator.getProperties().getProperty("input-format-class") == null) {
            System.out.println("No configuration file given, trying to guess data format.");
            List<EvaluationDataFormat> formats = Arrays.asList(new GeneNormalizationFormat(), new GeneNormalizationNoOffsetsFormat());
            EvaluationDataFormat foundFormat = null;
            for (int i = 0; foundFormat == null && i < formats.size(); ++i) {
                EvaluationDataFormat format = formats.get(i);
                try {
                    goldData = EvaluationData.readDataFile(goldFile, format);
                    goldAltData = goldAltFile != null ? EvaluationData.readDataFile(goldAltFile, format) : new EvaluationData();
                    predData = EvaluationData.readDataFile(predFile, format);
                    foundFormat = format;
                    continue;
                }
                catch (NumberFormatException e) {
                    System.out.println(format.getClass().getSimpleName() + " did cause exception, trying the next.");
                }
            }
            if (foundFormat == null) {
                System.out.println("All input data format specifications failed: " + formats.stream().map(f -> f.getClass().getSimpleName()).collect(Collectors.joining(", ")));
                System.out.println("Please use a configuration file and specify the correct format class.");
                System.exit(1);
            }
            evaluator.setDataFormat(foundFormat);
        } else {
            goldData = EvaluationData.readDataFile(goldFile, evaluator.dataFormat);
            goldAltData = goldAltFile != null ? EvaluationData.readDataFile(goldAltFile, evaluator.dataFormat) : new EvaluationData();
            predData = EvaluationData.readDataFile(predFile, evaluator.dataFormat);
        }
        EntityEvaluationResults results = evaluator.evaluate(goldData, goldAltData, predData);
        try (FileOutputStream fos = new FileOutputStream("EvaluationReport.txt");){
            for (EntityEvaluationResult result : results.values()) {
                System.out.println(result.getEvaluationReportShort());
                IOUtils.write(result.getEvaluationReportLong(), (OutputStream)fos);
            }
        }
    }

    public static EvaluationDataFormat getDataFormatFromConfiguration(Properties properties) {
        EvaluationDataFormat dataFormat;
        String dataFormatClassName = properties != null ? properties.getProperty("input-format-class", GeneNormalizationFormat.class.getCanonicalName()) : GeneNormalizationFormat.class.getCanonicalName();
        try {
            dataFormat = (EvaluationDataFormat)Class.forName(dataFormatClassName).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Evaluation data format class " + dataFormatClassName + " could not be loaded.", e);
        }
        return dataFormat;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public EntityEvaluationResults evaluate(EvaluationData gold, EvaluationData predicted) {
        return this.evaluate(gold, new EvaluationData(), predicted);
    }

    public EntityEvaluationResults evaluate(EvaluationData gold, EvaluationData alternative, EvaluationData predicted) {
        if (this.comparisonType != EvaluationDataEntry.ComparisonType.EXACT || !this.withIds) {
            log.debug("Converting gold and predicted entity entries to the following comparison method: ComparisonType - {}; OverlapType - {}; OverlapSize - {}", new Object[]{this.comparisonType, this.overlapType, this.overlapSize});
            Consumer<Stream> entryConfigurator = s2 -> {
                if (!this.withIds) {
                    log.debug("Converting gold and predicted entity entries for evaluation without IDs.");
                }
                s2.forEach(e -> {
                    e.setComparisonType(this.comparisonType);
                    e.setOverlapType(this.overlapType);
                    e.setOverlapSize(this.overlapSize);
                    if (!this.withIds) {
                        e.setEntityId("0");
                    }
                });
            };
            entryConfigurator.accept(gold.stream());
            entryConfigurator.accept(alternative.stream());
            entryConfigurator.accept(predicted.stream());
        }
        EvaluationData.GroupingType groupingType = this.properties != null ? EvaluationData.GroupingType.valueOf(this.properties.getProperty(PROP_GROUPING_TYPE, EvaluationData.GroupingType.ENTITYTYPE.name()).toUpperCase()) : EvaluationData.GroupingType.ENTITYTYPE;
        Function<EvaluationData, Map> toLabelGroups = groupingType == EvaluationData.GroupingType.ENTITYTYPE ? data -> {
            Map<String, EvaluationData> map = data.groupByEntityTypes();
            if (map.size() > 1) {
                map.put("OVERALL", (EvaluationData)data);
            }
            return map;
        } : data -> {
            Map<String, EvaluationData> map = data.groupByEntityLabel();
            if (map.size() > 1) {
                map.put("OVERALL", (EvaluationData)data);
            }
            return map;
        };
        Map goldByEntityTypes = toLabelGroups.apply(gold);
        Map goldAltByEntityTypes = toLabelGroups.apply(alternative);
        Map predictedByEntityTypes = toLabelGroups.apply(predicted);
        EntityEvaluationResults results = new EntityEvaluationResults();
        for (String entityType : Sets.union(goldByEntityTypes.keySet(), predictedByEntityTypes.keySet())) {
            Multimap<String, EvaluationDataEntry> goldByDoc = goldByEntityTypes.getOrDefault(entityType, new EvaluationData(gold.isMentionData())).organizeByDocument();
            Multimap<String, EvaluationDataEntry> goldAltByDoc = goldAltByEntityTypes.getOrDefault(entityType, new EvaluationData(predicted.isMentionData())).organizeByDocument();
            Multimap<String, EvaluationDataEntry> predByDoc = predictedByEntityTypes.getOrDefault(entityType, new EvaluationData(predicted.isMentionData())).organizeByDocument();
            EntityEvaluationResult evalResult = new EntityEvaluationResult();
            evalResult.setEntityType(entityType);
            for (String docId : Sets.union(goldByDoc.keySet(), predByDoc.keySet())) {
                Collection<EvaluationDataEntry> goldEntries = goldByDoc.get(docId);
                Collection<EvaluationDataEntry> goldAltEntries = goldAltByDoc.get(docId);
                Collection<EvaluationDataEntry> predEntries = predByDoc.get(docId);
                if (gold.isMentionData() && predicted.isMentionData()) {
                    this.computeEvalStatisticsMentionWise(goldEntries, goldAltEntries, predEntries, docId, evalResult);
                }
                this.computeEvalStatisticsDocWise(goldEntries, predEntries, docId, evalResult);
            }
            results.put(entityType, evalResult);
        }
        return results;
    }

    public EntityEvaluationResults evaluate(List<String[]> gold, List<String[]> predicted) {
        return this.evaluate(gold, predicted, this.dataFormat);
    }

    public EntityEvaluationResults evaluate(List<String[]> gold, List<String[]> predicted, EvaluationDataFormat format) {
        EvaluationData goldData = new EvaluationData(gold, format);
        EvaluationData predData = new EvaluationData(predicted, format);
        return this.evaluate(goldData, predData);
    }

    private void computeEvalStatisticsMentionWise(Collection<EvaluationDataEntry> goldEntries, Collection<EvaluationDataEntry> goldAltEntries, Collection<EvaluationDataEntry> predEntries, String docId, EntityEvaluationResult evalResult) {
        TreeMultiset<EvaluationDataEntry> goldSet = TreeMultiset.create(goldEntries);
        TreeMultiset<EvaluationDataEntry> goldAltSet = TreeMultiset.create(goldAltEntries);
        TreeMultiset<EvaluationDataEntry> predSet = TreeMultiset.create(predEntries);
        Runnable resetGoldSet = () -> {
            goldSet.clear();
            goldSet.addAll(goldEntries);
        };
        OffsetMap goldOffsetMap = goldSet.stream().collect(Collectors.toMap(EvaluationDataEntry::getOffsetRange, Function.identity(), (e1, e2) -> e1, OffsetMap::new));
        Multiset tpGoldSet = predSet.stream().filter(goldSet::remove).collect(Collectors.toCollection(TreeMultiset::create));
        resetGoldSet.run();
        HashSet tpAltSet = new HashSet();
        for (EvaluationDataEntry e : () -> predSet.stream().filter(goldAltEntries::contains).iterator()) {
            Range<Integer> range = Range.between(e.getBegin(), e.getEnd());
            Multiset overlappingGold = goldOffsetMap.getOverlapping(range).values().stream().filter(gold -> gold.getEntityId().equals(e.getEntityId())).collect(Collectors.toCollection(TreeMultiset::create));
            tpAltSet.addAll(overlappingGold);
        }
        Multiset tpSet = Stream.concat(tpGoldSet.stream(), tpAltSet.stream()).collect(Collectors.toCollection(TreeMultiset::create));
        Multiset fpSet = predSet.stream().filter(Predicate.not(goldSet::remove)).filter(Predicate.not(goldAltSet::remove)).collect(Collectors.toCollection(TreeMultiset::create));
        TreeMultiset<EvaluationDataEntry> fnSet = TreeMultiset.create(goldEntries);
        tpGoldSet.forEach(fnSet::remove);
        tpAltSet.forEach(fnSet::remove);
        evalResult.addStatisticsByDocument(docId, tpSet, fpSet, fnSet, EvaluationMode.MENTION);
    }

    private void computeEvalStatisticsDocWise(Collection<EvaluationDataEntry> goldEntries, Collection<EvaluationDataEntry> predEntries, String docId, EntityEvaluationResult evalResult) {
        TreeSet goldSet = new TreeSet();
        Runnable resetGoldSet = () -> {
            for (EvaluationDataEntry entry : goldEntries) {
                goldSet.add(entry.toDocWiseEntry());
            }
        };
        resetGoldSet.run();
        TreeSet<EvaluationDataEntry> predSet = new TreeSet<EvaluationDataEntry>();
        for (EvaluationDataEntry entry : predEntries) {
            predSet.add(entry.toDocWiseEntry());
        }
        Multiset tpSet = predSet.stream().filter(goldSet::contains).collect(Collectors.toCollection(TreeMultiset::create));
        Multiset fpSet = predSet.stream().filter(Predicate.not(goldSet::remove)).collect(Collectors.toCollection(TreeMultiset::create));
        resetGoldSet.run();
        Multiset fnSet = goldSet.stream().filter(Predicate.not(predSet::remove)).collect(Collectors.toCollection(TreeMultiset::create));
        evalResult.addStatisticsByDocument(docId, tpSet, fpSet, fnSet, EvaluationMode.DOCUMENT);
    }

    public EvaluationDataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(EvaluationDataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }
}

