/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.evaluation.entities;

import com.google.common.collect.Multiset;
import de.julielab.evaluation.entities.EvaluationDataEntry;
import de.julielab.evaluation.entities.EvaluationDataEntrySets;
import de.julielab.evaluation.entities.EvaluationMode;
import de.julielab.evaluation.entities.EvaluationStatistics;
import de.julielab.evaluation.entities.FMeasure;
import de.julielab.evaluation.entities.Statistics;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;

public class EntityEvaluationResult {
    private Map<String, EvaluationStatistics> statisticsByDocumentMentionWise = Collections.emptyMap();
    private Map<String, EvaluationStatistics> statisticsByDocumentDocWise = Collections.emptyMap();
    private Map<String, EvaluationDataEntrySets> entrySetsByDocumentMentionWise = Collections.emptyMap();
    private Map<String, EvaluationDataEntrySets> entrySetsByDocumentDocWise = Collections.emptyMap();
    private String entityType;
    private EvaluationMode evaluationMode;

    public EvaluationMode getEvaluationMode() {
        return this.evaluationMode;
    }

    public void addStatisticsByDocument(String docId, Multiset<EvaluationDataEntry> tpSet, Multiset<EvaluationDataEntry> fpSet, Multiset<EvaluationDataEntry> fnSet, EvaluationMode statsMode) {
        switch (statsMode) {
            case DOCUMENT: {
                if (this.evaluationMode == null) {
                    this.evaluationMode = statsMode;
                }
                if (this.statisticsByDocumentDocWise.isEmpty()) {
                    this.statisticsByDocumentDocWise = new LinkedHashMap<String, EvaluationStatistics>();
                }
                this.statisticsByDocumentDocWise.put(docId, new EvaluationStatistics(tpSet.size(), fpSet.size(), fnSet.size()));
                if (this.entrySetsByDocumentDocWise.isEmpty()) {
                    this.entrySetsByDocumentDocWise = new LinkedHashMap<String, EvaluationDataEntrySets>();
                }
                this.entrySetsByDocumentDocWise.put(docId, new EvaluationDataEntrySets(tpSet, fpSet, fnSet));
                break;
            }
            case MENTION: {
                this.evaluationMode = statsMode;
                if (this.statisticsByDocumentMentionWise.isEmpty()) {
                    this.statisticsByDocumentMentionWise = new LinkedHashMap<String, EvaluationStatistics>();
                }
                this.statisticsByDocumentMentionWise.put(docId, new EvaluationStatistics(tpSet.size(), fpSet.size(), fnSet.size()));
                if (this.entrySetsByDocumentMentionWise.isEmpty()) {
                    this.entrySetsByDocumentMentionWise = new LinkedHashMap<String, EvaluationDataEntrySets>();
                }
                this.entrySetsByDocumentMentionWise.put(docId, new EvaluationDataEntrySets(tpSet, fpSet, fnSet));
            }
        }
    }

    public double getFMeasure(String documentId, EvaluationMode evaluationMode) {
        return evaluationMode == EvaluationMode.MENTION ? this.entrySetsByDocumentMentionWise.getOrDefault(documentId, EvaluationDataEntrySets.EMPTY).getFMeasure() : this.entrySetsByDocumentDocWise.getOrDefault(documentId, EvaluationDataEntrySets.EMPTY).getFMeasure();
    }

    public double getRecall(String documentId, EvaluationMode evaluationMode) {
        return evaluationMode == EvaluationMode.MENTION ? this.entrySetsByDocumentMentionWise.getOrDefault(documentId, EvaluationDataEntrySets.EMPTY).getRecall() : this.entrySetsByDocumentDocWise.getOrDefault(documentId, EvaluationDataEntrySets.EMPTY).getRecall();
    }

    public double getPrecision(String documentId, EvaluationMode evaluationMode) {
        return evaluationMode == EvaluationMode.MENTION ? this.entrySetsByDocumentMentionWise.getOrDefault(documentId, EvaluationDataEntrySets.EMPTY).getPrecision() : this.entrySetsByDocumentDocWise.getOrDefault(documentId, EvaluationDataEntrySets.EMPTY).getPrecision();
    }

    public double getFMeasure(String documentId) {
        return this.getFMeasure(documentId, this.evaluationMode);
    }

    public double getRecall(String documentId) {
        return this.getRecall(documentId, this.evaluationMode);
    }

    public double getPrecision(String documentId) {
        return this.getPrecision(documentId, this.evaluationMode);
    }

    public Map<String, EvaluationDataEntrySets> getEntrySetsByDocumentMentionWise() {
        return this.entrySetsByDocumentMentionWise;
    }

    public Map<String, EvaluationDataEntrySets> getEntrySetsByDocumentDocWise() {
        return this.entrySetsByDocumentDocWise;
    }

    public Stream<EvaluationDataEntry> getTpEvaluationDataEntriesMentionWise() {
        return this.entrySetsByDocumentMentionWise.values().stream().flatMap(set -> set.tpSet.stream());
    }

    public Stream<EvaluationDataEntry> getFpEvaluationDataEntriesMentionWise() {
        return this.entrySetsByDocumentMentionWise.values().stream().flatMap(set -> set.fpSet.stream());
    }

    public Stream<EvaluationDataEntry> getFnEvaluationDataEntriesMentionWise() {
        return this.entrySetsByDocumentMentionWise.values().stream().flatMap(set -> set.fnSet.stream());
    }

    public Stream<EvaluationDataEntry> getTpEvaluationDataEntriesDocWise() {
        return this.entrySetsByDocumentDocWise.values().stream().flatMap(set -> set.tpSet.stream());
    }

    public Stream<EvaluationDataEntry> getFpEvaluationDataEntriesDocWise() {
        return this.entrySetsByDocumentDocWise.values().stream().flatMap(set -> set.fpSet.stream());
    }

    public Stream<EvaluationDataEntry> getFnEvaluationDataEntriesDocWise() {
        return this.entrySetsByDocumentDocWise.values().stream().flatMap(set -> set.fnSet.stream());
    }

    public Map<String, EvaluationStatistics> getStatisticsByDocumentMentionWise() {
        return this.statisticsByDocumentMentionWise;
    }

    public Map<String, EvaluationStatistics> getStatisticsByDocumentDocWise() {
        return this.statisticsByDocumentDocWise;
    }

    public double getMacroFMeasureMentionWise() {
        double sum = 0.0;
        for (Map.Entry<String, EvaluationStatistics> entry : this.statisticsByDocumentMentionWise.entrySet()) {
            sum += entry.getValue().getFMeasure();
        }
        return sum / (double)this.statisticsByDocumentMentionWise.size();
    }

    public double getMacroPrecisionMentionWise() {
        double sum = 0.0;
        for (Map.Entry<String, EvaluationStatistics> entry : this.statisticsByDocumentMentionWise.entrySet()) {
            sum += entry.getValue().getPrecision();
        }
        return sum / (double)this.statisticsByDocumentMentionWise.size();
    }

    public double getMacroRecallMentionWise() {
        double sum = 0.0;
        for (Map.Entry<String, EvaluationStatistics> entry : this.statisticsByDocumentMentionWise.entrySet()) {
            sum += entry.getValue().getRecall();
        }
        return sum / (double)this.statisticsByDocumentMentionWise.size();
    }

    public double getMacroFMeasureDocWise() {
        double sum = 0.0;
        for (Map.Entry<String, EvaluationStatistics> entry : this.statisticsByDocumentDocWise.entrySet()) {
            sum += entry.getValue().getFMeasure();
        }
        return sum / (double)this.statisticsByDocumentDocWise.size();
    }

    public double getMicroFMeasureDocWise() {
        return FMeasure.getFMeasure(this.getSumTpDocWise(), this.getSumFpDocWise(), this.getSumFnDocWise());
    }

    public double getMicroRecallDocWise() {
        return FMeasure.getRecall(this.getSumTpDocWise(), this.getSumFpDocWise(), this.getSumFnDocWise());
    }

    public double getMicroPrecisionDocWise() {
        return FMeasure.getPrecision(this.getSumTpDocWise(), this.getSumFpDocWise(), this.getSumFnDocWise());
    }

    public double getMicroFMeasureMentionWise() {
        return FMeasure.getFMeasure(this.getSumTpMentionWise(), this.getSumFpMentionWise(), this.getSumFnMentionWise());
    }

    public double getMicroRecallMentionWise() {
        return FMeasure.getRecall(this.getSumTpMentionWise(), this.getSumFpMentionWise(), this.getSumFnMentionWise());
    }

    public double getMicroPrecisionMentionWise() {
        return FMeasure.getPrecision(this.getSumTpMentionWise(), this.getSumFpMentionWise(), this.getSumFnMentionWise());
    }

    public double getMacroPrecisionDocWise() {
        double sum = 0.0;
        for (Map.Entry<String, EvaluationStatistics> entry : this.statisticsByDocumentDocWise.entrySet()) {
            sum += entry.getValue().getPrecision();
        }
        return sum / (double)this.statisticsByDocumentDocWise.size();
    }

    public double getMacroRecallDocWise() {
        double sum = 0.0;
        for (Map.Entry<String, EvaluationStatistics> entry : this.statisticsByDocumentDocWise.entrySet()) {
            sum += entry.getValue().getRecall();
        }
        return sum / (double)this.statisticsByDocumentDocWise.size();
    }

    public int getSumFpDocWise() {
        int sum = 0;
        for (EvaluationStatistics stats : this.statisticsByDocumentDocWise.values()) {
            sum += stats.fp;
        }
        return sum;
    }

    public int getSumFnDocWise() {
        int sum = 0;
        for (EvaluationStatistics stats : this.statisticsByDocumentDocWise.values()) {
            sum += stats.fn;
        }
        return sum;
    }

    public int getSumTpDocWise() {
        int sum = 0;
        for (EvaluationStatistics stats : this.statisticsByDocumentDocWise.values()) {
            sum += stats.tp;
        }
        return sum;
    }

    public int getSumFpMentionWise() {
        int sum = 0;
        for (EvaluationStatistics stats : this.statisticsByDocumentMentionWise.values()) {
            sum += stats.fp;
        }
        return sum;
    }

    public int getSumFnMentionWise() {
        int sum = 0;
        for (EvaluationStatistics stats : this.statisticsByDocumentMentionWise.values()) {
            sum += stats.fn;
        }
        return sum;
    }

    public int getSumTpMentionWise() {
        int sum = 0;
        for (EvaluationStatistics stats : this.statisticsByDocumentMentionWise.values()) {
            sum += stats.tp;
        }
        return sum;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.statisticsByDocumentDocWise == null ? 0 : this.statisticsByDocumentDocWise.hashCode());
        result = 31 * result + (this.statisticsByDocumentMentionWise == null ? 0 : this.statisticsByDocumentMentionWise.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityEvaluationResult other = (EntityEvaluationResult)obj;
        if (this.statisticsByDocumentDocWise == null ? other.statisticsByDocumentDocWise != null : !this.statisticsByDocumentDocWise.equals(other.statisticsByDocumentDocWise)) {
            return false;
        }
        return !(this.statisticsByDocumentMentionWise == null ? other.statisticsByDocumentMentionWise != null : !this.statisticsByDocumentMentionWise.equals(other.statisticsByDocumentMentionWise));
    }

    public String toString() {
        return "EntityEvaluationResult [statisticsByDocumentMentionWise=" + this.statisticsByDocumentMentionWise + ", statisticsByDocumentDocWise=" + this.statisticsByDocumentDocWise + "]";
    }

    public String getEvaluationReportLong() {
        EvaluationStatistics stats;
        String docId;
        StringBuilder sb = new StringBuilder();
        sb.append("Evaluation results for entity type \"" + this.entityType + "\":\n");
        sb.append("Document Level:\n");
        for (Map.Entry<String, EvaluationStatistics> entry : this.getStatisticsByDocumentDocWise().entrySet()) {
            docId = entry.getKey();
            stats = entry.getValue();
            sb.append(docId + ": F: " + stats.getFMeasure() + ", R: " + stats.getRecall() + ", P: " + stats.getPrecision() + " (tp: " + stats.tp + ", fp: " + stats.fp + ", fn: " + stats.fn + ")");
            sb.append("\n");
        }
        sb.append("  TP: ").append(this.getSumTpDocWise()).append("\n");
        sb.append("  FP: ").append(this.getSumFpDocWise()).append("\n");
        sb.append("  FN: ").append(this.getSumFnDocWise()).append("\n");
        sb.append("  Recall (micro):    ").append(this.getMicroRecallDocWise()).append("\n");
        sb.append("  Precision (micro): ").append(this.getMicroPrecisionDocWise()).append("\n");
        sb.append("  F-Score (micro):   ").append(this.getMicroFMeasureDocWise()).append("\n");
        sb.append("  Recall (macro):    ").append(this.getMacroRecallDocWise()).append("\n");
        sb.append("  Precision (macro): ").append(this.getMacroPrecisionDocWise()).append("\n");
        sb.append("  F-Score (macro):   ").append(this.getMacroFMeasureDocWise()).append("\n");
        sb.append("Mention Level:\n");
        if (null != this.statisticsByDocumentMentionWise) {
            for (Map.Entry<String, EvaluationStatistics> entry : this.getStatisticsByDocumentMentionWise().entrySet()) {
                docId = entry.getKey();
                stats = entry.getValue();
                sb.append(docId + ": F: " + stats.getFMeasure() + ", R: " + stats.getRecall() + ", P: " + stats.getPrecision() + " (tp: " + stats.tp + ", fp: " + stats.fp + ", fn: " + stats.fn + ")");
                sb.append("\n");
            }
            sb.append("  TP: ").append(this.getSumTpMentionWise()).append("\n");
            sb.append("  FP: ").append(this.getSumFpMentionWise()).append("\n");
            sb.append("  FN: ").append(this.getSumFnMentionWise()).append("\n");
            sb.append("  Recall (micro):    ").append(this.getMicroRecallMentionWise()).append("\n");
            sb.append("  Precision (micro): ").append(this.getMicroPrecisionMentionWise()).append("\n");
            sb.append("  F-Score (micro):   ").append(this.getMicroFMeasureMentionWise()).append("\n");
            sb.append("  Recall (macro):    ").append(this.getMacroRecallMentionWise()).append("\n");
            sb.append("  Precision (macro): ").append(this.getMacroPrecisionMentionWise()).append("\n");
            sb.append("  F-Score (macro):   ").append(this.getMacroFMeasureMentionWise()).append("\n");
        } else {
            sb.append("No mention information available.");
        }
        sb.append("\n");
        return sb.toString();
    }

    public String getEvaluationReportShort() {
        StringBuilder sb = new StringBuilder();
        sb.append("Evaluation results for entity type \"" + this.entityType + "\":\n");
        sb.append("Document Level:\n");
        sb.append("  TP: ").append(this.getSumTpDocWise()).append("\n");
        sb.append("  FP: ").append(this.getSumFpDocWise()).append("\n");
        sb.append("  FN: ").append(this.getSumFnDocWise()).append("\n");
        sb.append("  Recall (micro):    ").append(this.getMicroRecallDocWise()).append("\n");
        sb.append("  Precision (micro): ").append(this.getMicroPrecisionDocWise()).append("\n");
        sb.append("  F-Score (micro):   ").append(this.getMicroFMeasureDocWise()).append("\n");
        sb.append("Mention Level:\n");
        if (null != this.statisticsByDocumentMentionWise) {
            sb.append("  TP: ").append(this.getSumTpMentionWise()).append("\n");
            sb.append("  FP: ").append(this.getSumFpMentionWise()).append("\n");
            sb.append("  FN: ").append(this.getSumFnMentionWise()).append("\n");
            sb.append("  Recall (micro):    ").append(this.getMicroRecallMentionWise()).append("\n");
            sb.append("  Precision (micro): ").append(this.getMicroPrecisionMentionWise()).append("\n");
            sb.append("  F-Score (micro):   ").append(this.getMicroFMeasureMentionWise()).append("\n");
        } else {
            sb.append("No mention information available.");
        }
        return sb.toString();
    }

    public String getEvaluationReportAllTp(EvaluationMode mode) {
        return this.getEvaluationReportAllEntries(mode, Statistics.TP);
    }

    public String getEvaluationReportAllFp(EvaluationMode mode) {
        return this.getEvaluationReportAllEntries(mode, Statistics.FP);
    }

    public String getEvaluationReportAllFn(EvaluationMode mode) {
        return this.getEvaluationReportAllEntries(mode, Statistics.FN);
    }

    public String getEvaluationReportAllEntries(EvaluationMode mode, Statistics type) {
        StringBuilder sb = new StringBuilder();
        switch (mode) {
            case DOCUMENT: {
                for (Map.Entry<String, EvaluationDataEntrySets> entry : this.entrySetsByDocumentDocWise.entrySet()) {
                    for (EvaluationDataEntry dataEntry : entry.getValue().get(type)) {
                        sb.append(entry.getKey());
                        sb.append(":");
                        sb.append(dataEntry.getEntityId());
                        sb.append("\n");
                    }
                }
                break;
            }
            case MENTION: {
                for (Map.Entry<String, EvaluationDataEntrySets> entry : this.entrySetsByDocumentMentionWise.entrySet()) {
                    for (EvaluationDataEntry dataEntry : entry.getValue().get(type)) {
                        sb.append(entry.getKey());
                        sb.append(":");
                        sb.append(dataEntry.getEntityId());
                        sb.append("\n");
                    }
                }
                break;
            }
        }
        return sb.toString();
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }
}

