/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.costosys.medline;

import de.julielab.costosys.dbconnection.CoStoSysConnection;
import de.julielab.costosys.dbconnection.DataBaseConnector;
import de.julielab.costosys.medline.DocumentDeletionException;
import de.julielab.costosys.medline.IDocumentDeleter;
import de.julielab.costosys.medline.MedlineUpdateException;
import de.julielab.costosys.medline.SimplePKDataTableDocumentDeleter;
import de.julielab.java.utilities.ConfigurationUtilities;
import de.julielab.xml.JulieXMLTools;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PubmedUpdater {
    public static final String UPDATE_TABLE = "_data._medline_update_files";
    public static final String COLUMN_FILENAME = "update_file_name";
    public static final String COLUMN_IS_IMPORTED = "is_imported";
    public static final String COLUMN_TIMESTAMP = "timestamp_of_import";
    private static final Logger log = LoggerFactory.getLogger(PubmedUpdater.class);
    private final String[] medlineFileDirectories;
    private ServiceLoader<IDocumentDeleter> documentDeleterLoader;
    private HierarchicalConfiguration<ImmutableNode> configuration;

    public PubmedUpdater(HierarchicalConfiguration<ImmutableNode> configuration) {
        this.configuration = configuration;
        this.medlineFileDirectories = configuration.getStringArray("directories.directory");
        this.documentDeleterLoader = ServiceLoader.load(IDocumentDeleter.class);
        log.info("Initialized MEDLINE Updater with file directories {} and document deleters {}.", (Object)this.medlineFileDirectories, (Object)configuration.getStringArray(ConfigurationUtilities.dot("documentdeletions.deletion", "deleter")));
        log.debug("Loaded the following document deleters: {}", (Object)this.documentDeleterLoader.stream().map(d -> ((IDocumentDeleter)d.get()).getName()).collect(Collectors.joining(", ")));
    }

    private static List<File> getUnprocessedMedlineUpdates(File[] updateFiles, DataBaseConnector dbc) throws MedlineUpdateException {
        ArrayList<File> unprocessedFiles = new ArrayList<File>();
        try (CoStoSysConnection coStoSysConnection = dbc.obtainOrReserveConnection(true);){
            Connection conn = coStoSysConnection.getConnection();
            HashSet<String> updateFileNameSet = new HashSet<String>();
            for (File f : updateFiles) {
                updateFileNameSet.add(f.getName());
            }
            try {
                Statement st = conn.createStatement();
                boolean exists = dbc.tableExists(UPDATE_TABLE);
                if (!exists) {
                    String createUpdateTable = String.format("CREATE TABLE %s (%s TEXT PRIMARY KEY,%s BOOLEAN DEFAULT FALSE,%s TIMESTAMP WITHOUT TIME ZONE)", UPDATE_TABLE, COLUMN_FILENAME, COLUMN_IS_IMPORTED, COLUMN_TIMESTAMP);
                    st.execute(createUpdateTable);
                }
                HashSet<String> filenamesInDBSet = new HashSet<String>();
                ResultSet rs = st.executeQuery(String.format("SELECT %s from %s", COLUMN_FILENAME, UPDATE_TABLE));
                while (rs.next()) {
                    String filename = rs.getString(COLUMN_FILENAME);
                    filenamesInDBSet.add(filename);
                }
                updateFileNameSet.removeAll(filenamesInDBSet);
                conn.setAutoCommit(false);
                PreparedStatement ps = conn.prepareStatement(String.format("INSERT INTO %s VALUES (?)", UPDATE_TABLE));
                for (String filename : updateFileNameSet) {
                    ps.setString(1, filename);
                    ps.addBatch();
                }
                ps.executeBatch();
                conn.commit();
                conn.setAutoCommit(true);
                String sql = String.format("SELECT %s FROM %s WHERE %s = FALSE", COLUMN_FILENAME, UPDATE_TABLE, COLUMN_IS_IMPORTED);
                rs = st.executeQuery(sql);
                HashSet<String> unprocessedFileSet = new HashSet<String>();
                while (rs.next()) {
                    unprocessedFileSet.add(rs.getString(COLUMN_FILENAME));
                }
                for (File updateFile : updateFiles) {
                    if (!unprocessedFileSet.contains(updateFile.getName())) continue;
                    unprocessedFiles.add(updateFile);
                }
            }
            catch (SQLException e) {
                throw new MedlineUpdateException(e);
            }
        }
        return unprocessedFiles;
    }

    private static List<String> getPmidsToDelete(File file) {
        ArrayList<String> pmidsToDelete = new ArrayList<String>();
        String forEachXpath = "/PubmedArticleSet/DeleteCitation/PMID";
        ArrayList<Map<String, String>> fields = new ArrayList<Map<String, String>>();
        HashMap<String, String> field = new HashMap<String, String>();
        field.put("name", "pmid");
        field.put("xpath", ".");
        fields.add(field);
        int bufferSize = 1000;
        Iterator<Map<String, Object>> it = JulieXMLTools.constructRowIterator(file.getAbsolutePath(), bufferSize, forEachXpath, fields, false);
        while (it.hasNext()) {
            Map<String, Object> row = it.next();
            String pmid = (String)row.get("pmid");
            pmidsToDelete.add(pmid);
        }
        return pmidsToDelete;
    }

    public void process(DataBaseConnector dbc, boolean ignoreAlreadyProcessed) throws MedlineUpdateException, IOException {
        if (ignoreAlreadyProcessed) {
            log.info("Ignoring update file processing state in the database and processing all files in the directories {}.", this.medlineFileDirectories);
        }
        this.configureDocumentDeleters();
        for (String directory : this.medlineFileDirectories) {
            log.info("Updating from {} into database at {}", (Object)directory, (Object)dbc.getDbURL());
            File[] medlineFiles = this.getMedlineFiles(directory);
            if (medlineFiles == null || medlineFiles.length <= 0) continue;
            List<File> unprocessedMedlineUpdates = ignoreAlreadyProcessed ? Arrays.asList(medlineFiles) : PubmedUpdater.getUnprocessedMedlineUpdates(medlineFiles, dbc);
            Collections.sort(unprocessedMedlineUpdates, Comparator.comparing(File::getName));
            Object[] configuredDeleters = this.configuration.getStringArray(ConfigurationUtilities.dot("documentdeletions.deletion", "deleter"));
            for (File file : unprocessedMedlineUpdates) {
                log.info("Processing file {}.", (Object)file.getAbsoluteFile());
                dbc.updateFromXML(file.getAbsolutePath(), "_data._data", true);
                List<String> pmidsToDelete = PubmedUpdater.getPmidsToDelete(file);
                HashSet<IDocumentDeleter> appliedDeleters = new HashSet<IDocumentDeleter>();
                for (IDocumentDeleter documentDeleter : this.documentDeleterLoader) {
                    log.debug("Checking if deleter {} is part of the deleter configuration.", (Object)documentDeleter.getName());
                    if (!documentDeleter.isOneOf((String[])configuredDeleters)) {
                        log.debug("Skipping document deleter {}.", (Object)documentDeleter.getName());
                        continue;
                    }
                    log.debug("Applying document deleter {}.", (Object)documentDeleter.getName());
                    if (documentDeleter instanceof SimplePKDataTableDocumentDeleter) {
                        ((SimplePKDataTableDocumentDeleter)documentDeleter).setDbc(dbc);
                    }
                    documentDeleter.deleteDocuments(pmidsToDelete);
                    appliedDeleters.add(documentDeleter);
                }
                if (appliedDeleters.size() < configuredDeleters.length) {
                    throw new IllegalStateException("Not all document deleters could be applied. Configured deleters were " + Arrays.toString(configuredDeleters) + " but applied were only " + (appliedDeleters.isEmpty() ? "none" : appliedDeleters.stream().map(IDocumentDeleter::getName).collect(Collectors.joining(", "))));
                }
                this.markFileAsImported(file, dbc);
            }
        }
    }

    protected File[] getMedlineFiles(String medlinePathString) throws FileNotFoundException {
        File medlinePath = new File(medlinePathString);
        if (!medlinePath.exists()) {
            throw new FileNotFoundException("File \"" + medlinePathString + "\" was not found.");
        }
        if (!medlinePath.isDirectory()) {
            return new File[]{medlinePath};
        }
        File[] medlineFiles = medlinePath.listFiles(file -> {
            String filename = file.getName();
            return filename.endsWith("gz") || filename.endsWith("gzip") || filename.endsWith("zip");
        });
        if (medlineFiles == null || medlineFiles.length == 0) {
            log.info("No (g)zipped files found in directory {}. No update will be performed.", (Object)medlinePathString);
        }
        return medlineFiles;
    }

    private void configureDocumentDeleters() throws DocumentDeletionException {
        log.trace("Configuring document deleters");
        if (this.configuration.containsKey(ConfigurationUtilities.dot("documentdeletions.deletion", "deleter"))) {
            List deletionConfigs = this.configuration.configurationsAt("documentdeletions.deletion");
            log.trace("Found {} deleter configurations.", (Object)deletionConfigs.size());
            for (HierarchicalConfiguration deletionConf : deletionConfigs) {
                for (IDocumentDeleter documentDeleter : this.documentDeleterLoader) {
                    log.trace("Configuring deleter {}", (Object)documentDeleter.getName());
                    if (documentDeleter.isOneOf(deletionConf.getString("deleter"))) {
                        documentDeleter.configure((HierarchicalConfiguration<ImmutableNode>)deletionConf);
                        continue;
                    }
                    log.trace("Skipping the configuration of {} because it is not specified in the configuration.", (Object)documentDeleter.getName());
                }
            }
        } else {
            log.trace("No document deleters were specified in the configuration.");
        }
    }

    private void markFileAsImported(File file, DataBaseConnector dbc) throws MedlineUpdateException {
        try (CoStoSysConnection coStoSysConnection = dbc.obtainOrReserveConnection(true);){
            Connection conn = coStoSysConnection.getConnection();
            String sql = null;
            try {
                log.debug("Marking update file {} as imported.", (Object)file);
                sql = String.format("UPDATE %s SET %s = TRUE, %s = '" + new Timestamp(System.currentTimeMillis()) + "' WHERE %s = '%s'", UPDATE_TABLE, COLUMN_IS_IMPORTED, COLUMN_TIMESTAMP, COLUMN_FILENAME, file.getName());
                conn.createStatement().execute(sql);
                conn.commit();
            }
            catch (SQLException e) {
                log.error("SQL command was: {}", (Object)sql);
                throw new MedlineUpdateException(e);
            }
        }
    }
}

