/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.costosys.medline;

import de.julielab.costosys.dbconnection.CoStoSysConnection;
import de.julielab.costosys.dbconnection.DataBaseConnector;
import de.julielab.costosys.medline.DocumentDeletionException;
import de.julielab.costosys.medline.IDocumentDeleter;
import de.julielab.costosys.medline.MedlineUpdateException;
import de.julielab.costosys.medline.SimplePKDataTableDocumentDeleter;
import de.julielab.java.utilities.ConfigurationUtilities;
import de.julielab.java.utilities.FileUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMCUpdater {
    public static final String UPDATE_TABLE = "_data._pmc_update_files";
    public static final String COLUMN_FILENAME = "update_file_name";
    public static final String COLUMN_IS_IMPORTED = "is_imported";
    public static final String COLUMN_TIMESTAMP = "timestamp_of_import";
    private static final Logger log = LoggerFactory.getLogger(PMCUpdater.class);
    private final String[] pmcFileDirectories;
    private ServiceLoader<IDocumentDeleter> documentDeleterLoader;
    private HierarchicalConfiguration<ImmutableNode> configuration;

    public PMCUpdater(HierarchicalConfiguration<ImmutableNode> configuration) {
        this.configuration = configuration;
        this.pmcFileDirectories = configuration.getStringArray("directories.directory");
        this.documentDeleterLoader = ServiceLoader.load(IDocumentDeleter.class);
        log.info("Initialized PMC Updater with file directories {} and document deleters {}.", (Object)this.pmcFileDirectories, (Object)configuration.getStringArray(ConfigurationUtilities.dot("documentdeletions.deletion", "deleter")));
        log.debug("Loaded the following document deleters: {}", (Object)this.documentDeleterLoader.stream().map(d -> ((IDocumentDeleter)d.get()).getName()).collect(Collectors.joining(", ")));
    }

    private static List<File> getUnprocessedPMCUpdates(File[] updateFiles, DataBaseConnector dbc) throws MedlineUpdateException {
        ArrayList<File> unprocessedFiles = new ArrayList<File>();
        try (CoStoSysConnection coStoSysConnection = dbc.obtainOrReserveConnection(true);){
            Connection conn = coStoSysConnection.getConnection();
            Set<Object> updateFileNameSet = new HashSet<String>();
            for (File f : updateFiles) {
                updateFileNameSet.add(f.getName());
            }
            try {
                boolean baselineFilesPresent;
                Statement st = conn.createStatement();
                boolean exists = dbc.tableExists(UPDATE_TABLE);
                if (!exists) {
                    String createUpdateTable = String.format("CREATE TABLE %s (%s TEXT PRIMARY KEY,%s BOOLEAN DEFAULT FALSE,%s TIMESTAMP WITHOUT TIME ZONE)", UPDATE_TABLE, COLUMN_FILENAME, COLUMN_IS_IMPORTED, COLUMN_TIMESTAMP);
                    st.execute(createUpdateTable);
                }
                if (baselineFilesPresent = st.executeQuery("SELECT * FROM _data._pmc_update_files WHERE update_file_name LIKE '%baseline%' LIMIT 1").next()) {
                    log.info("Found baseline files in the update file tracking table _data._pmc_update_files. No new baseline files will be added to the table and, thus, not be imported into the database. If you need to import the baseline files into the database, delete all baseline rows from _data._pmc_update_files. If you want to import everything from scratch, you may truncate or drop _data._pmc_update_files altogether.");
                    updateFileNameSet = updateFileNameSet.stream().filter(filename -> !filename.contains("baseline")).collect(Collectors.toSet());
                }
                HashSet<String> filenamesInDBSet = new HashSet<String>();
                ResultSet rs = st.executeQuery(String.format("SELECT %s from %s", COLUMN_FILENAME, UPDATE_TABLE));
                while (rs.next()) {
                    String filename2 = rs.getString(COLUMN_FILENAME);
                    filenamesInDBSet.add(filename2);
                }
                updateFileNameSet.removeAll(filenamesInDBSet);
                conn.setAutoCommit(false);
                PreparedStatement ps = conn.prepareStatement(String.format("INSERT INTO %s VALUES (?)", UPDATE_TABLE));
                for (String string : updateFileNameSet) {
                    ps.setString(1, string);
                    ps.addBatch();
                }
                ps.executeBatch();
                conn.commit();
                conn.setAutoCommit(true);
                String sql = String.format("SELECT %s FROM %s WHERE %s = FALSE", COLUMN_FILENAME, UPDATE_TABLE, COLUMN_IS_IMPORTED);
                rs = st.executeQuery(sql);
                HashSet<String> hashSet = new HashSet<String>();
                while (rs.next()) {
                    hashSet.add(rs.getString(COLUMN_FILENAME));
                }
                for (File updateFile : updateFiles) {
                    if (!hashSet.contains(updateFile.getName())) continue;
                    unprocessedFiles.add(updateFile);
                }
            }
            catch (SQLException e) {
                throw new MedlineUpdateException(e);
            }
        }
        return unprocessedFiles;
    }

    private static List<String> getPmcidsToDelete(File file) {
        File tsvFile = new File(file.getAbsolutePath().replace(".tar.gz", "filelist.txt"));
        ArrayList<String> pmcidsToDelete = new ArrayList<String>();
        int pmcFilePathIndex = 0;
        int retractionIndex = 6;
        try (BufferedReader br = FileUtilities.getReaderFromFile(tsvFile);){
            br.lines().map(l -> l.split("\\t")).filter(s2 -> s2[retractionIndex].equalsIgnoreCase("yes")).map(s2 -> s2[pmcFilePathIndex]).map(path -> path.substring(path.indexOf(47) + 1)).map(filename -> filename.replace(".xml", "")).forEach(pmcidsToDelete::add);
        }
        catch (IOException e) {
            log.error("Could not process the {} file. No retracted documents will be removed.");
        }
        return pmcidsToDelete;
    }

    public void process(DataBaseConnector dbc, boolean ignoreAlreadyProcessed) throws MedlineUpdateException, IOException {
        if (ignoreAlreadyProcessed) {
            log.info("Ignoring update file processing state in the database and processing all files in the directories {}.", this.pmcFileDirectories);
        }
        this.configureDocumentDeleters();
        for (String directory : this.pmcFileDirectories) {
            log.info("Updating from {} into database at {}", (Object)directory, (Object)dbc.getDbURL());
            File[] pmcFiles = this.getPMCFiles(directory);
            if (pmcFiles == null || pmcFiles.length <= 0) continue;
            List<File> unprocessedPmcUpdates = ignoreAlreadyProcessed ? Arrays.asList(pmcFiles) : PMCUpdater.getUnprocessedPMCUpdates(pmcFiles, dbc);
            Collections.sort(unprocessedPmcUpdates, Comparator.comparing(File::getName, (n1, n2) -> {
                String baseline = "baseline";
                boolean n1ContainsBaseline = n1.contains(baseline);
                boolean n2ContainsBaseline = n2.contains(baseline);
                if (n1ContainsBaseline && !n2ContainsBaseline) {
                    return -1;
                }
                if (n2ContainsBaseline && !n1ContainsBaseline) {
                    return 1;
                }
                return 0;
            }).thenComparing(File::getName));
            Object[] configuredDeleters = this.configuration.getStringArray(ConfigurationUtilities.dot("documentdeletions.deletion", "deleter"));
            for (File file : unprocessedPmcUpdates) {
                log.info("Processing file {}.", (Object)file.getAbsoluteFile());
                dbc.updateFromXML(file.getAbsolutePath(), "_data._data", true);
                List<String> pmidsToDelete = Collections.emptyList();
                HashSet<IDocumentDeleter> appliedDeleters = new HashSet<IDocumentDeleter>();
                for (IDocumentDeleter documentDeleter : this.documentDeleterLoader) {
                    log.debug("Checking if deleter {} is part of the deleter configuration.", (Object)documentDeleter.getName());
                    if (!documentDeleter.isOneOf((String[])configuredDeleters)) {
                        log.debug("Skipping document deleter {}.", (Object)documentDeleter.getName());
                        continue;
                    }
                    log.debug("Applying document deleter {}.", (Object)documentDeleter.getName());
                    if (documentDeleter instanceof SimplePKDataTableDocumentDeleter) {
                        ((SimplePKDataTableDocumentDeleter)documentDeleter).setDbc(dbc);
                    }
                    documentDeleter.deleteDocuments(pmidsToDelete);
                    appliedDeleters.add(documentDeleter);
                }
                if (appliedDeleters.size() < configuredDeleters.length) {
                    throw new IllegalStateException("Not all document deleters could be applied. Configured deleters were " + Arrays.toString(configuredDeleters) + " but applied were only " + (appliedDeleters.isEmpty() ? "none" : appliedDeleters.stream().map(IDocumentDeleter::getName).collect(Collectors.joining(", "))));
                }
                this.markFileAsImported(file, dbc);
            }
        }
    }

    protected File[] getPMCFiles(String pathString) throws IOException {
        File pmcPath = new File(pathString);
        if (!pmcPath.exists()) {
            throw new FileNotFoundException("File \"" + pathString + "\" was not found.");
        }
        if (!pmcPath.isDirectory()) {
            return new File[]{pmcPath};
        }
        File[] pmcFiles = (File[])Files.walk(Path.of(pathString, new String[0]), FileVisitOption.FOLLOW_LINKS).filter(p -> p.toString().endsWith("gz") || p.toString().endsWith("gzip") || p.toString().endsWith("zip") || p.toString().endsWith("tgz") || p.toString().endsWith("tar.gz")).map(Path::toFile).toArray(File[]::new);
        if (pmcFiles == null || pmcFiles.length == 0) {
            log.info("No files in ZIP, GZIP or TGZ format found in directory {}. No update will be performed.", (Object)pathString);
        }
        return pmcFiles;
    }

    private void configureDocumentDeleters() throws DocumentDeletionException {
        log.trace("Configuring document deleters");
        if (this.configuration.containsKey(ConfigurationUtilities.dot("documentdeletions.deletion", "deleter"))) {
            List deletionConfigs = this.configuration.configurationsAt("documentdeletions.deletion");
            log.trace("Found {} deleter configurations.", (Object)deletionConfigs.size());
            for (HierarchicalConfiguration deletionConf : deletionConfigs) {
                for (IDocumentDeleter documentDeleter : this.documentDeleterLoader) {
                    log.trace("Configuring deleter {}", (Object)documentDeleter.getName());
                    if (documentDeleter.isOneOf(deletionConf.getString("deleter"))) {
                        documentDeleter.configure((HierarchicalConfiguration<ImmutableNode>)deletionConf);
                        continue;
                    }
                    log.trace("Skipping the configuration of {} because it is not specified in the configuration.", (Object)documentDeleter.getName());
                }
            }
        } else {
            log.trace("No document deleters were specified in the configuration.");
        }
    }

    private void markFileAsImported(File file, DataBaseConnector dbc) throws MedlineUpdateException {
        try (CoStoSysConnection coStoSysConnection = dbc.obtainOrReserveConnection(true);){
            Connection conn = coStoSysConnection.getConnection();
            String sql = null;
            try {
                log.debug("Marking update file {} as imported.", (Object)file);
                sql = String.format("UPDATE %s SET %s = TRUE, %s = '" + new Timestamp(System.currentTimeMillis()) + "' WHERE %s = '%s'", UPDATE_TABLE, COLUMN_IS_IMPORTED, COLUMN_TIMESTAMP, COLUMN_FILENAME, file.getName());
                conn.createStatement().execute(sql);
                conn.commit();
            }
            catch (SQLException e) {
                log.error("SQL command was: {}", (Object)sql);
                throw new MedlineUpdateException(e);
            }
        }
    }
}

