/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.costosys.dbconnection;

import de.julielab.costosys.dbconnection.DataBaseConnector;
import de.julielab.costosys.dbconnection.util.CoStoSysSQLRuntimeException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoStoSysConnection
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(CoStoSysConnection.class);
    private DataBaseConnector dbc;
    private Connection connection;
    private boolean shared;
    private AtomicInteger numUsing;
    private boolean isClosed;

    public CoStoSysConnection(DataBaseConnector dbc, Connection connection, boolean shared) {
        this.dbc = dbc;
        this.connection = connection;
        this.shared = shared;
        this.numUsing = new AtomicInteger(1);
        this.isClosed = false;
        log.trace("Initial usage: Connection {} is now used {} times by thread {}", connection, this.numUsing.get(), Thread.currentThread().getName());
    }

    public boolean isShared() {
        return this.shared;
    }

    public int getUsageNumber() {
        return this.numUsing.get();
    }

    public boolean incrementUsageNumber() {
        int currentUsage = this.numUsing.incrementAndGet();
        return true;
    }

    private void decreaseUsageCounter() {
        this.numUsing.decrementAndGet();
    }

    public Connection getConnection() {
        return this.connection;
    }

    private String getCaller() {
        StackWalker walker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        String walk = walker.walk(frames -> frames.map(f -> f.getClassName() + "#" + f.getMethodName()).limit(3L).collect(Collectors.joining(", ")));
        return walk;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void close() {
        this.decreaseUsageCounter();
        if (this.numUsing.get() <= 0) {
            try {
                if (!this.connection.isClosed()) {
                    this.connection.close();
                }
            }
            catch (SQLException e) {
                throw new CoStoSysSQLRuntimeException(e);
            }
            this.isClosed = true;
        }
    }

    public Statement createStatement() throws SQLException {
        return this.connection.createStatement();
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.connection.prepareStatement(sql);
    }

    public void commit() throws SQLException {
        this.connection.commit();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.getMetaData();
    }

    public boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    public void setAutoCommit(boolean b) throws SQLException {
        this.connection.setAutoCommit(b);
    }
}

