/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.costosys.cli;

import de.julielab.costosys.dbconnection.CoStoSysConnection;
import de.julielab.costosys.dbconnection.DataBaseConnector;
import de.julielab.java.utilities.FileUtilities;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmiColumnDataInserter {
    private static final Logger log = LoggerFactory.getLogger(XmiColumnDataInserter.class);
    private static final int BATCH_SIZE = 50;
    private static final String PMA_START = "<PubmedArticle>";
    private static final String PMA_END = "</PubmedArticle>";
    private static final String CSTS_PK_START = "<CoStoSysPrimaryKey>";
    private static final String CSTS_PK_END = "</CoStoSysPrimaryKey>";
    private static final Pattern PK_PATTERN = Pattern.compile("<CoStoSysPrimaryKey>([^<]+)</CoStoSysPrimaryKey>");
    private static final Pattern XMI_DATA_TAG_PATTERN = Pattern.compile("</?xmidata>");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertXmiColumnData(Path xmiColumnData, String superTable, String columnName, DataBaseConnector dbc) throws Exception {
        ExecutorService executorService = Executors.newFixedThreadPool(6);
        try (CoStoSysConnection costoConn = dbc.obtainOrReserveConnection();){
            costoConn.setAutoCommit(false);
            int processedDocuments = 0;
            ArrayList batch = new ArrayList(50);
            try (BufferedReader bw = FileUtilities.getReaderFromFile(xmiColumnData.toFile());){
                String line;
                Map<String, String> field = dbc.getActiveTableFieldConfiguration().getField(columnName);
                if (field == null) {
                    throw new IllegalArgumentException("The active table configuration does not contain a field named '" + columnName + "'.");
                }
                boolean isXmlField = field.get("type").equals("xml");
                String pkFieldName = dbc.getActiveTableFieldConfiguration().getPrimaryKeyString();
                String updateSql = "UPDATE " + superTable + " SET " + columnName + "=" + (isXmlField ? "XMLPARSE(CONTENT ?)" : "?") + " WHERE " + pkFieldName + "=?";
                PreparedStatement ps = costoConn.prepareStatement(updateSql);
                boolean doGzip = Boolean.parseBoolean(dbc.getActiveTableFieldConfiguration().getField(columnName).get("gzip"));
                StringBuffer currentDocument = new StringBuffer();
                boolean inArticle = false;
                int currentBatchSize = 0;
                int linesRead = 0;
                while ((line = bw.readLine()) != null) {
                    if (++linesRead % 1000000 == 0) {
                        log.debug("Read {} lines from the input file.", (Object)linesRead);
                    }
                    if (line.equals(PMA_START)) {
                        inArticle = true;
                        continue;
                    }
                    if (line.equals(PMA_END)) {
                        String docString = currentDocument.toString();
                        currentDocument.setLength(0);
                        executorService.submit(() -> {
                            try {
                                this.addCurrentDocumentToBatch(docString, batch, doGzip);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        });
                        ++currentBatchSize;
                        ArrayList arrayList2 = batch;
                        synchronized (arrayList2) {
                            if (batch.size() >= 50) {
                                for (Object[] s2 : batch) {
                                    ps.setObject(1, s2[0]);
                                    ps.setObject(2, s2[1]);
                                    ps.addBatch();
                                }
                                batch.clear();
                                ps.executeBatch();
                                currentBatchSize = 0;
                            }
                        }
                        inArticle = false;
                        ++processedDocuments;
                        continue;
                    }
                    if (!inArticle) continue;
                    currentDocument.append(line);
                }
                executorService.shutdown();
                executorService.awaitTermination(10L, TimeUnit.MINUTES);
                ArrayList arrayList3 = batch;
                synchronized (arrayList3) {
                    if (batch.size() > 0) {
                        log.info("Sending last, incomplete batch with annotations for {} documents to database", (Object)batch.size());
                        for (Object[] s3 : batch) {
                            ps.setObject(1, s3[0]);
                            ps.setObject(2, s3[1]);
                            ps.addBatch();
                        }
                        ps.executeBatch();
                    }
                }
            }
            costoConn.commit();
            log.info("Updated XMI data for {} documents.", (Object)processedDocuments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCurrentDocumentToBatch(String docString, List<Object[]> batch, boolean doGzip) throws Exception {
        Object columnDataToInsert;
        Matcher pkMatcher = PK_PATTERN.matcher(docString);
        if (!pkMatcher.find()) {
            throw new IllegalArgumentException("Input data does not match the required input format. The document ID - that should be enclosed in the tags '<CoStoSysPrimaryKey>' and '</CoStoSysPrimaryKey>' - could not be found.");
        }
        String docId = pkMatcher.group(1);
        String xmiDataWithoutPKElement = pkMatcher.replaceFirst("");
        String pureXmiData = XMI_DATA_TAG_PATTERN.matcher(xmiDataWithoutPKElement).replaceAll("");
        if (doGzip) {
            ByteArrayInputStream bais = new ByteArrayInputStream(pureXmiData.getBytes(StandardCharsets.UTF_8));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (GZIPOutputStream gos = new GZIPOutputStream(baos);){
                this.copyInputStream(bais, gos);
            }
            columnDataToInsert = baos.toByteArray();
        } else {
            columnDataToInsert = pureXmiData;
        }
        List<Object[]> list = batch;
        synchronized (list) {
            batch.add(new Object[]{columnDataToInsert, docId});
        }
    }

    private void copyInputStream(InputStream bais, OutputStream gos) throws IOException {
        int n;
        byte[] b = new byte[4096];
        while ((n = bais.read(b)) != -1) {
            gos.write(b, 0, n);
        }
    }
}

