/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.costosys.cli;

import de.julielab.costosys.cli.BinaryDataHandler;
import de.julielab.costosys.cli.CliOptionsProvider;
import de.julielab.costosys.cli.ConfigurationNotFoundException;
import de.julielab.costosys.cli.QueryOptions;
import de.julielab.costosys.cli.QueryPubMed;
import de.julielab.costosys.cli.TableNotFoundException;
import de.julielab.costosys.cli.XmiColumnDataInserter;
import de.julielab.costosys.configuration.TableSchemaDoesNotExistException;
import de.julielab.costosys.dbconnection.CoStoSysConnection;
import de.julielab.costosys.dbconnection.DBCIterator;
import de.julielab.costosys.dbconnection.DataBaseConnector;
import de.julielab.costosys.dbconnection.SubsetStatus;
import de.julielab.costosys.dbconnection.util.CoStoSysException;
import de.julielab.costosys.dbconnection.util.CoStoSysRuntimeException;
import de.julielab.costosys.medline.PMCUpdater;
import de.julielab.costosys.medline.PubmedUpdater;
import de.julielab.java.utilities.CLIInteractionUtilities;
import de.julielab.java.utilities.FileUtilities;
import de.julielab.java.utilities.IOStreamUtilities;
import de.julielab.xml.JulieXMLTools;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CLI {
    private static final String DELIMITER = "\n--------------------------------------------------------------------------------\n";
    private static final Logger LOG = LoggerFactory.getLogger(CLI.class);
    private static final String KEY_PART_SEPERATOR = "\t";
    private static final String FILE_SEPERATOR = System.getProperty("file.separator");
    public static String[] USER_SCHEME_DEFINITION = new String[]{"dbcconfiguration.xml", "costosys.xml", "costosysconfiguration.xml"};
    private static boolean verbose = false;

    private static void logMessage(String msg) {
        if (!verbose) {
            return;
        }
        LOG.info(msg);
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) throws Exception {
        time = System.currentTimeMillis();
        updateMode = false;
        mode = Mode.ERROR;
        options = CliOptionsProvider.getOptions();
        parser = new DefaultParser();
        try {
            cmd = parser.parse(options, args);
            CLI.verbose = cmd.hasOption('v');
            if (CLI.verbose) {
                CLI.LOG.info("Verbose logging enabled.");
            }
            if (cmd.hasOption("i")) {
                mode = Mode.IMPORT;
            }
            if (cmd.hasOption("u")) {
                mode = Mode.IMPORT;
                updateMode = true;
            }
            if (cmd.hasOption("q")) {
                mode = Mode.QUERY;
            }
            if (cmd.getOptionValue("s") != null) {
                mode = Mode.SUBSET;
            }
            if (cmd.getOptionValue("re") != null) {
                mode = Mode.RESET;
            }
            if (cmd.getOptionValue("st") != null) {
                mode = Mode.STATUS;
            }
            if (cmd.hasOption("t")) {
                mode = Mode.TABLES;
            }
            if (cmd.hasOption("lts")) {
                mode = Mode.LIST_TABLE_SCHEMAS;
            }
            if (cmd.hasOption("td")) {
                mode = Mode.TABLE_DEFINITION;
            }
            if (cmd.hasOption("sch")) {
                mode = Mode.SCHEME;
            }
            if (cmd.hasOption("ch")) {
                mode = Mode.CHECK;
            }
            if (cmd.hasOption("dc")) {
                mode = Mode.DEFAULT_CONFIG;
            }
            if (cmd.hasOption("dt")) {
                mode = Mode.DROP_TABLE;
            }
            if (cmd.hasOption("im")) {
                mode = Mode.IMPORT_UPDATE_MEDLINE;
            }
            if (cmd.hasOption("ip")) {
                mode = Mode.IMPORT_UPDATE_PMC;
            }
            if (cmd.hasOption("mp")) {
                mode = Mode.MARK_PROCESSED;
            }
            if (cmd.hasOption("vn")) {
                mode = Mode.PRINT_VERSION;
            }
            if (cmd.hasOption("dr")) {
                mode = Mode.DELETE_ROWS;
            }
            if (cmd.hasOption("ux")) {
                mode = Mode.UPDATE_XMI;
            }
            if (mode == Mode.PRINT_VERSION) {
                CLI.printVersion();
                return;
            }
            dbcConfigPath = null;
            if (cmd.hasOption("dbc")) {
                dbcConfigPath = cmd.getOptionValue("dbc");
            }
            if (dbcConfigPath == null) {
                dbcConfigPath = CLI.findConfigurationFile();
            }
            conf = new File(dbcConfigPath);
            dbUrl = cmd.getOptionValue('U');
            if (dbUrl == null) {
                msg = "No database URL given. Using value in configuration file";
                CLI.logMessage(msg);
            }
            if ((user = cmd.getOptionValue("n")) == null) {
                msg = "No database username given. Using value in configuration file";
                CLI.logMessage(msg);
            }
            if ((password = cmd.getOptionValue("p")) == null) {
                msg = "No password given. Using value in configuration file";
                CLI.logMessage(msg);
            }
            serverName = cmd.getOptionValue("srv");
            dbName = cmd.getOptionValue("db");
            pgSchema = cmd.getOptionValue("pgs");
            if (!((serverName != null && dbName != null) ^ dbUrl != null || serverName == null && dbName == null && dbUrl == null || conf.exists())) {
                errorMsg = "No base configuration has been found. Thus, you must specify server name and database name or the complete URL with -u (but not both).";
                CLI.LOG.error("No base configuration has been found. Thus, you must specify server name and database name or the complete URL with -u (but not both).");
                throw new IllegalArgumentException("No base configuration has been found. Thus, you must specify server name and database name or the complete URL with -u (but not both).");
            }
            dbc = null;
            try {
                if (conf.exists()) {
                    CLI.logMessage(String.format("Using configuration file at %s", new Object[]{conf}));
                    dbc = dbUrl == null ? new DataBaseConnector(serverName, dbName, user, password, pgSchema, (InputStream)new FileInputStream(conf)) : new DataBaseConnector(dbUrl, user, password, pgSchema, new FileInputStream(conf));
                } else {
                    CLI.logMessage(String.format("No custom configuration found (should be located at %s). Using default configuration.", new Object[]{Stream.of(CLI.USER_SCHEME_DEFINITION).collect(Collectors.joining(" or "))}));
                    dbc = dbUrl == null ? new DataBaseConnector(serverName, dbName, user, password, pgSchema, null) : new DataBaseConnector(dbUrl, user, password, pgSchema, null);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            tableName = cmd.getOptionValue("td");
            if (tableName == null) {
                tableName = cmd.getOptionValue("ch");
            }
            if ((subsetTableName = cmd.getOptionValue("s")) == null) {
                subsetTableName = cmd.getOptionValue("re");
            }
            if (subsetTableName == null) {
                subsetTableName = cmd.getOptionValue("renp");
            }
            if (subsetTableName == null) {
                subsetTableName = cmd.getOptionValue("st");
            }
            if ((fileStr = cmd.getOptionValue("f")) == null) {
                fileStr = cmd.getOptionValue("i");
            }
            if (fileStr == null) {
                fileStr = cmd.getOptionValue("u");
            }
            if ((superTableName = cmd.getOptionValue("z")) == null) {
                superTableName = dbc.getActiveDataTable();
            }
            queryStr = cmd.getOptionValue("q");
            subsetJournalFileName = cmd.getOptionValue("j");
            subsetQuery = cmd.getOptionValue("o");
            randomSubsetSize = cmd.getOptionValue("r");
            whereClause = cmd.getOptionValue("w");
            xpath = cmd.getOptionValue("x");
            baseOutDir = cmd.getOptionValue("out");
            batchSize = cmd.getOptionValue("bs");
            limit = cmd.getOptionValue("l");
            tableSchema = cmd.getOptionValue("ts") != null ? cmd.getOptionValue("ts") : dbc.getActiveTableSchema();
            useDelimiter = baseOutDir != null ? false : cmd.hasOption("d");
            returnPubmedArticleSet = cmd.hasOption("pas");
            mirrorSubset = cmd.hasOption("m");
            all4Subset = cmd.hasOption("a");
            numberRefHops = cmd.hasOption("rh") != false ? Integer.valueOf(Integer.parseInt(cmd.getOptionValue("rh"))) : null;
            copyProcessed = cmd.getOptionValue("cp");
            if (tableSchema.matches("[0-9]+")) {
                tableSchema = dbc.getConfig().getTableSchemaNames().get(Integer.parseInt(tableSchema));
            }
            dbc.setActiveTableSchema(tableSchema);
            ignored = dbc.obtainOrReserveConnection(true);
            try {
                switch (1.$SwitchMap$de$julielab$costosys$cli$CLI$Mode[mode.ordinal()]) {
                    case 1: {
                        qo = new QueryOptions();
                        qo.fileStr = fileStr;
                        qo.queryStr = queryStr;
                        qo.useDelimiter = useDelimiter;
                        qo.pubmedArticleSet = returnPubmedArticleSet;
                        qo.xpath = xpath;
                        qo.baseOutDirStr = baseOutDir;
                        qo.batchSizeStr = batchSize;
                        qo.limitStr = limit;
                        qo.tableName = superTableName;
                        qo.tableSchema = tableSchema;
                        qo.whereClause = whereClause;
                        qo.numberRefHops = numberRefHops;
                        CLI.doQuery(dbc, qo);
                        ** break;
lbl141:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        CLI.doImportOrUpdate(dbc, fileStr, superTableName, updateMode);
                        ** break;
lbl146:
                        // 1 sources

                        break;
                    }
                    case 3: {
                        CLI.doSubset(dbc, subsetTableName, fileStr, queryStr, superTableName, subsetJournalFileName, subsetQuery, mirrorSubset, whereClause, all4Subset, randomSubsetSize, numberRefHops, copyProcessed);
                        ** break;
lbl151:
                        // 1 sources

                        break;
                    }
                    case 4: {
                        if (subsetTableName == null) {
                            CLI.LOG.error("You must provide the name of the subset table to reset.");
                            ** break;
lbl156:
                            // 1 sources

                            break;
                        }
                        files = cmd.hasOption("f");
                        try {
                            doReset = true;
                            if (!files || StringUtils.isBlank(fileStr)) {
                                np = cmd.hasOption("np");
                                ne = cmd.hasOption("ne");
                                v0 = lc = cmd.hasOption("lc") != false ? cmd.getOptionValue("lc") : null;
                                if (np) {
                                    CLI.logMessage("table reset is restricted to non-processed table rows");
                                }
                                if (ne) {
                                    CLI.logMessage("table reset is restricted to table row without errors");
                                }
                                if (lc != null) {
                                    CLI.logMessage("table reset is restricted to rows with last component " + lc);
                                }
                                if (!np && !ne && lc == null) {
                                    status = dbc.status(subsetTableName, EnumSet.of(DataBaseConnector.StatusElement.IN_PROCESS, DataBaseConnector.StatusElement.IS_PROCESSED, DataBaseConnector.StatusElement.TOTAL));
                                    inProcess = status.inProcess;
                                    isProcessed = status.isProcessed;
                                    total = status.total;
                                    if (total > 10000L && inProcess + isProcessed >= total / 2L && !"yes".equals(input = CLI.getYesNoAnswer("The subset table \"" + subsetTableName + "\" is in process or already processed over 50%. Do you really wish to reset it completely into an unprocessed state? (yes/no)"))) {
                                        doReset = false;
                                    }
                                }
                                if (doReset) {
                                    dbc.resetSubset(subsetTableName, np, ne, lc);
                                    ** break;
                                }
lbl180:
                                // 3 sources

                                break;
                            }
                            CLI.logMessage("Resetting all documents identified by the IDs in file \"" + fileStr + "\".");
                            try {
                                pkValues = CLI.convertFileToPrimaryKeyList(fileStr);
                                dbc.resetSubset(subsetTableName, pkValues);
                                ** break;
lbl186:
                                // 1 sources

                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                ** break;
lbl190:
                                // 1 sources

                            }
                        }
                        catch (TableNotFoundException e) {
                            e.printStackTrace();
                            ** break;
                        }
lbl194:
                        // 1 sources

                        break;
                    }
                    case 5: {
                        CLI.doStatus(dbc, subsetTableName, cmd.hasOption("he"), cmd.hasOption("isp"), cmd.hasOption("inp"), cmd.hasOption("to"), cmd.hasOption("lc"));
                        ** break;
lbl199:
                        // 1 sources

                        break;
                    }
                    case 6: {
                        for (String s : dbc.getTables()) {
                            System.out.println(s);
                        }
                        break;
                    }
                    case 7: {
                        for (String s : dbc.getTableDefinition(tableName)) {
                            System.out.println(s);
                        }
                        break;
                    }
                    case 8: {
                        System.out.println("The following table schema names are contained in the current configuration:\n");
                        tableSchemaNames = dbc.getConfig().getTableSchemaNames();
                        IntStream.range(0, tableSchemaNames.size()).mapToObj((IntFunction<String>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$main$0(java.util.List int ), (I)Ljava/lang/String;)(tableSchemaNames)).forEach((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, println(java.lang.String ), (Ljava/lang/String;)V)((PrintStream)System.out));
                        ** break;
lbl218:
                        // 1 sources

                        break;
                    }
                    case 9: {
                        System.out.println(dbc.getScheme());
                        ** break;
lbl222:
                        // 1 sources

                        break;
                    }
                    case 10: {
                        dbc.checkTableDefinition(tableName);
                        ** break;
lbl226:
                        // 1 sources

                        break;
                    }
                    case 11: {
                        System.out.println(new String(dbc.getEffectiveConfiguration()));
                        ** break;
lbl230:
                        // 1 sources

                        break;
                    }
                    case 12: {
                        CLI.dropTableInteractively(dbc, cmd.getOptionValue("dt"));
                        ** break;
lbl234:
                        // 1 sources

                        break;
                    }
                    case 13: {
                        medlineUpdateConfigFile = cmd.getOptionValue("im");
                        updater = new PubmedUpdater((HierarchicalConfiguration<ImmutableNode>)CLI.loadXmlConfiguration(new File(medlineUpdateConfigFile)));
                        CLI.createDataTableWithComment(dbc, superTableName, "Created on " + new Date() + " by CoSoSys with MEDLINE update configuration " + medlineUpdateConfigFile);
                        updater.process(dbc, cmd.hasOption("iap"));
                        ** break;
lbl242:
                        // 1 sources

                        break;
                    }
                    case 14: {
                        pmcUpdateConfigFile = cmd.getOptionValue("ip");
                        pmcUpdater = new PMCUpdater((HierarchicalConfiguration<ImmutableNode>)CLI.loadXmlConfiguration(new File(cmd.getOptionValue("ip"))));
                        CLI.createDataTableWithComment(dbc, superTableName, "Created on " + new Date() + " by CoSoSys with PMC update configuration " + pmcUpdateConfigFile);
                        pmcUpdater.process(dbc, cmd.hasOption("iap"));
                        ** break;
lbl250:
                        // 1 sources

                        break;
                    }
                    case 15: {
                        CLI.setProcessed(dbc, cmd.getOptionValue("mp"), fileStr);
                        ** break;
lbl254:
                        // 1 sources

                        break;
                    }
                    case 16: {
                        idFilePath = Path.of(cmd.getOptionValue("dr"), new String[0]);
                        CLI.deleteRows(dbc, idFilePath, superTableName);
                        ** break;
lbl259:
                        // 1 sources

                        break;
                    }
                    case 17: {
                        xmiColumnDataInserter = new XmiColumnDataInserter();
                        xmiColumnDataInserter.insertXmiColumnData(Path.of(fileStr, new String[0]), superTableName, cmd.getOptionValue("ux"), dbc);
                        ** break;
lbl264:
                        // 1 sources

                        break;
                    }
                    ** default:
lbl266:
                    // 1 sources

                    break;
                }
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
            time = System.currentTimeMillis() - time;
            CLI.LOG.info(String.format("Processing took %d seconds.", new Object[]{time / 1000L}));
        }
        catch (ParseException e) {
            CLI.LOG.error("Can't parse arguments: " + e.getMessage());
            CLI.printHelp(options);
        }
    }

    private static void deleteRows(DataBaseConnector dbc, Path idFilePath, String superTableName) throws IOException {
        List<String> ids = Files.readAllLines(idFilePath, StandardCharsets.UTF_8);
        LOG.info("Deleting {} rows from {}.", (Object)ids.size(), (Object)superTableName);
        dbc.deleteFromTableSimplePK(superTableName, ids);
    }

    private static void printVersion() throws IOException {
        try (InputStream versionFileStream = CLI.class.getResourceAsStream("/version.txt");){
            String version2 = IOStreamUtilities.getStringFromInputStream(versionFileStream).trim();
            System.out.println(version2);
        }
    }

    private static void setProcessed(DataBaseConnector dbc, String subsetTable, String fileStr) throws IOException {
        if (!dbc.tableExists(subsetTable)) {
            LOG.error("The subset table {} does not exist.", (Object)subsetTable);
            return;
        }
        if (fileStr != null) {
            File idsFile = new File(fileStr);
            if (!idsFile.exists()) {
                LOG.error("The ID list file {} does not exist.", (Object)fileStr);
                return;
            }
            List<Object[]> primaryKeys = CLI.convertFileToPrimaryKeyList(fileStr);
            dbc.markAsProcessed(subsetTable, primaryKeys);
        } else {
            dbc.markAsProcessed(subsetTable);
        }
    }

    public static String findConfigurationFile() throws ConfigurationNotFoundException {
        String configFileProperty = System.getProperty("costosys.configurationfile");
        if (configFileProperty != null && new File(configFileProperty).exists()) {
            return configFileProperty;
        }
        File workingDirectory = new File(".");
        HashSet<String> possibleConfigFileNames = new HashSet<String>(Arrays.asList(USER_SCHEME_DEFINITION));
        for (String file : workingDirectory.list()) {
            if (!possibleConfigFileNames.contains(file.toLowerCase())) continue;
            return file;
        }
        throw new ConfigurationNotFoundException("No configuration file with a name in " + Arrays.toString(USER_SCHEME_DEFINITION) + " was found in the current working directory " + new File(".").getAbsolutePath());
    }

    private static void dropTableInteractively(DataBaseConnector dbc, String tableName) {
        try {
            if (!dbc.tableExists(tableName)) {
                if (tableName.contains(".")) {
                    System.err.println("Table \"" + tableName + "\" does not exist in database " + dbc.getDbURL() + ".");
                } else {
                    System.err.println("Table \"" + tableName + "\" does not exist in database " + dbc.getDbURL() + " in active schema " + dbc.getActivePGSchema() + ".");
                }
                return;
            }
            String unqualifiedTableName = tableName.contains(".") ? tableName.substring(tableName.indexOf(".") + 1) : tableName;
            String schema = tableName.contains(".") ? tableName.substring(0, tableName.indexOf(".")) : dbc.getActivePGSchema();
            System.out.println("Found table \"" + unqualifiedTableName + "\" in schema " + schema + " in database " + dbc.getDbURL() + ". Do you really want to drop it (y/n)?");
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            String response = in.readLine().toLowerCase();
            while (!("y".equals(response) || "yes".equals(response) || "n".equals(response) || "no".equals("no"))) {
                System.out.println("Please specify y(es) or n(o).");
                response = in.readLine().toLowerCase();
            }
            if (response.startsWith("y")) {
                System.out.println("Dropping table \"" + unqualifiedTableName + "\" in Postgres schema \"" + schema + "\" of database " + dbc.getDbURL());
                dbc.dropTable(String.join((CharSequence)".", schema, unqualifiedTableName));
                List<String> tablesInSchema = dbc.getTables();
                if (tablesInSchema.isEmpty() && CLIInteractionUtilities.readYesNoFromStdInWithMessage("Postgres schema " + dbc.getActivePGSchema() + " is now empty. Should it be removed?", false)) {
                    if (dbc.dropSchema(dbc.getActivePGSchema())) {
                        System.out.println("Schema " + dbc.getActivePGSchema() + " was successfully dropped.");
                    } else {
                        System.err.println("Schema " + dbc.getActivePGSchema() + " could not be dropped.");
                    }
                }
            } else {
                System.out.println("User canceled. Aborting process.");
            }
        }
        catch (IOException | SQLException e) {
            e.printStackTrace();
        }
    }

    private static String getYesNoAnswer(String question) {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String input = "";
        try {
            while (!input.equals("yes") && !input.equals("no")) {
                System.out.println(question);
                input = br.readLine();
            }
        }
        catch (IOException e) {
            LOG.error("Something went wrong while reading from STDIN: ", e);
        }
        return input;
    }

    private static boolean doStatus(DataBaseConnector dbc, String subsetTableName, boolean showHasErrors, boolean showIsProcessed, boolean showIsInProcess, boolean showTotal, boolean showLastComponent) {
        boolean error;
        block16: {
            error = false;
            try {
                if (subsetTableName == null) {
                    LOG.error("You must provide the name of a subset table to display its status.");
                    error = true;
                    break block16;
                }
                EnumSet<DataBaseConnector.StatusElement> modes = EnumSet.noneOf(DataBaseConnector.StatusElement.class);
                if (showHasErrors) {
                    modes.add(DataBaseConnector.StatusElement.HAS_ERRORS);
                }
                if (showIsProcessed) {
                    modes.add(DataBaseConnector.StatusElement.IS_PROCESSED);
                }
                if (showIsInProcess) {
                    modes.add(DataBaseConnector.StatusElement.IN_PROCESS);
                }
                if (showTotal) {
                    modes.add(DataBaseConnector.StatusElement.TOTAL);
                }
                if (showLastComponent) {
                    modes.add(DataBaseConnector.StatusElement.LAST_COMPONENT);
                }
                if (modes.isEmpty()) {
                    modes = EnumSet.allOf(DataBaseConnector.StatusElement.class);
                }
                try (CoStoSysConnection ignored = dbc.obtainOrReserveConnection(true);){
                    SubsetStatus status = dbc.status(subsetTableName, modes);
                    System.out.println(status);
                }
            }
            catch (TableSchemaDoesNotExistException e) {
                LOG.error(e.getMessage());
                error = true;
            }
            catch (TableNotFoundException e) {
                LOG.error(e.getMessage());
                e.printStackTrace();
            }
        }
        return error;
    }

    private static boolean doSubset(DataBaseConnector dbc, String subsetTableName, String fileStr, String queryStr, String superTableName, String subsetJournalFileName, String subsetQuery, boolean mirrorSubset, String whereClause, boolean all4Subset, String randomSubsetSize, Integer numberRefHops, String copyProcessed) throws SQLException, CoStoSysException {
        Object comment = "<no comment given>";
        ArrayList<String> ids = null;
        List<Object> processedIds = Collections.emptyList();
        String condition = null;
        boolean error = CLI.checkSchema(dbc, subsetTableName);
        if (!error) {
            if (copyProcessed != null && !copyProcessed.isBlank()) {
                LOG.info("Retrieving rows marked as processed from subset table {}", (Object)copyProcessed);
                processedIds = dbc.getProcessedPrimaryKeys(copyProcessed);
                LOG.info("Retrieved {} processed primary keys", (Object)processedIds.size());
            }
            if (subsetJournalFileName != null) {
                try {
                    ids = CLI.asList(subsetJournalFileName);
                }
                catch (IOException e) {
                    throw new CoStoSysRuntimeException(e);
                }
                if (ids.size() == 0) {
                    LOG.error(subsetJournalFileName + " is empty.");
                    error = true;
                }
                StringBuilder sb = new StringBuilder();
                for (String id : ids) {
                    sb.append(", ").append(id);
                }
                condition = "nlm_id";
                comment = "Subset created " + new Date().toString() + " by matching with " + superTableName + " on " + condition + ": " + sb.substring(2);
            } else if (subsetQuery != null) {
                CLI.logMessage("Querying PubMed for: " + subsetQuery);
                ids = QueryPubMed.query(subsetQuery);
                if (ids.size() == 0) {
                    LOG.error("No results for your query.");
                    error = true;
                } else {
                    LOG.info("PubMed delivered " + ids.size() + " results.");
                }
                condition = "pmid";
                comment = "Subset created " + new Date().toString() + " by matching with " + superTableName + " on PubMed-query: " + subsetQuery;
            } else if (all4Subset) {
                CLI.logMessage("Creating subset by matching all entries from table " + superTableName + ".");
                comment = "Subset created " + new Date().toString() + " by matching with " + superTableName;
            } else if (whereClause != null) {
                comment = "Subset created " + new Date().toString() + " by selecting rows from " + superTableName + " with where clause \"" + whereClause + "\"";
            } else if (randomSubsetSize != null) {
                try {
                    Integer.valueOf(randomSubsetSize);
                    comment = "Subset created " + new Date().toString() + " by randomly selecting " + randomSubsetSize + " rows from " + superTableName + ".";
                }
                catch (NumberFormatException e) {
                    LOG.error(randomSubsetSize + " is not a number!");
                    error = true;
                }
            } else if (fileStr != null) {
                try {
                    ids = CLI.asList(fileStr);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (ids.size() == 0) {
                    LOG.error(fileStr + " is empty.");
                    throw new CoStoSysException(fileStr + " is empty.");
                }
                condition = dbc.getFieldConfiguration(dbc.getActiveTableSchema()).getPrimaryKey()[0];
                comment = "Subset created " + new Date().toString() + " by matching with " + superTableName + " on " + ids.size() + " " + condition + "s;";
            } else if (mirrorSubset) {
                comment = "Subset created " + new Date().toString() + " as to mirror " + superTableName + ";";
            } else {
                LOG.error("You must choose a way to define the subset.");
                error = true;
            }
            comment = CLI.escapeSingleQuotes((String)comment);
        }
        if (!dbc.withConnectionQueryBoolean(c -> dbc.tableExists(superTableName))) {
            CLI.logMessage("Checking whether super table " + superTableName + " exists...");
            LOG.error("Table " + superTableName + " doesn't exist!");
            error = true;
        }
        if (!error) {
            try (CoStoSysConnection ignored = dbc.obtainOrReserveConnection(true);){
                if (!dbc.tableExists(subsetTableName)) {
                    CLI.logMessage("No table with the name \"" + subsetTableName + "\" exists, creating new subset table...");
                    dbc.createSubsetTable(subsetTableName, superTableName, numberRefHops, (String)comment);
                    CLI.logMessage("Created table " + subsetTableName);
                } else {
                    LOG.error("Table " + subsetTableName + " allready exists.");
                    error = true;
                }
                if (dbc.isEmpty(subsetTableName) && !error) {
                    if (all4Subset) {
                        dbc.initSubset(subsetTableName, superTableName);
                    } else if (whereClause != null) {
                        dbc.initSubsetWithWhereClause(subsetTableName, superTableName, whereClause);
                    } else if (ids != null && ids.size() > 0) {
                        dbc.initSubset(ids, subsetTableName, superTableName, condition);
                    } else if (mirrorSubset) {
                        dbc.initMirrorSubset(subsetTableName, superTableName, true);
                    } else if (randomSubsetSize != null) {
                        dbc.initRandomSubset(new Integer(randomSubsetSize), subsetTableName, superTableName);
                    }
                    CLI.logMessage("Subset defined.");
                } else {
                    LOG.error(subsetTableName + " is not empty, please use another table.");
                    error = true;
                }
            }
        }
        if (!error && !processedIds.isEmpty()) {
            LOG.info("Marking {} rows as processed in the new subset table {}", (Object)processedIds.size(), (Object)subsetTableName);
            int numSuccessful = dbc.markAsProcessed(subsetTableName, processedIds);
            LOG.info("{} rows were successfully marked as processed in {}.", (Object)numSuccessful, (Object)subsetTableName);
        }
        return error;
    }

    private static boolean doImportOrUpdate(DataBaseConnector dbc, String fileStr, String superTableName, boolean updateMode) {
        boolean error = false;
        if (fileStr != null) {
            String comment = "Data table created " + new Date() + " by importing data from path " + fileStr;
            error = CLI.createDataTableWithComment(dbc, superTableName, comment);
            if (dbc.withConnectionQueryBoolean(c -> c.isEmpty(superTableName)) && !updateMode) {
                dbc.withConnectionExecute(c -> c.importFromXMLFile(fileStr, superTableName));
            } else {
                CLI.logMessage("Table is not empty or update mode was explicitly specified, processing Updates.");
                dbc.withConnectionExecute(c -> c.updateFromXML(fileStr, superTableName, true));
                CLI.logMessage("Updates finished.");
            }
        } else {
            LOG.error("You must specify a file or directory to retrieve XML files from.");
            error = true;
        }
        return error;
    }

    private static boolean createDataTableWithComment(DataBaseConnector dbc, String superTableName, String comment) {
        boolean error = false;
        if (!dbc.withConnectionQueryBoolean(c -> c.tableExists(superTableName)) && !(error = CLI.checkSchema(dbc, superTableName))) {
            dbc.withConnectionExecute(c -> c.createTable(superTableName, comment));
            CLI.logMessage("Created table " + superTableName);
        }
        return error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doQuery(DataBaseConnector dbc, QueryOptions qo) {
        boolean createDirectory;
        boolean error = false;
        String queryStr = qo.queryStr;
        String fileStr = qo.fileStr;
        String tableName = qo.tableName;
        String tableSchema = qo.tableSchema;
        boolean useDelimiter = qo.useDelimiter;
        boolean pubmedArticleSet = qo.pubmedArticleSet;
        String xpath = qo.xpath;
        String baseOutFile = qo.baseOutDirStr;
        String batchSizeStr = qo.batchSizeStr;
        String limitStr = qo.limitStr;
        Integer numberRefHops = qo.numberRefHops;
        File outfile = null;
        int batchSize = 0;
        BufferedWriter bw = null;
        boolean keysExplicitlyGiven = fileStr != null || queryStr != null;
        long limit = limitStr != null ? (long)Integer.parseInt(limitStr) : -1L;
        boolean bl = createDirectory = baseOutFile != null && !pubmedArticleSet;
        if (verbose) {
            CLI.logMessage("Creating " + (createDirectory ? "directory" : "file") + " " + baseOutFile + " to write query results to.");
        }
        if (createDirectory) {
            outfile = new File(baseOutFile);
            if (!outfile.exists()) {
                CLI.logMessage("Directory " + outfile.getAbsolutePath() + " does not exist and will be created (as well as sub dircetories for file batches if required).");
                outfile.mkdir();
            }
            CLI.logMessage("Writing queried documents to " + outfile.getAbsolutePath());
            if (batchSizeStr != null) {
                try {
                    batchSize = Integer.parseInt(batchSizeStr);
                    CLI.logMessage("Dividing query result files in batches of " + batchSize);
                    if (batchSize < 1) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException e) {
                    LOG.error("Error parsing \"{}\" into an integer. Please deliver a positive numeric value for the batch size of files.");
                }
            }
        }
        if (!error) {
            List<Object> keys = new ArrayList();
            if (fileStr != null) {
                try {
                    keys = CLI.convertFileToPrimaryKeyList(fileStr);
                }
                catch (IOException e1) {
                    LOG.error("Could not open '" + new File(fileStr).getAbsolutePath() + "'.");
                    error = true;
                }
            }
            if (queryStr != null) {
                for (String pmid : queryStr.split(",")) {
                    keys.add(pmid.split(KEY_PART_SEPERATOR));
                }
            }
            try {
                if (!error) {
                    DBCIterator<byte[][]> it;
                    if (!keysExplicitlyGiven) {
                        it = dbc.querySubset(tableName, qo.whereClause, limit, numberRefHops, tableSchema);
                    } else if (keys.size() > 0) {
                        it = dbc.retrieveColumnsByTableSchema(keys, tableName, tableSchema);
                    } else {
                        throw new IllegalStateException("No query keys have been explicitly given (e.g. in a file) nor should the whole table be queried.");
                    }
                    int i = 0;
                    int batchNumber = -1;
                    File outDir = outfile;
                    if (pubmedArticleSet) {
                        if (null != baseOutFile) {
                            CLI.logMessage("Creating a single file with a PubmedArticleSet and writing it to " + baseOutFile);
                            bw = FileUtilities.getWriterToFile(new File(baseOutFile));
                        }
                        CLI.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<!DOCTYPE PubmedArticleSet SYSTEM \"http://dtd.nlm.nih.gov/ncbi/pubmed/out/pubmed_170101.dtd\">\n<PubmedArticleSet>", bw);
                    }
                    BinaryDataHandler binaryDataHandler = null;
                    if (dbc.getActiveTableFieldConfiguration().isBinary()) {
                        binaryDataHandler = new BinaryDataHandler(dbc, "public", Collections.emptySet(), dbc.getConfig().getTypeSystemFiles());
                    }
                    while (it.hasNext()) {
                        byte[][] idAndXML = (byte[][])it.next();
                        if (outfile != null) {
                            if (batchSize > 0 && i % batchSize == 0) {
                                String subDirectoryName = ++batchNumber > -1 && batchSize > 0 ? Integer.toString(batchNumber) : "";
                                String subDirPath = outfile.getAbsolutePath() + FILE_SEPERATOR + subDirectoryName;
                                outDir = new File(subDirPath);
                                outDir.mkdir();
                            }
                            String filename = new String(idAndXML[0]);
                            if (!pubmedArticleSet) {
                                if (bw != null) {
                                    bw.close();
                                }
                                bw = FileUtilities.getWriterToFile(new File(outDir + FILE_SEPERATOR + filename));
                            }
                        }
                        boolean retrieveBaseDocument = Set.of(dbc.getActiveTableFieldConfiguration().getColumnsToRetrieve()).contains("base_document");
                        if (xpath == null) {
                            StringBuilder sb = new StringBuilder();
                            if (pubmedArticleSet) {
                                sb.append("<PubmedArticle>\n");
                            }
                            if (!retrieveBaseDocument) {
                                sb.append("<CoStoSysPrimaryKey>").append(new String(idAndXML[0])).append("</CoStoSysPrimaryKey>");
                                sb.append("<xmidata>");
                            }
                            if (!dbc.getActiveTableFieldConfiguration().isBinary()) {
                                sb.append(new String(idAndXML[1], "UTF-8"));
                            } else {
                                sb.append(binaryDataHandler.decodeBinaryXmiData(idAndXML, retrieveBaseDocument));
                            }
                            if (!retrieveBaseDocument) {
                                sb.append("</xmidata>");
                            }
                            if (pubmedArticleSet) {
                                sb.append("\n</PubmedArticle>");
                            }
                            CLI.print(sb.toString(), bw);
                        } else {
                            List<String[]> values;
                            if (!dbc.getActiveTableFieldConfiguration().isBinary()) {
                                values = CLI.getXpathValues(idAndXML[1], xpath, new String(idAndXML[0]));
                            } else {
                                String xml = binaryDataHandler.decodeBinaryXmiData(idAndXML, retrieveBaseDocument);
                                values = CLI.getXpathValues(xml.getBytes(StandardCharsets.UTF_8), xpath, new String(idAndXML[0]));
                            }
                            for (CharSequence[] charSequenceArray : values) {
                                CLI.print(String.join((CharSequence)KEY_PART_SEPERATOR, charSequenceArray), bw);
                            }
                        }
                        if (useDelimiter) {
                            System.out.println(DELIMITER);
                        }
                        ++i;
                    }
                    if (pubmedArticleSet) {
                        CLI.print("</PubmedArticleSet>", bw);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CoStoSysException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (bw != null) {
                        bw.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return error;
    }

    private static void print(String string, BufferedWriter bw) throws IOException {
        if (bw == null) {
            System.out.println(string);
        } else {
            bw.write(string + "\n");
        }
    }

    private static List<String[]> getXpathValues(byte[] next, String xpaths, String docId) {
        String[] xpathArray = xpaths.split(",");
        String forEachXpath = ".";
        ArrayList<Map<String, String>> fields = new ArrayList<Map<String, String>>();
        ArrayList<String> fieldXpaths = new ArrayList<String>();
        for (String xpath : xpathArray) {
            if (xpath.startsWith("fe:")) {
                forEachXpath = xpath.replace("fe:", "");
                continue;
            }
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("name", xpath);
            field.put("xpath", xpath);
            field.put("returnXMLFragment", "false");
            field.put("returnValuesAsArray", "true");
            fields.add(field);
            fieldXpaths.add(xpath);
        }
        ArrayList<String[]> retStrings = new ArrayList<String[]>();
        Iterator<Map<String, Object>> it = JulieXMLTools.constructRowIterator(next, 1024, forEachXpath, fields, docId, true);
        while (it.hasNext()) {
            Map<String, Object> row = it.next();
            String[] resultRow = new String[fieldXpaths.size() + 1];
            resultRow[0] = docId;
            for (int i = 0; i < fieldXpaths.size(); ++i) {
                Object fieldValue = row.get(fieldXpaths.get(i));
                fieldValue = fieldValue == null ? "XPath " + xpaths + " does not exist in this document." : (fieldValue.getClass().isArray() ? String.join((CharSequence)",", (String[])fieldValue) : String.valueOf(fieldValue));
                resultRow[i + 1] = (String)fieldValue;
            }
            retStrings.add(resultRow);
        }
        return retStrings;
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(160);
        formatter.printHelp(CLI.class.getName(), options);
    }

    private static boolean checkSchema(DataBaseConnector dbc, String tableName) {
        boolean error = false;
        String[] tablePath = tableName.split("\\.");
        if (tablePath.length == 2 && !dbc.withConnectionQueryBoolean(c -> c.schemaExists(tablePath[0]))) {
            dbc.createSchema(tablePath[0]);
        } else if (tablePath.length > 2) {
            LOG.error(String.format("The table path %s is invalid. Only table names of the form 'tablename' or 'schemaname.tablename'are accepted.", tableName));
        }
        return error;
    }

    private static String escapeSingleQuotes(String comment) {
        return comment.replaceAll("'", "\\\\'");
    }

    private static List<Object[]> convertFileToPrimaryKeyList(String fileStr) throws IOException {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        File file = new File(fileStr);
        if (file != null) {
            try (BufferedReader br = new BufferedReader(new FileReader(file));){
                String line = br.readLine();
                while (line != null) {
                    list.add(line.split(KEY_PART_SEPERATOR));
                    line = br.readLine();
                }
            }
        }
        return list;
    }

    private static ArrayList<String> asList(String fileStr) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        File file = new File(fileStr);
        if (file != null) {
            try (BufferedReader br = new BufferedReader(new FileReader(file));){
                String line = br.readLine();
                while (line != null) {
                    list.add(line);
                    line = br.readLine();
                }
            }
        }
        return list;
    }

    public static XMLConfiguration loadXmlConfiguration(File configurationFile) throws ConfigurationException {
        try {
            Parameters params = new Parameters();
            FileBasedConfigurationBuilder configBuilder = new FileBasedConfigurationBuilder(XMLConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)params.xml().setFile(configurationFile)});
            return (XMLConfiguration)configBuilder.getConfiguration();
        }
        catch (ConfigurationException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    private static /* synthetic */ String lambda$main$0(List tableSchemaNames, int i) {
        return i + " " + (String)tableSchemaNames.get(i);
    }

    private static enum Mode {
        IMPORT,
        QUERY,
        SUBSET,
        RESET,
        STATUS,
        ERROR,
        TABLES,
        LIST_TABLE_SCHEMAS,
        TABLE_DEFINITION,
        SCHEME,
        CHECK,
        DEFAULT_CONFIG,
        DROP_TABLE,
        DELETE_ROWS,
        IMPORT_UPDATE_MEDLINE,
        IMPORT_UPDATE_PMC,
        MARK_PROCESSED,
        UPDATE_XMI,
        PRINT_VERSION;

    }
}

