/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware;

import com.ximpleware.FastLongBuffer;

public class FixedLongBuffer
extends FastLongBuffer {
    private long[] storage;

    public FixedLongBuffer(int n) {
        this.storage = new long[n];
        this.size = 0;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public int getCapacity() {
        return this.storage.length;
    }

    @Override
    public void append(long[] lArray) {
        System.arraycopy(lArray, 0, this.storage, this.size, lArray.length);
    }

    @Override
    public void append(long l) {
        this.storage[this.size] = l;
        ++this.size;
    }

    @Override
    public long longAt(int n) {
        return this.storage[n];
    }

    @Override
    public int upper32At(int n) {
        return (int)(this.storage[n] >> 32);
    }

    @Override
    public int lower32At(int n) {
        return (int)this.storage[n];
    }

    @Override
    public long[] getLongArray(int n, int n2) {
        long[] lArray = new long[n2];
        System.arraycopy(this.storage, n, lArray, 0, n2);
        return lArray;
    }

    @Override
    public long[] toLongArray() {
        return (long[])this.storage.clone();
    }

    public void resize() {
    }

    @Override
    public void modifyEntry(int n, long l) {
        this.storage[n] = l;
    }
}

