/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss.tokens;

import com.wcohen.ss.AbstractStringDistance;
import com.wcohen.ss.TagLink;
import com.wcohen.ss.api.StringWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;

public class TagLinkToken
extends AbstractStringDistance {
    private double matched;
    private double tr;
    private double sSize;
    private double tSize;
    private double totalScore;
    private static final double DEF_TR = 0.3;
    private String sA;
    private String sB;
    private String tokenT;
    private int largestIndex;

    public TagLinkToken() {
        this(0.3);
    }

    public TagLinkToken(double tr) {
        this.tr = tr;
    }

    public double score(StringWrapper s2, StringWrapper t) {
        String S = s2.unwrap();
        String T = t.unwrap();
        this.totalScore = 0.0;
        if (S.equals(T)) {
            this.matched = S.length();
            return 1.0;
        }
        this.sSize = S.length();
        this.tSize = T.length();
        if (this.sSize < this.tSize) {
            String tmp1 = S;
            S = T;
            T = tmp1;
            double tmp2 = this.sSize;
            this.sSize = this.tSize;
            this.tSize = tmp2;
            this.tokenT = T;
        }
        this.tokenT = S;
        ArrayList candidateList = this.algorithm1(S, T);
        this.sortList(candidateList);
        this.totalScore = this.getScore(candidateList);
        this.totalScore = (this.totalScore / this.sSize + this.totalScore / this.tSize) / 2.0;
        return this.winkler(this.totalScore, S, T);
    }

    public String explainScore(StringWrapper s2, StringWrapper t) {
        String S = s2.unwrap();
        String T = t.unwrap();
        StringBuffer buff = new StringBuffer();
        buff.append("\n****TagLinkToken****\n");
        buff.append("Si=" + S + ", Tj=" + T + "\n");
        double totalScore = 0.0;
        if (S.equals(T)) {
            this.matched = S.length();
            buff.append("Sij=1.0");
        } else {
            this.sSize = S.length();
            this.tSize = T.length();
            if (this.sSize < this.tSize) {
                String tmp1 = S;
                S = T;
                T = tmp1;
                double tmp2 = this.sSize;
                this.sSize = this.tSize;
                this.tSize = tmp2;
            }
            ArrayList candidateList = this.algorithm1(S, T);
            this.sortList(candidateList);
            buff.append("Common characteres:\n");
            buff.append("Si\tTj\tScore_ij(Si,Tj)\n");
            this.matched = 0.0;
            HashMap tMap = new HashMap();
            HashMap uMap = new HashMap();
            for (TagLink.Candidates actualCandidates : candidateList) {
                Integer sPos = new Integer(actualCandidates.getTPos());
                Integer tPos = new Integer(actualCandidates.getUPos());
                if (tMap.containsKey(sPos) || uMap.containsKey(tPos)) continue;
                double actualScore = actualCandidates.getScore();
                totalScore += actualScore;
                tMap.put(sPos, null);
                uMap.put(tPos, null);
                buff.append(S.charAt(sPos) + "\t" + T.charAt(tPos) + "\t" + this.round(actualScore) + "\n");
                this.matched += 1.0;
            }
            totalScore = (totalScore / this.sSize + totalScore / this.tSize) / 2.0;
            System.out.println("score " + totalScore);
            buff.append("Score_ij(S,T)=" + this.round(this.winkler(totalScore, S, T)));
            buff.append("\nMatched characters=" + this.matched);
        }
        return buff.toString();
    }

    private double getScore(ArrayList candidateList) {
        this.matched = 0.0;
        this.largestIndex = -1;
        double scoreValue = 0.0;
        HashMap tMap = new HashMap();
        HashMap uMap = new HashMap();
        for (TagLink.Candidates actualCandidates : candidateList) {
            Integer actualTPos = new Integer(actualCandidates.getTPos());
            Integer actualUPos = new Integer(actualCandidates.getUPos());
            if (tMap.containsKey(actualTPos) || uMap.containsKey(actualUPos)) continue;
            double actualScore = actualCandidates.getScore();
            scoreValue += actualScore;
            tMap.put(actualTPos, null);
            uMap.put(actualUPos, null);
            if (this.largestIndex < actualTPos) {
                this.largestIndex = actualTPos;
            }
            this.matched += 1.0;
        }
        return scoreValue;
    }

    private ArrayList algorithm1(String S, String T) {
        ArrayList<TagLink.Candidates> candidateList = new ArrayList<TagLink.Candidates>();
        int bound = (int)(1.0 / this.tr);
        for (int t = 0; t < S.length(); ++t) {
            char chT = S.charAt(t);
            double lastTr = -1.0;
            boolean flag = false;
            for (int u = Math.max(0, t - bound); u < Math.min(t + bound + 1, T.length()) && !flag; ++u) {
                double tr2 = Math.abs(t - u);
                if (lastTr >= 0.0 && lastTr < tr2) {
                    flag = true;
                    continue;
                }
                char chU = T.charAt(u);
                double charScore = 0.0;
                if (chT == chU) {
                    charScore = 1.0;
                }
                if (!(charScore > 0.0)) continue;
                if (charScore == 1.0) {
                    lastTr = tr2;
                }
                if ((charScore -= this.tr * tr2) == 1.0) {
                    flag = true;
                }
                candidateList.add(new TagLink.Candidates(t, u, charScore));
            }
        }
        return candidateList;
    }

    private void sortList(ArrayList candidateList) {
        Collections.sort(candidateList, new Comparator(){

            public int compare(Object o1, Object o2) {
                double scoreT = ((TagLink.Candidates)o1).getScore();
                double scoreU = ((TagLink.Candidates)o2).getScore();
                if (scoreU > scoreT) {
                    return 1;
                }
                if (scoreU > scoreT) {
                    return -1;
                }
                return 0;
            }
        });
    }

    private double winkler(double totalScore, String S, String T) {
        totalScore += (double)this.getPrefix(S, T) * 0.1 * (1.0 - totalScore);
        return totalScore;
    }

    private int getPrefix(String S, String T) {
        int prefix;
        int bound = Math.min(4, Math.min(S.length(), T.length()));
        for (prefix = 0; prefix < bound && S.charAt(prefix) == T.charAt(prefix); ++prefix) {
        }
        return prefix;
    }

    public double getMatched() {
        return this.matched;
    }

    public double getTr() {
        return this.tr;
    }

    public void setTreshold(double treshold) {
        this.tr = treshold;
    }

    public String toString() {
        return "[TagLinkToken_Tr_" + this.tr + "]";
    }

    private double round(double number) {
        int round = (int)(number * 1000.0);
        double rest = number * 1000.0 - (double)round;
        if (rest >= 0.5) {
            ++round;
        }
        return (double)round / 1000.0;
    }
}

