/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss.tokens;

import com.wcohen.ss.api.Token;
import com.wcohen.ss.api.Tokenizer;
import com.wcohen.ss.tokens.BasicToken;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharacterTokenizer
implements Tokenizer {
    public static final CharacterTokenizer DEFAULT_TOKENIZER = new CharacterTokenizer(true, true);
    private boolean ignorePunctuation = true;
    private boolean ignoreCase = true;
    private int nextId = 0;
    private Map<String, Token> tokMap = new TreeMap<String, Token>();

    public CharacterTokenizer(boolean ignorePunctuation, boolean ignoreCase) {
        this.ignorePunctuation = ignorePunctuation;
        this.ignoreCase = ignoreCase;
    }

    public void setIgnorePunctuation(boolean flag) {
        this.ignorePunctuation = flag;
    }

    public void setIgnoreCase(boolean flag) {
        this.ignoreCase = flag;
    }

    public String toString() {
        return "[CharacterTokenizer " + this.ignorePunctuation + ";" + this.ignoreCase + "]";
    }

    @Override
    public Token[] tokenize(String input) {
        char[] stringChars = input.toCharArray();
        ArrayList<Token> tokens = new ArrayList<Token>();
        for (char c : stringChars) {
            if (Character.isLetterOrDigit(c)) {
                tokens.add(this.internSomething(Character.toString(c)));
                continue;
            }
            if (this.ignorePunctuation || Character.isWhitespace(c)) continue;
            tokens.add(this.internSomething(Character.toString(c)));
        }
        return tokens.toArray(new BasicToken[tokens.size()]);
    }

    private Token internSomething(String s2) {
        return this.intern(this.ignoreCase ? s2.toLowerCase() : s2);
    }

    @Override
    public Token intern(String s2) {
        Token tok = this.tokMap.get(s2);
        if (tok == null) {
            tok = new BasicToken(++this.nextId, s2);
            this.tokMap.put(s2, tok);
        }
        return tok;
    }

    @Override
    public Iterator<Token> tokenIterator() {
        return this.tokMap.values().iterator();
    }

    @Override
    public int maxTokenIndex() {
        return this.nextId;
    }

    public static void main(String[] argv) {
        CharacterTokenizer tokenizer = DEFAULT_TOKENIZER;
        int n = 0;
        for (int i = 0; i < argv.length; ++i) {
            System.out.println("argument " + i + ": '" + argv[i] + "'");
            Token[] tokens = tokenizer.tokenize(argv[i]);
            for (int j = 0; j < tokens.length; ++j) {
                System.out.println("token " + ++n + ":" + " id=" + tokens[j].getIndex() + " value: '" + tokens[j].getValue() + "'");
            }
        }
    }
}

