/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss.lookup;

import com.wcohen.ss.BasicStringWrapperIterator;
import com.wcohen.ss.JaroWinkler;
import com.wcohen.ss.SoftTFIDF;
import com.wcohen.ss.TFIDF;
import com.wcohen.ss.api.StringWrapper;
import com.wcohen.ss.api.Token;
import com.wcohen.ss.api.Tokenizer;
import com.wcohen.ss.lookup.FastLookup;
import com.wcohen.ss.lookup.LookupResult;
import com.wcohen.ss.tokens.SimpleTokenizer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SoftTFIDFDictionary
implements FastLookup {
    private static final boolean DEBUG = false;
    private static final int DEFAULT_WINDOW_SIZE = 100;
    private static final double DEFAULT_MIN_TOKEN_SIMILARITY = 0.9;
    private static final int DEFAULT_MAX_INVERTED_INDEX_SIZE = 0;
    private static final Tokenizer DEFAULT_TOKENIZER = new SimpleTokenizer(false, true);
    private static final Comparator LEXICAL_ORDER_FOR_TOKENS = new Comparator(){

        public int compare(Object a, Object b) {
            return ((Token)a).getValue().compareTo(((Token)b).getValue());
        }
    };
    private static final Comparator ID_ORDER_FOR_TOKENS = new Comparator(){

        public int compare(Object a, Object b) {
            return ((Token)a).getIndex() - ((Token)b).getIndex();
        }
    };
    private double minTokenSimilarity;
    private Tokenizer tokenizer;
    private SoftTFIDF softTFIDFDistance;
    private TFIDF tfidfDistance;
    private JaroWinkler jaroWinklerDistance;
    private int windowSize;
    private int maxInvertedIndexSize;
    private Map valueMap = new HashMap();
    private boolean frozen = false;
    private double[] maxTFIDFScore;
    Token[][] similarTokens;
    Set[] invertedIndex;
    Token[] allTokens;
    int numTokens;
    private List result;
    protected double lookupTime;

    public void saveAs(File file) throws IOException, FileNotFoundException {
        Token toki;
        int i;
        this.freeze();
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        if (this.tokenizer != DEFAULT_TOKENIZER) {
            throw new IllegalStateException("can't save a non-default tokenizer");
        }
        out.writeDouble(this.minTokenSimilarity);
        out.writeInt(this.windowSize);
        out.writeInt(this.maxInvertedIndexSize);
        out.writeInt(this.valueMap.entrySet().size());
        for (Map.Entry e : this.valueMap.entrySet()) {
            out.writeObject(e.getKey());
            out.writeObject(e.getValue());
        }
        out.writeInt(this.numTokens);
        Arrays.sort(this.allTokens, ID_ORDER_FOR_TOKENS);
        for (i = 0; i < this.numTokens; ++i) {
            out.writeObject(this.allTokens[i].getValue());
        }
        Arrays.sort(this.allTokens, LEXICAL_ORDER_FOR_TOKENS);
        for (i = 0; i < this.numTokens; ++i) {
            out.writeInt(this.tfidfDistance.getDocumentFrequency(this.allTokens[i]));
        }
        out.writeInt(this.tfidfDistance.getCollectionSize());
        for (i = 0; i < this.numTokens; ++i) {
            toki = this.allTokens[i];
            out.writeDouble(this.maxTFIDFScore[toki.getIndex()]);
        }
        for (i = 0; i < this.numTokens; ++i) {
            toki = this.allTokens[i];
            int n = this.similarTokens[toki.getIndex()].length;
            out.writeInt(n);
            for (int j = 0; j < n; ++j) {
                out.writeObject(this.similarTokens[toki.getIndex()][j].getValue());
            }
        }
        for (i = 0; i < this.numTokens; ++i) {
            toki = this.allTokens[i];
            Set ii = this.invertedIndex[toki.getIndex()];
            out.writeInt(ii.size());
            for (String s2 : ii) {
                out.writeObject(s2);
            }
        }
        out.close();
    }

    public static SoftTFIDFDictionary restore(File file) throws IOException, FileNotFoundException {
        try {
            return SoftTFIDFDictionary.doRestore(file);
        }
        catch (ClassNotFoundException ex) {
            throw new IOException("improperly format SoftTFIDFDictionary file:" + ex);
        }
    }

    private static SoftTFIDFDictionary doRestore(File file) throws IOException, FileNotFoundException, ClassNotFoundException {
        int j;
        int n;
        Token toki;
        int i;
        int i2;
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
        double mts = in.readDouble();
        int ws = in.readInt();
        int miis = in.readInt();
        SoftTFIDFDictionary dict = new SoftTFIDFDictionary(DEFAULT_TOKENIZER, mts, ws, miis);
        dict.valueMap = new HashMap();
        int v = in.readInt();
        for (i2 = 0; i2 < v; ++i2) {
            String key = (String)in.readObject();
            Object value = in.readObject();
            dict.valueMap.put(key, value);
        }
        dict.numTokens = in.readInt();
        dict.allTokens = new Token[dict.numTokens];
        for (i2 = 0; i2 < dict.numTokens; ++i2) {
            String tokenValue = (String)in.readObject();
            dict.allTokens[i2] = dict.tokenizer.intern(tokenValue);
        }
        Arrays.sort(dict.allTokens, LEXICAL_ORDER_FOR_TOKENS);
        for (i2 = 0; i2 < dict.numTokens; ++i2) {
            int df = in.readInt();
            dict.tfidfDistance.setDocumentFrequency(dict.allTokens[i2], df);
            dict.softTFIDFDistance.setDocumentFrequency(dict.allTokens[i2], df);
        }
        int cs = in.readInt();
        dict.tfidfDistance.setCollectionSize(cs);
        dict.softTFIDFDistance.setCollectionSize(cs);
        dict.maxTFIDFScore = new double[dict.tokenizer.maxTokenIndex() + 1];
        for (i = 0; i < dict.numTokens; ++i) {
            toki = dict.allTokens[i];
            dict.maxTFIDFScore[toki.getIndex()] = in.readDouble();
        }
        dict.similarTokens = new Token[dict.tokenizer.maxTokenIndex() + 1][];
        for (i = 0; i < dict.numTokens; ++i) {
            toki = dict.allTokens[i];
            n = in.readInt();
            dict.similarTokens[toki.getIndex()] = new Token[n];
            for (j = 0; j < n; ++j) {
                String tokenValue = (String)in.readObject();
                dict.similarTokens[toki.getIndex()][j] = dict.tokenizer.intern(tokenValue);
            }
        }
        dict.invertedIndex = new Set[dict.tokenizer.maxTokenIndex() + 1];
        for (i = 0; i < dict.numTokens; ++i) {
            toki = dict.allTokens[i];
            dict.invertedIndex[toki.getIndex()] = new HashSet();
            n = in.readInt();
            for (j = 0; j < n; ++j) {
                String s2 = (String)in.readObject();
                dict.invertedIndex[toki.getIndex()].add(s2);
            }
        }
        in.close();
        dict.frozen = true;
        return dict;
    }

    private void showValueMap() {
        System.out.println("valueMap: " + this.valueMap);
    }

    private void showAllTokens() {
        for (int i = 0; i < this.numTokens; ++i) {
            System.out.println("allTokens[" + i + "] = " + this.allTokens[i]);
        }
    }

    private void showAllMaxScores() {
        for (int i = 0; i < this.numTokens; ++i) {
            System.out.println("allTokens[" + i + "] = " + this.allTokens[i] + " maxscore = " + this.maxTFIDFScore[i]);
        }
    }

    public SoftTFIDFDictionary() {
        this(DEFAULT_TOKENIZER, 0.9, 100, 0);
    }

    public SoftTFIDFDictionary(Tokenizer tokenizer) {
        this(tokenizer, 0.9, 100, 0);
    }

    public SoftTFIDFDictionary(Tokenizer tokenizer, double minTokenSimilarity) {
        this(tokenizer, minTokenSimilarity, 100, 0);
    }

    public SoftTFIDFDictionary(Tokenizer tokenizer, double minTokenSimilarity, int windowSize, int maxInvertedIndexSize) {
        this.tokenizer = tokenizer;
        this.minTokenSimilarity = minTokenSimilarity;
        this.windowSize = windowSize;
        this.maxInvertedIndexSize = maxInvertedIndexSize;
        this.tfidfDistance = new TFIDF(tokenizer);
        this.jaroWinklerDistance = new JaroWinkler();
        this.softTFIDFDistance = new SoftTFIDF(tokenizer, this.jaroWinklerDistance, minTokenSimilarity);
    }

    public void setWindowSize(int w) {
        this.windowSize = w;
    }

    public int getWindowSize(int w) {
        return this.windowSize;
    }

    public void setMaxInvertedIndexSize(int m3) {
        this.maxInvertedIndexSize = m3;
    }

    public int getMaxInvertedIndexSize() {
        return this.maxInvertedIndexSize;
    }

    public void loadAliases(File file) throws IOException, FileNotFoundException {
        String line;
        LineNumberReader in = new LineNumberReader(new FileReader(file));
        while ((line = in.readLine()) != null) {
            String[] parts = line.split("\\t");
            for (int j = 1; j < parts.length; ++j) {
                this.put(parts[j], parts[0]);
            }
        }
        in.close();
    }

    public void put(String string, Object value) {
        if (this.frozen) {
            throw new IllegalStateException("can't add new values to a frozen dictionary");
        }
        HashSet<Object> valset = (HashSet<Object>)this.valueMap.get(string);
        if (valset == null) {
            valset = new HashSet<Object>();
            this.valueMap.put(string, valset);
        }
        valset.add(value);
    }

    public void refreeze() {
        this.frozen = false;
        this.freeze();
    }

    public void freeze() {
        Token toki;
        if (this.frozen) {
            return;
        }
        this.trainDistances();
        this.invertedIndex = new Set[this.tokenizer.maxTokenIndex() + 1];
        this.maxTFIDFScore = new double[this.tokenizer.maxTokenIndex() + 1];
        for (String s2 : this.valueMap.keySet()) {
            this.tfidfDistance.prepare(s2);
            Token[] tokens = this.tfidfDistance.getTokens();
            for (int j = 0; j < tokens.length; ++j) {
                Token tok = tokens[j];
                double w = this.tfidfDistance.getWeight(tok);
                this.maxTFIDFScore[tok.getIndex()] = Math.max(this.maxTFIDFScore[tok.getIndex()], w);
                HashSet<String> ii = this.invertedIndex[tok.getIndex()];
                if (ii == null) {
                    HashSet<String> hashSet = new HashSet<String>();
                    this.invertedIndex[tok.getIndex()] = hashSet;
                    ii = hashSet;
                }
                ii.add(s2);
            }
        }
        this.allTokens = new Token[this.tokenizer.maxTokenIndex()];
        this.numTokens = 0;
        Iterator i = this.tokenizer.tokenIterator();
        while (i.hasNext()) {
            toki = (Token)i.next();
            this.allTokens[this.numTokens++] = toki;
        }
        Arrays.sort(this.allTokens, LEXICAL_ORDER_FOR_TOKENS);
        this.similarTokens = new Token[this.tokenizer.maxTokenIndex() + 1][];
        for (int i2 = 0; i2 < this.numTokens; ++i2) {
            toki = this.allTokens[i2];
            Set likeTokI = this.findSimilarTokens(toki.getValue(), i2);
            this.similarTokens[toki.getIndex()] = new Token[likeTokI.size()];
            int k = 0;
            for (Token tokj : likeTokI) {
                this.similarTokens[toki.getIndex()][k++] = tokj;
            }
        }
        this.frozen = true;
    }

    private void trainDistances() {
        long start = System.currentTimeMillis();
        ArrayList<StringWrapper> accum = new ArrayList<StringWrapper>(this.valueMap.keySet().size());
        for (String s2 : this.valueMap.keySet()) {
            accum.add(this.tfidfDistance.prepare(s2));
        }
        double elapsedSec1 = (double)(System.currentTimeMillis() - start) / 1000.0;
        this.tfidfDistance.train(new BasicStringWrapperIterator(accum.iterator()));
        this.softTFIDFDistance.train(new BasicStringWrapperIterator(accum.iterator()));
        double elapsedSec2 = (double)(System.currentTimeMillis() - start) / 1000.0;
    }

    private Set findSimilarTokens(String s2, int i) {
        HashSet<Token> likeTokI = new HashSet<Token>();
        for (int j = Math.max(0, i - this.windowSize); j < Math.min(i + this.windowSize, this.numTokens); ++j) {
            Token tokj;
            double d;
            if (i == j || !((d = this.jaroWinklerDistance.score(s2, (tokj = this.allTokens[j]).getValue())) >= this.minTokenSimilarity)) continue;
            likeTokI.add(tokj);
        }
        return likeTokI;
    }

    public int slowLookup(double minScore, String toFind) {
        if (!this.frozen) {
            this.freeze();
        }
        long start = System.currentTimeMillis();
        StringWrapper wa = this.softTFIDFDistance.prepare(toFind);
        this.result = new ArrayList();
        for (String found : this.valueMap.keySet()) {
            StringWrapper wb = this.softTFIDFDistance.prepare(found);
            double d = this.softTFIDFDistance.score(wa, wb);
            if (!(d >= minScore)) continue;
            Set valset = (Set)this.valueMap.get(found);
            for (String valj : valset) {
                this.result.add(new LookupResult(found, valj, d));
            }
        }
        Collections.sort(this.result);
        this.lookupTime = (double)(System.currentTimeMillis() - start) / 1000.0;
        return this.result.size();
    }

    public int lookup(double minScore, String toFind) {
        if (!this.frozen) {
            this.freeze();
        }
        long start = System.currentTimeMillis();
        final HashMap upperBoundOnWeight = new HashMap();
        this.tfidfDistance.prepare(toFind);
        Token[] tokens = this.tfidfDistance.getTokens();
        ArrayList usefulTokens = new ArrayList(tokens.length);
        for (int i = 0; i < tokens.length; ++i) {
            Token tok = tokens[i];
            if (tok.getIndex() < this.maxTFIDFScore.length) {
                this.storeUpperBound(tok, tok, usefulTokens, upperBoundOnWeight, 1.0);
                for (int j = 0; j < this.similarTokens[tok.getIndex()].length; ++j) {
                    Token simTok = this.similarTokens[tok.getIndex()][j];
                    double sim = this.jaroWinklerDistance.score(tok.getValue(), simTok.getValue());
                    this.storeUpperBound(tok, simTok, usefulTokens, upperBoundOnWeight, sim);
                }
                continue;
            }
            int indexInAllTokens = Arrays.binarySearch(this.allTokens, tok, LEXICAL_ORDER_FOR_TOKENS);
            if (indexInAllTokens < 0) {
                indexInAllTokens = -(indexInAllTokens + 1);
            }
            Set likeTokI = this.findSimilarTokens(tok.getValue(), indexInAllTokens);
            for (Token simTok : likeTokI) {
                double sim = this.jaroWinklerDistance.score(tok.getValue(), simTok.getValue());
                this.storeUpperBound(tok, simTok, usefulTokens, upperBoundOnWeight, sim);
            }
        }
        HashSet candidates = new HashSet();
        Collections.sort(usefulTokens, new Comparator(){

            public int compare(Object a, Object b) {
                Double da = (Double)upperBoundOnWeight.get(a);
                Double db = (Double)upperBoundOnWeight.get(b);
                double diff = da - db;
                return diff > 0.0 ? 1 : (diff < 0.0 ? -1 : 0);
            }
        });
        double totScore = 0.0;
        for (Token tok : usefulTokens) {
            Double ub = (Double)upperBoundOnWeight.get(tok);
            if (ub != null) {
                totScore += ub.doubleValue();
            }
            if (!(totScore >= minScore)) continue;
            Set ii = this.invertedIndex[tok.getIndex()];
            if (this.maxInvertedIndexSize > 0 && ii.size() >= this.maxInvertedIndexSize) continue;
            candidates.addAll(ii);
        }
        this.result = new ArrayList(candidates.size());
        StringWrapper wa = this.softTFIDFDistance.prepare(toFind);
        for (String found : candidates) {
            StringWrapper wb = this.softTFIDFDistance.prepare(found);
            double d = this.softTFIDFDistance.score(wa, wb);
            if (!(d >= minScore)) continue;
            Set valset = (Set)this.valueMap.get(found);
            for (String valj : valset) {
                this.result.add(new LookupResult(found, valj, d));
            }
        }
        Collections.sort(this.result);
        this.lookupTime = (double)(System.currentTimeMillis() - start) / 1000.0;
        return this.result.size();
    }

    private void storeUpperBound(Token tok, Token simTok, List usefulTokens, Map upperBoundOnWeight, double sim) {
        double upperBound = this.tfidfDistance.getWeight(tok) * this.maxTFIDFScore[simTok.getIndex()] * sim;
        usefulTokens.add(simTok);
        upperBoundOnWeight.put(simTok, new Double(upperBound));
    }

    public String getResult(int i) {
        return ((LookupResult)this.result.get((int)i)).found;
    }

    public Object getValue(int i) {
        return ((LookupResult)this.result.get((int)i)).value;
    }

    public double getScore(int i) {
        return ((LookupResult)this.result.get((int)i)).score;
    }

    public double getLookupTime() {
        return this.lookupTime;
    }

    private void showLookup(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.println(this.result.get(i));
        }
    }

    private void showSimilarTokens() {
        for (int i = 0; i < this.numTokens; ++i) {
            Token toki = this.allTokens[i];
            System.out.print(toki + "\t~");
            if (this.similarTokens[toki.getIndex()] == null) {
                System.out.print(" NULL");
            } else {
                for (int j = 0; j < this.similarTokens[toki.getIndex()].length; ++j) {
                    Token tokj = this.similarTokens[toki.getIndex()][j];
                    System.out.print(" " + tokj.getValue());
                }
            }
            System.out.println();
        }
    }

    private double getNumberOfSimilarTokenPairs() {
        double tot = 0.0;
        for (int i = 0; i < this.numTokens; ++i) {
            Token toki = this.allTokens[i];
            tot += (double)this.similarTokens[toki.getIndex()].length;
        }
        return tot;
    }

    public static void main(String[] argv) throws IOException, FileNotFoundException, NumberFormatException, ClassNotFoundException {
        if (argv.length == 0) {
            System.out.println("usage 1: aliasfile threshold query1 query2 ... - run queries");
            System.out.println("usage 2: aliasfile threshold queryfile - run queries from a file");
            System.out.println("usage 3: aliasfile window1 window2 .... - explore different window sizes");
            System.out.println("usage 4: aliasfile savefile - convert to fast-loading savefile");
            System.out.println("usage 4: aliasfile - print some stats");
            System.exit(0);
        }
        SoftTFIDFDictionary dict = SoftTFIDFDictionary.loadSomehow(argv[0]);
        if (argv.length == 1) {
            System.out.println("inverted index sizes:");
            for (int i = 0; i < dict.numTokens; ++i) {
                Token toki = dict.allTokens[i];
                Set ii = dict.invertedIndex[toki.getIndex()];
                System.out.println(ii.size() + " " + toki.getValue());
            }
        } else if (argv.length == 2) {
            System.out.println("saving...");
            dict.saveAs(new File(argv[1]));
        } else {
            double d = Double.parseDouble(argv[1]);
            if (d <= 1.0) {
                if (argv.length == 3 && new File(argv[2]).exists()) {
                    String line;
                    LineNumberReader in = new LineNumberReader(new FileReader(new File(argv[2])));
                    double[] stats = new double[5];
                    int numQueries = 0;
                    while ((line = in.readLine()) != null) {
                        SoftTFIDFDictionary.doLookup(dict, d, line, true, stats);
                        ++numQueries;
                    }
                    System.out.println("optimized time:   " + stats[0]);
                    System.out.println("baseline time:    " + stats[1]);
                    System.out.println("speedup:          " + stats[1] / stats[0]);
                    System.out.println("optimized values: " + stats[2]);
                    System.out.println("baseline values:  " + stats[3]);
                    System.out.println("percent complete: " + stats[4] / (double)numQueries);
                } else {
                    for (int i = 2; i < argv.length; ++i) {
                        SoftTFIDFDictionary.doLookup(dict, d, argv[i], false, null);
                    }
                }
            } else {
                dict.setWindowSize(2);
                System.out.println("loading...");
                dict.loadAliases(new File(argv[0]));
                System.out.println("loaded " + dict.numTokens + " tokens");
                System.out.println("window\ttime\t#pairs\tpairs/token");
                DecimalFormat fmt = new DecimalFormat("0.000");
                for (int i = 1; i < argv.length; ++i) {
                    int w = Integer.parseInt(argv[i]);
                    dict.setWindowSize(w);
                    long start = System.currentTimeMillis();
                    dict.refreeze();
                    double elapsedSec = (double)(System.currentTimeMillis() - start) / 1000.0;
                    double tot = dict.getNumberOfSimilarTokenPairs();
                    System.out.println(w + "\t" + fmt.format(elapsedSec) + "\t" + tot + "\t" + fmt.format(tot / (double)dict.numTokens));
                }
            }
        }
    }

    private static SoftTFIDFDictionary loadSomehow(String fileName) throws IOException, ClassNotFoundException {
        SoftTFIDFDictionary dict = null;
        long start0 = System.currentTimeMillis();
        if (fileName.endsWith(".list")) {
            System.out.println("loading aliases...");
            dict = new SoftTFIDFDictionary();
            dict.loadAliases(new File(fileName));
        } else {
            System.out.println("restoring...");
            dict = SoftTFIDFDictionary.restore(new File(fileName));
        }
        double elapsedSec0 = (double)(System.currentTimeMillis() - start0) / 1000.0;
        System.out.println("loaded in " + elapsedSec0 + " sec");
        long start1 = System.currentTimeMillis();
        System.out.println("freezing...");
        dict.freeze();
        double elapsedSec1 = (double)(System.currentTimeMillis() - start1) / 1000.0;
        System.out.println("frozen in " + elapsedSec1 + " sec");
        System.out.println("total i/o " + (elapsedSec1 + elapsedSec0) + " sec");
        return dict;
    }

    private static void doLookup(SoftTFIDFDictionary dict, double d, String s2, boolean compare, double[] stats) {
        System.out.println("lookup: " + s2);
        long start1 = System.currentTimeMillis();
        int n1 = dict.lookup(d, s2);
        double elapsedSec1 = (double)(System.currentTimeMillis() - start1) / 1000.0;
        dict.showLookup(n1);
        ArrayList saved = new ArrayList(dict.result);
        if (compare) {
            long start2 = System.currentTimeMillis();
            int n2 = dict.slowLookup(d, s2);
            double elapsedSec2 = (double)(System.currentTimeMillis() - start2) / 1000.0;
            SoftTFIDFDictionary.collectStats(elapsedSec1, elapsedSec2, saved, dict.result, stats);
            boolean differentFromBaseline = false;
            if (n1 != n2) {
                differentFromBaseline = true;
            } else {
                for (int j = 0; j < n1; ++j) {
                    LookupResult savedj = (LookupResult)saved.get(j);
                    if (dict.getResult(j).equals(savedj.found) && dict.getScore(j) == savedj.score) continue;
                    differentFromBaseline = true;
                }
            }
            if (differentFromBaseline) {
                System.out.println("baseline:");
                dict.showLookup(n2);
            }
        }
    }

    private static void collectStats(double elapsedSec1, double elapsedSec2, List saved, List result, double[] stats) {
        int i;
        stats[0] = stats[0] + elapsedSec1;
        stats[1] = stats[1] + elapsedSec2;
        HashSet<Object> fastVals = new HashSet<Object>();
        HashSet<Object> slowVals = new HashSet<Object>();
        for (i = 0; i < saved.size(); ++i) {
            fastVals.add(((LookupResult)saved.get((int)i)).value);
        }
        stats[2] = stats[2] + (double)fastVals.size();
        for (i = 0; i < result.size(); ++i) {
            slowVals.add(((LookupResult)result.get((int)i)).value);
        }
        stats[3] = stats[3] + (double)slowVals.size();
        if (fastVals.size() == slowVals.size()) {
            stats[4] = stats[4] + 1.0;
        }
    }
}

