/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss.expt;

import com.wcohen.ss.abbvGapsHmm.Acronym;
import com.wcohen.ss.abbvGapsHmm.AlignmentPredictionModel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractAbbreviations {
    public static String SEPARATOR = "#_#";
    private String _input;
    private String _output;
    private String _gold;
    private String _train = "./train";
    private AlignmentPredictionModel _alignPredictor = null;
    private Map<String, Integer> _strToID = null;
    private Map<Integer, Set<String>> _idToStr = null;
    private Map<String, String> _strToSrc = null;

    public ExtractAbbreviations(String input, String output, String train, String gold) {
        this._input = input;
        this._output = output;
        this._train = train;
        this._gold = gold;
    }

    public void run() throws IOException {
        this.loadPredictor();
        this.setTrainDir(this._train);
        this.predictAndTest(AlignmentPredictionModel.loadTrainingCorpus(this._input), AlignmentPredictionModel.loadLabels(this._gold));
    }

    protected void mkdir(String dir2) {
        File f = new File(dir2);
        f.mkdirs();
    }

    protected void setTrainDir(String trainDir) {
        this._alignPredictor.setTrainingDataDir(trainDir + "/");
        this._alignPredictor.setModelParamsFile(trainDir + "/hmmModelParams.txt");
        this._alignPredictor.trainIfNeeded();
    }

    protected AlignmentPredictionModel loadPredictor() {
        if (this._alignPredictor == null) {
            try {
                this._alignPredictor = new AlignmentPredictionModel();
            }
            catch (IOException e) {
                System.err.println("Unable to load AlignmentPredictionModel");
                e.printStackTrace();
                System.exit(1);
            }
        }
        return this._alignPredictor;
    }

    protected void predictAndTest(List<String> corpus, List<Map<String, String>> trueLabels) throws IOException {
        Stats totalStats = new Stats();
        String output_abbvs = "./" + this._output + "_abbvs";
        String output_strings = "./" + this._output + "_strings";
        BufferedWriter bw_abbvs = new BufferedWriter(new FileWriter(output_abbvs));
        BufferedWriter bw_strings = new BufferedWriter(new FileWriter(output_strings));
        this._strToID = new HashMap<String, Integer>();
        this._idToStr = new HashMap<Integer, Set<String>>();
        this._strToSrc = new HashMap<String, String>();
        for (int docID = 0; docID < corpus.size(); ++docID) {
            Stats currStats = this.predictAndTest(docID, corpus, trueLabels, bw_abbvs);
            if (trueLabels == null) continue;
            totalStats.TP += currStats.TP;
            totalStats.FP += currStats.FP;
            totalStats.FN += currStats.FN;
            totalStats.precision += currStats.precision;
            totalStats.recall += currStats.recall;
            totalStats.F1 += currStats.F1;
        }
        this.outputPairs(bw_strings);
        bw_abbvs.close();
        bw_strings.close();
        if (trueLabels != null) {
            System.out.println("Avg TP: " + (double)totalStats.TP / (double)corpus.size());
            System.out.println("Avg FP: " + (double)totalStats.FP / (double)corpus.size());
            System.out.println("Avg Precision: " + (double)totalStats.precision / (double)corpus.size());
            System.out.println("Avg Recall: " + (double)totalStats.recall / (double)corpus.size());
            System.out.println("Avg F1: " + (double)totalStats.F1 / (double)corpus.size());
            float tot_precision = totalStats.TP + totalStats.FP == 0 ? 1.0f : new Float(totalStats.TP).floatValue() / new Float(totalStats.TP + totalStats.FP).floatValue();
            float tot_recall = (float)totalStats.TP / new Float(totalStats.TP + totalStats.FN).floatValue();
            float tot_F1 = 2.0f * (tot_precision * tot_recall / (tot_precision + tot_recall));
            System.out.println("Total Precision: " + (double)tot_precision / (double)corpus.size());
            System.out.println("Total Recall: " + (double)tot_recall / (double)corpus.size());
            System.out.println("Total F1: " + (double)tot_F1 / (double)corpus.size());
        }
    }

    protected String outputAbbvs(Map<String, Acronym> predictions) {
        String out = "";
        for (String sf : predictions.keySet()) {
            String lf = predictions.get((Object)sf)._longForm;
            out = out + sf + "\t" + lf + "#_#";
        }
        return out;
    }

    protected void addAbbreviationPairs(Map<String, Acronym> predictions) {
        for (String sf : predictions.keySet()) {
            String lf = predictions.get((Object)sf)._longForm;
            Integer sf_id = this._strToID.get(sf);
            Integer lf_id = this._strToID.get(lf);
            if (sf_id == null && lf_id == null) {
                Integer id = this._strToID.size();
                this._strToID.put(sf, id);
                this._strToID.put(lf, id);
                this._idToStr.put(id, new HashSet());
                this._idToStr.get(id).add(sf);
                this._idToStr.get(id).add(lf);
            } else if (sf_id == null && lf_id != null) {
                this._strToID.put(sf, lf_id);
                this._idToStr.get(lf_id).add(sf);
            } else if (lf_id == null && sf_id != null) {
                this._strToID.put(lf, sf_id);
                this._idToStr.get(sf_id).add(lf);
            } else if (sf_id != lf_id) {
                this._strToID.put(lf, sf_id);
                for (String str : this._idToStr.get(lf_id)) {
                    this._strToID.put(str, sf_id);
                    this._idToStr.get(sf_id).add(str);
                }
                this._idToStr.remove(lf_id);
            }
            this._strToSrc.put(sf, "short");
            this._strToSrc.put(lf, "long");
        }
    }

    protected void outputPairs(BufferedWriter bw) throws IOException {
        Integer[] ids = this._idToStr.keySet().toArray(new Integer[0]);
        for (int newId = 0; newId < ids.length; ++newId) {
            int oldId = ids[newId];
            for (String str : this._idToStr.get(oldId)) {
                bw.write(this._strToSrc.get(str) + "\t" + newId + "\t" + str + "\n");
            }
        }
    }

    protected Stats predictAndTest(int docID, List<String> corpus, List<Map<String, String>> trueLabels, BufferedWriter bw_abbvs) throws IOException {
        String text = corpus.get(docID);
        Collection<Acronym> all_predictions = this._alignPredictor.predict(text);
        Map<String, Acronym> final_predictions = this._alignPredictor.acronymsArrayToMap(all_predictions);
        bw_abbvs.write(this.outputAbbvs(final_predictions) + "\n");
        this.addAbbreviationPairs(final_predictions);
        if (trueLabels != null) {
            Map<String, String> docTrueLabels = trueLabels.get(docID);
            Stats stats = new Stats();
            stats.FN = docTrueLabels.size();
            stats.TP = 0;
            stats.FP = 0;
            for (String shortFort : final_predictions.keySet()) {
                String predictedLongForm = final_predictions.get((Object)shortFort)._longForm;
                if (predictedLongForm == null) {
                    ++stats.FP;
                    continue;
                }
                String trueLongForm = docTrueLabels.get(shortFort);
                if (predictedLongForm.toLowerCase().equals(trueLongForm.toLowerCase())) {
                    ++stats.FP;
                    continue;
                }
                ++stats.TP;
                --stats.FN;
            }
            stats.precision = stats.TP + stats.FP == 0 ? 1.0f : new Float(stats.TP).floatValue() / new Float(stats.TP + stats.FP).floatValue();
            stats.recall = (float)stats.TP / new Float(stats.TP + stats.FN).floatValue();
            stats.F1 = 2.0f * (stats.precision * stats.recall / (stats.precision + stats.recall));
            return stats;
        }
        return null;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: ExtractAbbreviations input experiment_name [gold-file] [train-dir] \n\ninput - Corpus file (one line per file) from which abbreviations will be extracted.\nexperiment_name - The experiment name will be used to create these output files:\n                 './<name>_abbvs' - contains the abbreviations extracted from the corpus, in a format similar to './train/abbvAlign_pairs.txt', the abbreviations from each document are concatenated to one line.\n                 './<name>_strings' - contains pairs of short and long forms of abbreviations extracted from the corpus, in a format that can be used for a matching experiment (using MatchExpt, AbbreviationsBlocker, and AbbreviationAlignment distance).train - Optional. Directory containing a corpus file named 'abbvAlign_corpus.txt' for training the abbreviation HMM. Corpus format is one line per file.\n                 The model parameters will be saved in this directory under 'hmmModelParams.txt' so the HMM will only have to be trained once.\n                 Default = './train/'\ngold - Optional. If available, the gold data will be used to estimate the performance of the HMM on the input corpus.\n                 './train/abbvAlign_pairs.txt' is a sample gold file for the 'train/abbvAlign_corpus.txt corpus.'\n                 Default = by default, no gold data is given and no estimation is done.");
            System.exit(1);
        }
        String input = args[0];
        String output = args[1];
        String gold = null;
        if (args.length > 2) {
            gold = args[2];
        }
        String train = "./train";
        if (args.length > 3) {
            train = args[3];
        }
        ExtractAbbreviations tester = new ExtractAbbreviations(input, output, train, gold);
        try {
            tester.run();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public class Stats {
        public int FN = 0;
        public int FP = 0;
        public int TP;
        public int TN = 0;
        public float precision = 0.0f;
        public float recall = 0.0f;
        public float F1 = 0.0f;
    }
}

