/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss.abbvGapsHmm;

public final class Matrix3D {
    private final int M;
    private final int N;
    private final int K;
    private final double[][][] data;

    public Matrix3D(int M, int N, int K2) {
        this.M = M;
        this.N = N;
        this.K = K2;
        this.data = new double[M][N][K2];
    }

    public Matrix3D(double[][][] data) {
        this.M = data.length;
        this.N = data[0].length;
        this.K = data[0][0].length;
        this.data = new double[this.M][this.N][this.K];
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                for (int l = 0; l < this.K; ++l) {
                    this.data[i][j][l] = data[i][j][l];
                }
            }
        }
    }

    private Matrix3D(Matrix3D A2) {
        this(A2.data);
    }

    public static Matrix3D random(int M, int N, int K2) {
        Matrix3D A2 = new Matrix3D(M, N, K2);
        for (int i = 0; i < M; ++i) {
            for (int j = 0; j < N; ++j) {
                for (int l = 0; l < K2; ++l) {
                    A2.data[i][j][l] = Math.random();
                }
            }
        }
        return A2;
    }

    public static Matrix3D identity(int N) {
        Matrix3D I2 = new Matrix3D(N, N, N);
        for (int i = 0; i < N; ++i) {
            I2.data[i][i][i] = 1.0;
        }
        return I2;
    }

    public Matrix3D plus(Matrix3D B2) {
        Matrix3D A2 = this;
        if (B2.M != A2.M || B2.N != A2.N || B2.K != A2.K) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        Matrix3D C2 = new Matrix3D(this.M, this.N, this.K);
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                for (int l = 0; l < this.K; ++l) {
                    C2.data[i][j][l] = A2.data[i][j][l] + B2.data[i][j][l];
                }
            }
        }
        return C2;
    }

    public Matrix3D minus(Matrix3D B2) {
        Matrix3D A2 = this;
        if (B2.M != A2.M || B2.N != A2.N || B2.K != A2.K) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        Matrix3D C2 = new Matrix3D(this.M, this.N, this.K);
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                for (int l = 0; l < this.K; ++l) {
                    C2.data[i][j][l] = A2.data[i][j][l] - B2.data[i][j][l];
                }
            }
        }
        return C2;
    }

    public boolean eq(Matrix3D B2) {
        Matrix3D A2 = this;
        if (B2.M != A2.M || B2.N != A2.N || B2.K != A2.K) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                for (int l = 0; l < this.K; ++l) {
                    if (A2.data[i][j][l] == B2.data[i][j][l]) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public Matrix3D times(double s2) {
        Matrix3D A2 = this;
        Matrix3D C2 = new Matrix3D(A2);
        for (int i = 0; i < C2.M; ++i) {
            for (int j = 0; j < C2.N; ++j) {
                int l = 0;
                while (l < C2.K) {
                    double[] dArray = C2.data[i][j];
                    int n = l++;
                    dArray[n] = dArray[n] * s2;
                }
            }
        }
        return C2;
    }

    public double at(int i, int j, int l) {
        return this.data[i][j][l];
    }

    public void set(int i, int j, int l, double val) {
        this.data[i][j][l] = val;
    }

    public void add(int i, int j, int l, double val) {
        double[] dArray = this.data[i][j];
        int n = l;
        dArray[n] = dArray[n] + val;
    }

    public void mul(int i, int j, int l, double val) {
        double[] dArray = this.data[i][j];
        int n = l;
        dArray[n] = dArray[n] * val;
    }

    public int dimension1() {
        return this.M;
    }

    public int dimension2() {
        return this.N;
    }

    public int dimension3() {
        return this.K;
    }
}

