/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss;

import com.wcohen.ss.AbstractStringDistance;
import com.wcohen.ss.api.StringDistance;
import com.wcohen.ss.api.StringWrapper;

public class WinklerRescorer
extends AbstractStringDistance {
    private StringDistance innerDistance;

    public WinklerRescorer(StringDistance innerDistance) {
        this.innerDistance = innerDistance;
    }

    public String toString() {
        return "[WinklerRescorer:" + this.innerDistance + "]";
    }

    public double score(StringWrapper s2, StringWrapper t) {
        double dist = this.innerDistance.score(s2, t);
        if (dist < 0.0 || dist > 1.0) {
            throw new IllegalArgumentException("innerDistance should produce scores between 0 and 1");
        }
        int prefLength = WinklerRescorer.commonPrefixLength(4, s2.unwrap(), t.unwrap());
        dist += (double)prefLength * 0.1 * (1.0 - dist);
        return dist;
    }

    public String explainScore(StringWrapper s2, StringWrapper t) {
        double dist = this.innerDistance.score(s2, t);
        int prefLength = WinklerRescorer.commonPrefixLength(4, s2.unwrap(), t.unwrap());
        dist += (double)prefLength * 0.1 * (1.0 - dist);
        StringBuffer buf = new StringBuffer("");
        buf.append("original score using " + this.innerDistance + ":\n");
        buf.append(this.innerDistance.explainScore(s2, t) + "\n");
        buf.append("prefLength = max(4,commonPrefixLength) = " + prefLength + "\n");
        buf.append("Corrected score = dist + " + prefLength + "/10 * (1-dist) = " + this.score(s2, t) + "\n");
        return buf.toString();
    }

    private static int commonPrefixLength(int maxLength, String common1, String common2) {
        int n = Math.min(maxLength, Math.min(common1.length(), common2.length()));
        for (int i = 0; i < n; ++i) {
            if (common1.charAt(i) == common2.charAt(i)) continue;
            return i;
        }
        return n;
    }

    public StringWrapper prepare(String s2) {
        return this.innerDistance.prepare(s2);
    }
}

