/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss;

import com.wcohen.ss.AbstractStatisticalTokenDistance;
import com.wcohen.ss.BagOfTokens;
import com.wcohen.ss.PrintfFormat;
import com.wcohen.ss.api.StringWrapper;
import com.wcohen.ss.api.Token;
import com.wcohen.ss.api.Tokenizer;
import com.wcohen.ss.tokens.SimpleTokenizer;
import java.util.Iterator;

public class TokenFelligiSunter
extends AbstractStatisticalTokenDistance {
    private Tokenizer tokenizer;
    private double mismatchFactor = 0.5;
    private boolean oversimplified = false;

    public TokenFelligiSunter(Tokenizer tokenizer, double mismatchFactor) {
        this.tokenizer = tokenizer;
        this.mismatchFactor = mismatchFactor;
    }

    public TokenFelligiSunter() {
        this(SimpleTokenizer.DEFAULT_TOKENIZER, 0.5);
    }

    public void setMismatchFactor(double d) {
        this.mismatchFactor = d;
    }

    public void setMismatchFactor(Double d) {
        this.mismatchFactor = d;
    }

    public double score(StringWrapper s2, StringWrapper t) {
        BagOfTokens sBag = (BagOfTokens)s2;
        BagOfTokens tBag = (BagOfTokens)t;
        double sim = 0.0;
        Iterator i = sBag.tokenIterator();
        while (i.hasNext()) {
            Token tok = (Token)i.next();
            if (tBag.contains(tok)) {
                if (this.oversimplified) {
                    sim += tBag.getWeight(tok);
                    continue;
                }
                double p = Math.exp(-tBag.getWeight(tok));
                sim -= Math.log(1.0 - Math.exp((double)(sBag.size() * tBag.size()) * Math.log(1.0 - p * p)));
                continue;
            }
            if (!this.oversimplified) continue;
            sim -= sBag.getWeight(tok) * this.mismatchFactor;
        }
        return sim;
    }

    public StringWrapper prepare(String s2) {
        BagOfTokens bag = new BagOfTokens(s2, this.tokenizer.tokenize(s2));
        double normalizer = 0.0;
        Iterator i = bag.tokenIterator();
        while (i.hasNext()) {
            Token tok = (Token)i.next();
            if (this.collectionSize > 0) {
                Integer dfInteger = (Integer)this.documentFrequency.get(tok);
                double df = dfInteger == null ? 1.0 : (double)dfInteger.intValue();
                double w = -Math.log(df / (double)this.collectionSize);
                bag.setWeight(tok, w);
                continue;
            }
            bag.setWeight(tok, Math.log(10.0));
        }
        return bag;
    }

    public String explainScore(StringWrapper s2, StringWrapper t) {
        BagOfTokens sBag = (BagOfTokens)s2;
        BagOfTokens tBag = (BagOfTokens)t;
        StringBuffer buf = new StringBuffer("");
        PrintfFormat fmt = new PrintfFormat("%.3f");
        buf.append("Common tokens: ");
        Iterator i = sBag.tokenIterator();
        while (i.hasNext()) {
            Token tok = (Token)i.next();
            if (!tBag.contains(tok)) continue;
            buf.append(" " + tok.getValue() + ": ");
            buf.append(fmt.sprintf(tBag.getWeight(tok)));
        }
        buf.append("\nscore = " + this.score(s2, t));
        return buf.toString();
    }

    public String toString() {
        return "[TokenFelligiSunter]";
    }

    public static void main(String[] argv) {
        TokenFelligiSunter.doMain(new TokenFelligiSunter(), argv);
    }
}

