/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss;

import com.wcohen.ss.AbstractStatisticalTokenDistance;
import com.wcohen.ss.AbstractStringDistance;
import com.wcohen.ss.BagOfTokens;
import com.wcohen.ss.api.StringWrapper;
import com.wcohen.ss.api.StringWrapperIterator;
import com.wcohen.ss.api.Token;
import com.wcohen.ss.api.Tokenizer;
import com.wcohen.ss.tokens.TagLinkToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class TagLink
extends AbstractStatisticalTokenDistance {
    private AbstractStringDistance tokenDistance;
    private static final AbstractStringDistance DEFAULT_TOKEN_METRIC = new TagLinkToken();

    public TagLink() {
        this(DEFAULT_TOKEN_METRIC);
    }

    public TagLink(AbstractStringDistance tokenDistance) {
        this.tokenDistance = tokenDistance;
    }

    public TagLink(Tokenizer tokenizer, AbstractStringDistance tokenDistance) {
        super(tokenizer);
        this.tokenDistance = tokenDistance;
    }

    public TagLink(String[] dataSetArray) {
        this(dataSetArray, DEFAULT_TOKEN_METRIC);
    }

    public TagLink(String[] dataSetArray, AbstractStringDistance tokenDistance) {
        this.tokenDistance = tokenDistance;
        Vector<StringWrapper> StringWrapperVector = new Vector<StringWrapper>();
        for (int i = 0; i < dataSetArray.length; ++i) {
            StringWrapperVector.add(this.prepare(dataSetArray[i]));
        }
        Iterator it = StringWrapperVector.iterator();
        this.train((StringWrapperIterator)it);
    }

    private double getMinStringSize(String[] tTokens, String[] uTokens) {
        int i;
        double tSize = 0.0;
        double uSize = 0.0;
        for (i = 0; i < tTokens.length; ++i) {
            tSize += (double)tTokens[i].length();
        }
        for (i = 0; i < uTokens.length; ++i) {
            uSize += (double)uTokens[i].length();
        }
        return Math.min(tSize, uSize);
    }

    public double score(StringWrapper s2, StringWrapper t) {
        this.checkTrainingHasHappened(s2, t);
        UnitVector sBag = this.asUnitVector(s2);
        UnitVector tBag = this.asUnitVector(t);
        if (s2.unwrap().equals(t.unwrap())) {
            return 1.0;
        }
        String[] sTokens = this.getTokenArray(sBag);
        String[] tTokens = this.getTokenArray(tBag);
        double[] sIdfArray = this.getIDFArray(sBag);
        double[] tIdfArray = this.getIDFArray(tBag);
        return this.algorithm1(sTokens, tTokens, sIdfArray, tIdfArray);
    }

    protected UnitVector asUnitVector(StringWrapper w) {
        if (w instanceof UnitVector) {
            return (UnitVector)w;
        }
        if (w instanceof BagOfTokens) {
            return new UnitVector((BagOfTokens)w);
        }
        return new UnitVector(w.unwrap(), this.tokenizer.tokenize(w.unwrap()));
    }

    public StringWrapper prepare(String s2) {
        return new UnitVector(s2, this.tokenizer.tokenize(s2));
    }

    private double[] getIDFArray(BagOfTokens bag) {
        double[] idfArray = new double[bag.size()];
        Iterator it = bag.tokenIterator();
        int i = 0;
        while (it.hasNext()) {
            Token tok = (Token)it.next();
            idfArray[i] = bag.getWeight(tok);
            ++i;
        }
        return idfArray;
    }

    private double algorithm1(String[] tTokens, String[] uTokens, double[] tIdfArray, double[] uIdfArray) {
        ArrayList candidateList = this.obtainCandidateList(tTokens, uTokens, tIdfArray, uIdfArray);
        this.sortCandidateList(candidateList);
        double scoreValue = 0.0;
        HashMap tMap = new HashMap();
        HashMap uMap = new HashMap();
        for (Candidates actualCandidates : candidateList) {
            Integer tPos = new Integer(actualCandidates.getTPos());
            Integer uPos = new Integer(actualCandidates.getUPos());
            if (tMap.containsKey(tPos) || uMap.containsKey(uPos)) continue;
            double actualScore = actualCandidates.getScore();
            scoreValue += actualScore;
            tMap.put(tPos, null);
            uMap.put(uPos, null);
        }
        return scoreValue;
    }

    private String[] getTokenArray(BagOfTokens bag) {
        String[] stringArray = new String[bag.size()];
        Iterator it = bag.tokenIterator();
        int i = 0;
        while (it.hasNext()) {
            Token tok = (Token)it.next();
            stringArray[i] = tok.getValue();
            ++i;
        }
        return stringArray;
    }

    public String explainScore(StringWrapper s2, StringWrapper t) {
        BagOfTokens sBag = (BagOfTokens)s2;
        BagOfTokens tBag = (BagOfTokens)t;
        StringBuffer buff = new StringBuffer();
        buff.append("\n\t*****TagLink String Distance*****");
        if (s2.unwrap().equals(t.unwrap())) {
            buff.append("\nScore(S,T)=1.0\n");
        } else {
            int i;
            int i2;
            String[] sTokens = this.getTokenArray(sBag);
            String[] tTokens = this.getTokenArray(tBag);
            buff.append("\nS={");
            for (i2 = 0; i2 < sTokens.length; ++i2) {
                buff.append(sTokens[i2] + ", ");
            }
            buff.append("}\n");
            buff.append("T={");
            for (i2 = 0; i2 < tTokens.length; ++i2) {
                buff.append(tTokens[i2] + ", ");
            }
            buff.append("}\n");
            double minStringSize = this.getMinStringSize(sTokens, tTokens);
            buff.append("min(|S|,|T|)=" + minStringSize + "\n");
            buff.append("\nIDF weights:\n");
            buff.append("Ti\tai(Ti)\n");
            double[] tIdfArray = this.getIDFArray(sBag);
            double[] uIdfArray = this.getIDFArray(tBag);
            for (i = 0; i < tIdfArray.length; ++i) {
                buff.append(sTokens[i] + "\t" + this.round(tIdfArray[i]) + "\n");
            }
            buff.append("\nTj\taj(Tj)\n");
            for (i = 0; i < uIdfArray.length; ++i) {
                buff.append(tTokens[i] + "\t" + this.round(uIdfArray[i]) + "\n");
            }
            buff.append("\nScores:\n");
            buff.append("Si\tTj\tScore_ij(Si,Tj)\tIDFij(Si,Tj)\tMRij(Si,Tj)\tScore_ij\n");
            ArrayList<Candidates> candidateList = new ArrayList<Candidates>();
            for (int i3 = 0; i3 < sTokens.length; ++i3) {
                int lastTr = -1;
                boolean flag = false;
                for (int j = 0; j < tTokens.length && !flag; ++j) {
                    int tr = Math.abs(i3 - j);
                    if (lastTr >= 0 && lastTr < tr) {
                        flag = true;
                        continue;
                    }
                    String tTok = sTokens[i3];
                    String uTok = tTokens[j];
                    double innerScore = this.tokenDistance.score(tTok, uTok);
                    if (!(innerScore >= 0.0)) continue;
                    double MR = 0.0;
                    MR = innerScore == 1.0 ? (double)sTokens[i3].length() : ((TagLinkToken)this.tokenDistance).getMatched();
                    double IDF = tIdfArray[i3] * uIdfArray[j];
                    double weight = (IDF + (MR /= minStringSize)) / 2.0;
                    if (innerScore == 1.0) {
                        lastTr = tr;
                    }
                    buff.append(tTok + "\t" + uTok + "\t" + this.round(innerScore) + "\t" + this.round(IDF) + "\t" + this.round(MR) + "\t" + this.round(innerScore * weight) + "\n");
                    candidateList.add(new Candidates(i3, j, innerScore * weight));
                }
            }
            this.sortCandidateList(candidateList);
            buff.append("\nCommon tokens (Algorithm 1):\n");
            buff.append("Ti\tUj\tSij*Xij\n");
            double score = 0.0;
            HashMap tMap = new HashMap();
            HashMap uMap = new HashMap();
            for (Candidates actualCandidates : candidateList) {
                Integer tPos = new Integer(actualCandidates.getTPos());
                Integer uPos = new Integer(actualCandidates.getUPos());
                if (tMap.containsKey(tPos) || uMap.containsKey(uPos)) continue;
                double tokenScore = actualCandidates.getScore();
                score += tokenScore;
                tMap.put(tPos, null);
                uMap.put(uPos, null);
                buff.append(sTokens[tPos] + "\t" + tTokens[uPos] + "\t" + this.round(tokenScore) + "\n");
            }
            buff.append("\nS(T,U)=" + this.round(score) + "\n");
        }
        return buff.toString();
    }

    private ArrayList obtainCandidateList(String[] tTokens, String[] uTokens, double[] tIdfArray, double[] uIdfArray) {
        ArrayList<Candidates> candidateList = new ArrayList<Candidates>();
        double minStringSize = this.getMinStringSize(tTokens, uTokens);
        for (int t = 0; t < tTokens.length; ++t) {
            int lastTr = -1;
            boolean flag = false;
            for (int u = 0; u < uTokens.length && !flag; ++u) {
                int tr = Math.abs(t - u);
                if (lastTr >= 0 && lastTr < tr) {
                    flag = true;
                    continue;
                }
                String tTok = tTokens[t];
                String uTok = uTokens[u];
                double innerScore = this.tokenDistance.score(tTok, uTok);
                if (!(innerScore >= 0.0)) continue;
                double matched = 0.0;
                matched = innerScore == 1.0 ? (double)tTokens[t].length() : ((TagLinkToken)this.tokenDistance).getMatched();
                double weightMatched = matched / minStringSize;
                double weightTFIDF = tIdfArray[t] * uIdfArray[u];
                double weight = (weightTFIDF + weightMatched) / 2.0;
                if (innerScore == 1.0) {
                    lastTr = tr;
                }
                candidateList.add(new Candidates(t, u, innerScore * weight));
            }
        }
        return candidateList;
    }

    private void sortCandidateList(ArrayList list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                double scoreT = ((Candidates)o1).getScore();
                double scoreU = ((Candidates)o2).getScore();
                if (scoreU > scoreT) {
                    return 1;
                }
                if (scoreU < scoreT) {
                    return -1;
                }
                return 0;
            }
        });
    }

    public String toString() {
        return "[TagLink_[" + this.tokenDistance.toString() + "]";
    }

    private double round(double number) {
        int round = (int)(number * 1000.0);
        double rest = number * 1000.0 - (double)round;
        if (rest >= 0.5) {
            ++round;
        }
        return (double)round / 1000.0;
    }

    public static class Candidates {
        private int tPos;
        private int uPos;
        private double score;

        public Candidates(int tPos, int uPos, double score) {
            this.tPos = tPos;
            this.uPos = uPos;
            this.score = score;
        }

        public int getTPos() {
            return this.tPos;
        }

        public int getUPos() {
            return this.uPos;
        }

        public double getScore() {
            return this.score;
        }
    }

    protected class UnitVector
    extends BagOfTokens {
        public UnitVector(String s2, Token[] tokens) {
            super(s2, tokens);
            this.termFreq2TFIDF();
        }

        public UnitVector(BagOfTokens bag) {
            this(bag.unwrap(), bag.getTokens());
            this.termFreq2TFIDF();
        }

        private void termFreq2TFIDF() {
            Token tok;
            double normalizer = 0.0;
            Iterator i = this.tokenIterator();
            while (i.hasNext()) {
                tok = (Token)i.next();
                if (TagLink.this.collectionSize > 0) {
                    Integer dfInteger = (Integer)TagLink.this.documentFrequency.get(tok);
                    double df = dfInteger == null ? 1.0 : (double)dfInteger.intValue();
                    double w = Math.log(this.getWeight(tok) + 1.0) * Math.log((double)TagLink.this.collectionSize / df);
                    this.setWeight(tok, w);
                    normalizer += w * w;
                    continue;
                }
                this.setWeight(tok, 1.0);
                normalizer += 1.0;
            }
            normalizer = Math.sqrt(normalizer);
            i = this.tokenIterator();
            while (i.hasNext()) {
                tok = (Token)i.next();
                this.setWeight(tok, this.getWeight(tok) / normalizer);
            }
        }
    }
}

